/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.eac;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ParsingException;
import com.aspose.psd.internal.bouncycastle.asn1.eac.CVCertificate;
import com.aspose.psd.internal.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.aspose.psd.internal.bouncycastle.eac.EACException;
import com.aspose.psd.internal.bouncycastle.eac.EACIOException;
import com.aspose.psd.internal.bouncycastle.eac.operator.EACSignatureVerifier;
import java.io.IOException;
import java.io.OutputStream;

public class EACCertificateHolder {
    private CVCertificate a;

    private static CVCertificate a(byte[] byArray) throws IOException {
        try {
            return CVCertificate.getInstance(byArray);
        }
        catch (ClassCastException classCastException) {
            throw new EACIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EACIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            if (aSN1ParsingException.getCause() instanceof IOException) {
                throw (IOException)aSN1ParsingException.getCause();
            }
            throw new EACIOException("malformed data: " + aSN1ParsingException.getMessage(), aSN1ParsingException);
        }
    }

    public EACCertificateHolder(byte[] byArray) throws IOException {
        this(EACCertificateHolder.a(byArray));
    }

    public EACCertificateHolder(CVCertificate cVCertificate) {
        this.a = cVCertificate;
    }

    public CVCertificate toASN1Structure() {
        return this.a;
    }

    public PublicKeyDataObject getPublicKeyDataObject() {
        return this.a.getBody().getPublicKey();
    }

    public boolean isSignatureValid(EACSignatureVerifier eACSignatureVerifier) throws EACException {
        try {
            OutputStream outputStream = eACSignatureVerifier.getOutputStream();
            outputStream.write(this.a.getBody().getEncoded("DER"));
            outputStream.close();
            return eACSignatureVerifier.verify(this.a.getSignature());
        }
        catch (Exception exception) {
            throw new EACException("unable to process signature: " + exception.getMessage(), exception);
        }
    }
}

