/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.tls;

import com.aspose.psd.internal.bouncycastle.crypto.tls.HeartbeatMessageType;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsContext;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsUtils;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.io.Streams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HeartbeatMessage {
    protected short type;
    protected byte[] payload;
    protected int paddingLength;

    public HeartbeatMessage(short s2, byte[] byArray, int n2) {
        if (!HeartbeatMessageType.isValid(s2)) {
            throw new IllegalArgumentException("'type' is not a valid HeartbeatMessageType value");
        }
        if (byArray == null || byArray.length >= 65536) {
            throw new IllegalArgumentException("'payload' must have length < 2^16");
        }
        if (n2 < 16) {
            throw new IllegalArgumentException("'paddingLength' must be at least 16");
        }
        this.type = s2;
        this.payload = byArray;
        this.paddingLength = n2;
    }

    public void encode(TlsContext tlsContext, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.type, outputStream);
        TlsUtils.checkUint16(this.payload.length);
        TlsUtils.writeUint16(this.payload.length, outputStream);
        outputStream.write(this.payload);
        byte[] byArray = new byte[this.paddingLength];
        tlsContext.getNonceRandomGenerator().nextBytes(byArray);
        outputStream.write(byArray);
    }

    public static HeartbeatMessage parse(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8(inputStream);
        if (!HeartbeatMessageType.isValid(s2)) {
            throw new TlsFatalAlert(47);
        }
        int n2 = TlsUtils.readUint16(inputStream);
        a a2 = new a();
        Streams.pipeAll(inputStream, a2);
        byte[] byArray = a2.a(n2);
        if (byArray == null) {
            return null;
        }
        int n3 = a2.size() - byArray.length;
        return new HeartbeatMessage(s2, byArray, n3);
    }

    static class a
    extends ByteArrayOutputStream {
        a() {
        }

        byte[] a(int n2) {
            int n3 = n2 + 16;
            if (this.count < n3) {
                return null;
            }
            return Arrays.copyOf(this.buf, n2);
        }
    }
}

