/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.signers;

import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.CryptoException;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.Signer;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.crypto.params.RSABlindingParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.RSAKeyParameters;
import java.security.SecureRandom;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest a;
    private Digest b;
    private AsymmetricBlockCipher c;
    private SecureRandom d;
    private int e;
    private int f;
    private boolean g;
    private int h;
    private int i;
    private byte[] j;
    private byte[] k;
    private byte[] l;
    private byte m;

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n2) {
        this(asymmetricBlockCipher, digest, n2, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, int n2) {
        this(asymmetricBlockCipher, digest, digest2, n2, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n2, byte by2) {
        this(asymmetricBlockCipher, digest, digest, n2, by2);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, int n2, byte by2) {
        this.c = asymmetricBlockCipher;
        this.a = digest;
        this.b = digest2;
        this.e = digest.getDigestSize();
        this.f = digest2.getDigestSize();
        this.g = false;
        this.h = n2;
        this.j = new byte[n2];
        this.k = new byte[8 + n2 + this.e];
        this.m = by2;
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest, byArray, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest2, byArray, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray, byte by2) {
        this.c = asymmetricBlockCipher;
        this.a = digest;
        this.b = digest2;
        this.e = digest.getDigestSize();
        this.f = digest2.getDigestSize();
        this.g = true;
        this.h = byArray.length;
        this.j = byArray;
        this.k = new byte[8 + this.h + this.e];
        this.m = by2;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        CipherParameters cipherParameters3;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters3 = (ParametersWithRandom)cipherParameters;
            cipherParameters2 = ((ParametersWithRandom)cipherParameters3).getParameters();
            this.d = ((ParametersWithRandom)cipherParameters3).getRandom();
        } else {
            cipherParameters2 = cipherParameters;
            if (bl2) {
                this.d = new SecureRandom();
            }
        }
        if (cipherParameters2 instanceof RSABlindingParameters) {
            cipherParameters3 = ((RSABlindingParameters)cipherParameters2).getPublicKey();
            this.c.init(bl2, cipherParameters);
        } else {
            cipherParameters3 = (RSAKeyParameters)cipherParameters2;
            this.c.init(bl2, cipherParameters2);
        }
        this.i = ((RSAKeyParameters)cipherParameters3).getModulus().bitLength() - 1;
        if (this.i < 8 * this.e + 8 * this.h + 9) {
            throw new IllegalArgumentException("key too small for specified hash and salt lengths");
        }
        this.l = new byte[(this.i + 7) / 8];
        this.reset();
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void update(byte by2) {
        this.a.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        this.a.doFinal(this.k, this.k.length - this.e - this.h);
        if (this.h != 0) {
            if (!this.g) {
                this.d.nextBytes(this.j);
            }
            System.arraycopy(this.j, 0, this.k, this.k.length - this.h, this.h);
        }
        byte[] byArray = new byte[this.e];
        this.a.update(this.k, 0, this.k.length);
        this.a.doFinal(byArray, 0);
        this.l[this.l.length - this.h - 1 - this.e - 1] = 1;
        System.arraycopy(this.j, 0, this.l, this.l.length - this.h - this.e - 1, this.h);
        byte[] byArray2 = this.a(byArray, 0, byArray.length, this.l.length - this.e - 1);
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            int n2 = i2;
            this.l[n2] = (byte)(this.l[n2] ^ byArray2[i2]);
        }
        this.l[0] = (byte)(this.l[0] & 255 >> this.l.length * 8 - this.i);
        System.arraycopy(byArray, 0, this.l, this.l.length - this.e - 1, this.e);
        this.l[this.l.length - 1] = this.m;
        byte[] byArray3 = this.c.processBlock(this.l, 0, this.l.length);
        this.a(this.l);
        return byArray3;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        int n2;
        byte[] byArray2;
        this.a.doFinal(this.k, this.k.length - this.e - this.h);
        try {
            byArray2 = this.c.processBlock(byArray, 0, byArray.length);
            System.arraycopy(byArray2, 0, this.l, this.l.length - byArray2.length, byArray2.length);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.l[this.l.length - 1] != this.m) {
            this.a(this.l);
            return false;
        }
        byArray2 = this.a(this.l, this.l.length - this.e - 1, this.e, this.l.length - this.e - 1);
        for (n2 = 0; n2 != byArray2.length; ++n2) {
            int n3 = n2;
            this.l[n3] = (byte)(this.l[n3] ^ byArray2[n2]);
        }
        this.l[0] = (byte)(this.l[0] & 255 >> this.l.length * 8 - this.i);
        for (n2 = 0; n2 != this.l.length - this.e - this.h - 2; ++n2) {
            if (this.l[n2] == 0) continue;
            this.a(this.l);
            return false;
        }
        if (this.l[this.l.length - this.e - this.h - 2] != 1) {
            this.a(this.l);
            return false;
        }
        if (this.g) {
            System.arraycopy(this.j, 0, this.k, this.k.length - this.h, this.h);
        } else {
            System.arraycopy(this.l, this.l.length - this.h - this.e - 1, this.k, this.k.length - this.h, this.h);
        }
        this.a.update(this.k, 0, this.k.length);
        this.a.doFinal(this.k, this.k.length - this.e);
        n2 = this.l.length - this.e - 1;
        for (int i2 = this.k.length - this.e; i2 != this.k.length; ++i2) {
            if ((this.l[n2] ^ this.k[i2]) != 0) {
                this.a(this.k);
                this.a(this.l);
                return false;
            }
            ++n2;
        }
        this.a(this.k);
        this.a(this.l);
        return true;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.f];
        byte[] byArray4 = new byte[4];
        this.b.reset();
        for (n5 = 0; n5 < n4 / this.f; ++n5) {
            this.a(n5, byArray4);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.f, this.f);
        }
        if (n5 * this.f < n4) {
            this.a(n5, byArray4);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.f, byArray2.length - n5 * this.f);
        }
        return byArray2;
    }
}

