/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.modes;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.modes.AEADBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.modes.KCTRBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.modes.kgcm.KGCMMultiplier;
import com.aspose.psd.internal.bouncycastle.crypto.modes.kgcm.Tables16kKGCMMultiplier_512;
import com.aspose.psd.internal.bouncycastle.crypto.modes.kgcm.Tables4kKGCMMultiplier_128;
import com.aspose.psd.internal.bouncycastle.crypto.modes.kgcm.Tables8kKGCMMultiplier_256;
import com.aspose.psd.internal.bouncycastle.crypto.params.AEADParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;

public class KGCMBlockCipher
implements AEADBlockCipher {
    private static final int a = 64;
    private BlockCipher b;
    private BufferedBlockCipher c;
    private int d;
    private boolean e;
    private byte[] f;
    private byte[] g;
    private byte[] h;
    private KGCMMultiplier i;
    private long[] j;
    private final int k;
    private a l = new a();
    private a m = new a();

    private static KGCMMultiplier a(int n2) {
        switch (n2) {
            case 16: {
                return new Tables4kKGCMMultiplier_128();
            }
            case 32: {
                return new Tables8kKGCMMultiplier_256();
            }
            case 64: {
                return new Tables16kKGCMMultiplier_512();
            }
        }
        throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
    }

    public KGCMBlockCipher(BlockCipher blockCipher) {
        this.b = blockCipher;
        this.c = new BufferedBlockCipher(new KCTRBlockCipher(this.b));
        this.d = -1;
        this.k = this.b.getBlockSize();
        this.f = new byte[this.k];
        this.h = new byte[this.k];
        this.i = KGCMBlockCipher.a(this.k);
        this.j = new long[this.k >>> 3];
        this.g = null;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        KeyParameter keyParameter;
        this.e = bl2;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            byte[] byArray = aEADParameters.getNonce();
            int n2 = this.h.length - byArray.length;
            Arrays.fill(this.h, (byte)0);
            System.arraycopy(byArray, 0, this.h, n2, byArray.length);
            this.f = aEADParameters.getAssociatedText();
            int n3 = aEADParameters.getMacSize();
            if (n3 < 64 || n3 > this.k << 3 || (n3 & 7) != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n3);
            }
            this.d = n3 >>> 3;
            keyParameter = aEADParameters.getKey();
            if (this.f != null) {
                this.processAADBytes(this.f, 0, this.f.length);
            }
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            int n4 = this.h.length - byArray.length;
            Arrays.fill(this.h, (byte)0);
            System.arraycopy(byArray, 0, this.h, n4, byArray.length);
            this.f = null;
            this.d = this.k;
            keyParameter = (KeyParameter)parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("Invalid parameter passed");
        }
        this.g = new byte[this.k];
        this.c.init(true, new ParametersWithIV(keyParameter, this.h));
        this.b.init(true, keyParameter);
    }

    @Override
    public String getAlgorithmName() {
        return this.b.getAlgorithmName() + "/KGCM";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.b;
    }

    @Override
    public void processAADByte(byte by2) {
        this.l.write(by2);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n2, int n3) {
        this.l.write(byArray, n2, n3);
    }

    private void a(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; i2 += this.k) {
            KGCMBlockCipher.a(this.j, byArray, i2);
            this.i.multiplyH(this.j);
        }
    }

    @Override
    public int processByte(byte by2, byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        this.m.write(by2);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException, IllegalStateException {
        if (byArray.length < n2 + n3) {
            throw new DataLengthException("input buffer too short");
        }
        this.m.write(byArray, n2, n3);
        return 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        int n3;
        int n4 = this.m.size();
        if (!this.e && n4 < this.d) {
            throw new InvalidCipherTextException("data too short");
        }
        byte[] byArray2 = new byte[this.k];
        this.b.processBlock(byArray2, 0, byArray2, 0);
        long[] lArray = new long[this.k >>> 3];
        Pack.littleEndianToLong(byArray2, 0, lArray);
        this.i.init(lArray);
        Arrays.fill(byArray2, (byte)0);
        Arrays.fill(lArray, 0L);
        int n5 = this.l.size();
        if (n5 > 0) {
            this.a(this.l.a(), 0, n5);
        }
        if (this.e) {
            if (byArray.length - n2 - this.d < n4) {
                throw new OutputLengthException("Output buffer too short");
            }
            n3 = this.c.processBytes(this.m.a(), 0, n4, byArray, n2);
            n3 += this.c.doFinal(byArray, n2 + n3);
            this.a(byArray, n2, n4, n5);
        } else {
            int n6 = n4 - this.d;
            if (byArray.length - n2 < n6) {
                throw new OutputLengthException("Output buffer too short");
            }
            this.a(this.m.a(), 0, n6, n5);
            n3 = this.c.processBytes(this.m.a(), 0, n6, byArray, n2);
            n3 += this.c.doFinal(byArray, n2 + n3);
        }
        if (this.g == null) {
            throw new IllegalStateException("mac is not calculated");
        }
        if (this.e) {
            System.arraycopy(this.g, 0, byArray, n2 + n3, this.d);
            this.reset();
            return n3 + this.d;
        }
        byte[] byArray3 = new byte[this.d];
        System.arraycopy(this.m.a(), n4 - this.d, byArray3, 0, this.d);
        byte[] byArray4 = new byte[this.d];
        System.arraycopy(this.g, 0, byArray4, 0, this.d);
        if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
            throw new InvalidCipherTextException("mac verification failed");
        }
        this.reset();
        return n3;
    }

    @Override
    public byte[] getMac() {
        byte[] byArray = new byte[this.d];
        System.arraycopy(this.g, 0, byArray, 0, this.d);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int n2) {
        return 0;
    }

    @Override
    public int getOutputSize(int n2) {
        int n3 = n2 + this.m.size();
        if (this.e) {
            return n3 + this.d;
        }
        return n3 < this.d ? 0 : n3 - this.d;
    }

    @Override
    public void reset() {
        Arrays.fill(this.j, 0L);
        this.b.reset();
        this.m.reset();
        this.l.reset();
        if (this.f != null) {
            this.processAADBytes(this.f, 0, this.f.length);
        }
    }

    private void a(byte[] byArray, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; i2 += this.k) {
            KGCMBlockCipher.a(this.j, byArray, i2);
            this.i.multiplyH(this.j);
        }
        long l2 = ((long)n4 & 0xFFFFFFFFL) << 3;
        long l3 = ((long)n3 & 0xFFFFFFFFL) << 3;
        this.j[0] = this.j[0] ^ l2;
        int n6 = this.k >>> 4;
        this.j[n6] = this.j[n6] ^ l3;
        this.g = Pack.longToLittleEndian(this.j);
        this.b.processBlock(this.g, 0, this.g, 0);
    }

    private static void a(long[] lArray, byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < lArray.length) {
            int n4 = n3++;
            lArray[n4] = lArray[n4] ^ Pack.littleEndianToLong(byArray, n2);
            n2 += 8;
        }
    }

    private class a
    extends ByteArrayOutputStream {
        public byte[] a() {
            return this.buf;
        }
    }
}

