/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.generators;

import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.aspose.psd.internal.bouncycastle.math.Primes;
import com.aspose.psd.internal.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters b;
    private int c;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.b = (RSAKeyGenerationParameters)keyGenerationParameters;
        this.c = RSAKeyPairGenerator.a(this.b.getStrength(), this.b.getCertainty());
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = null;
        boolean bl2 = false;
        int n2 = this.b.getStrength();
        int n3 = (n2 + 1) / 2;
        int n4 = n2 - n3;
        int n5 = n2 / 2 - 100;
        if (n5 < n2 / 3) {
            n5 = n2 / 3;
        }
        int n6 = n2 >> 2;
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(n2 / 2);
        BigInteger bigInteger2 = a.shiftLeft(n2 - 1);
        BigInteger bigInteger3 = a.shiftLeft(n5);
        while (!bl2) {
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            BigInteger bigInteger8;
            BigInteger bigInteger9;
            BigInteger bigInteger10;
            BigInteger bigInteger11;
            BigInteger bigInteger12 = this.b.getPublicExponent();
            BigInteger bigInteger13 = this.chooseRandomPrime(n3, bigInteger12, bigInteger2);
            while (true) {
                if ((bigInteger11 = (bigInteger10 = this.chooseRandomPrime(n4, bigInteger12, bigInteger2)).subtract(bigInteger13).abs()).bitLength() < n5 || bigInteger11.compareTo(bigInteger3) <= 0) {
                    continue;
                }
                bigInteger9 = bigInteger13.multiply(bigInteger10);
                if (bigInteger9.bitLength() != n2) {
                    bigInteger13 = bigInteger13.max(bigInteger10);
                    continue;
                }
                if (WNafUtil.getNafWeight(bigInteger9) >= n6) break;
                bigInteger13 = this.chooseRandomPrime(n3, bigInteger12, bigInteger2);
            }
            if (bigInteger13.compareTo(bigInteger10) < 0) {
                bigInteger8 = bigInteger13;
                bigInteger13 = bigInteger10;
                bigInteger10 = bigInteger8;
            }
            if ((bigInteger7 = bigInteger12.modInverse(bigInteger6 = (bigInteger5 = bigInteger13.subtract(a)).divide(bigInteger8 = bigInteger5.gcd(bigInteger4 = bigInteger10.subtract(a))).multiply(bigInteger4))).compareTo(bigInteger) <= 0) continue;
            bl2 = true;
            bigInteger11 = bigInteger7.remainder(bigInteger5);
            BigInteger bigInteger14 = bigInteger7.remainder(bigInteger4);
            BigInteger bigInteger15 = bigInteger10.modInverse(bigInteger13);
            asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(new RSAKeyParameters(false, bigInteger9, bigInteger12), new RSAPrivateCrtKeyParameters(bigInteger9, bigInteger12, bigInteger7, bigInteger13, bigInteger10, bigInteger11, bigInteger14, bigInteger15));
        }
        return asymmetricCipherKeyPair;
    }

    protected BigInteger chooseRandomPrime(int n2, BigInteger bigInteger, BigInteger bigInteger2) {
        for (int i2 = 0; i2 != 5 * n2; ++i2) {
            BigInteger bigInteger3 = new BigInteger(n2, 1, this.b.getRandom());
            if (bigInteger3.mod(bigInteger).equals(a) || bigInteger3.multiply(bigInteger3).compareTo(bigInteger2) < 0 || !this.isProbablePrime(bigInteger3) || !bigInteger.gcd(bigInteger3.subtract(a)).equals(a)) continue;
            return bigInteger3;
        }
        throw new IllegalStateException("unable to generate prime number for RSA key");
    }

    protected boolean isProbablePrime(BigInteger bigInteger) {
        return !Primes.hasAnySmallFactors(bigInteger) && Primes.isMRProbablePrime(bigInteger, this.b.getRandom(), this.c);
    }

    private static int a(int n2, int n3) {
        if (n2 >= 1536) {
            return n3 <= 100 ? 3 : (n3 <= 128 ? 4 : 4 + (n3 - 128 + 1) / 2);
        }
        if (n2 >= 1024) {
            return n3 <= 100 ? 4 : (n3 <= 112 ? 5 : 5 + (n3 - 112 + 1) / 2);
        }
        if (n2 >= 512) {
            return n3 <= 80 ? 5 : (n3 <= 100 ? 7 : 7 + (n3 - 100 + 1) / 2);
        }
        return n3 <= 80 ? 40 : 40 + (n3 - 80 + 1) / 2;
    }
}

