/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.digests;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.psd.internal.bouncycastle.crypto.engines.GOST28147Engine;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithSBox;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Memoable;
import com.aspose.psd.internal.bouncycastle.util.Pack;

public class GOST3411Digest
implements ExtendedDigest,
Memoable {
    private static final int b = 32;
    private byte[] c = new byte[32];
    private byte[] d = new byte[32];
    private byte[] e = new byte[32];
    private byte[] f = new byte[32];
    private byte[][] g = new byte[4][32];
    private byte[] h = new byte[32];
    private int i;
    private long j;
    private BlockCipher k = new GOST28147Engine();
    private byte[] l;
    private byte[] m = new byte[32];
    byte[] a = new byte[8];
    short[] wS = new short[16];
    short[] w_S = new short[16];
    byte[] S = new byte[32];
    byte[] U = new byte[32];
    byte[] V = new byte[32];
    byte[] W = new byte[32];
    private static final byte[] n = new byte[]{0, -1, 0, -1, 0, -1, 0, -1, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, -1, 0, -1, 0, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1};

    public GOST3411Digest() {
        this.l = GOST28147Engine.getSBox("D-A");
        this.k.init(true, new ParametersWithSBox(null, this.l));
        this.reset();
    }

    public GOST3411Digest(byte[] byArray) {
        this.l = Arrays.clone(byArray);
        this.k.init(true, new ParametersWithSBox(null, this.l));
        this.reset();
    }

    public GOST3411Digest(GOST3411Digest gOST3411Digest) {
        this.reset(gOST3411Digest);
    }

    @Override
    public String getAlgorithmName() {
        return "GOST3411";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte by2) {
        this.h[this.i++] = by2;
        if (this.i == this.h.length) {
            this.d(this.h);
            this.processBlock(this.h, 0);
            this.i = 0;
        }
        ++this.j;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        while (this.i != 0 && n3 > 0) {
            this.update(byArray[n2]);
            ++n2;
            --n3;
        }
        while (n3 > this.h.length) {
            System.arraycopy(byArray, n2, this.h, 0, this.h.length);
            this.d(this.h);
            this.processBlock(this.h, 0);
            n2 += this.h.length;
            n3 -= this.h.length;
            this.j += (long)this.h.length;
        }
        while (n3 > 0) {
            this.update(byArray[n2]);
            ++n2;
            --n3;
        }
    }

    private byte[] a(byte[] byArray) {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.m[4 * i2] = byArray[i2];
            this.m[1 + 4 * i2] = byArray[8 + i2];
            this.m[2 + 4 * i2] = byArray[16 + i2];
            this.m[3 + 4 * i2] = byArray[24 + i2];
        }
        return this.m;
    }

    private byte[] b(byte[] byArray) {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.a[i2] = (byte)(byArray[i2] ^ byArray[i2 + 8]);
        }
        System.arraycopy(byArray, 8, byArray, 0, 24);
        System.arraycopy(this.a, 0, byArray, 24, 8);
        return byArray;
    }

    private void a(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        this.k.init(true, new KeyParameter(byArray));
        this.k.processBlock(byArray3, n3, byArray2, n2);
    }

    private void c(byte[] byArray) {
        this.a(byArray, this.wS);
        this.w_S[15] = (short)(this.wS[0] ^ this.wS[1] ^ this.wS[2] ^ this.wS[3] ^ this.wS[12] ^ this.wS[15]);
        System.arraycopy(this.wS, 1, this.w_S, 0, 15);
        this.a(this.w_S, byArray);
    }

    protected void processBlock(byte[] byArray, int n2) {
        int n3;
        System.arraycopy(byArray, n2, this.e, 0, 32);
        System.arraycopy(this.c, 0, this.U, 0, 32);
        System.arraycopy(this.e, 0, this.V, 0, 32);
        for (n3 = 0; n3 < 32; ++n3) {
            this.W[n3] = (byte)(this.U[n3] ^ this.V[n3]);
        }
        this.a(this.a(this.W), this.S, 0, this.c, 0);
        for (n3 = 1; n3 < 4; ++n3) {
            int n4;
            byte[] byArray2 = this.b(this.U);
            for (n4 = 0; n4 < 32; ++n4) {
                this.U[n4] = (byte)(byArray2[n4] ^ this.g[n3][n4]);
            }
            this.V = this.b(this.b(this.V));
            for (n4 = 0; n4 < 32; ++n4) {
                this.W[n4] = (byte)(this.U[n4] ^ this.V[n4]);
            }
            this.a(this.a(this.W), this.S, n3 * 8, this.c, n3 * 8);
        }
        for (n3 = 0; n3 < 12; ++n3) {
            this.c(this.S);
        }
        for (n3 = 0; n3 < 32; ++n3) {
            this.S[n3] = (byte)(this.S[n3] ^ this.e[n3]);
        }
        this.c(this.S);
        for (n3 = 0; n3 < 32; ++n3) {
            this.S[n3] = (byte)(this.c[n3] ^ this.S[n3]);
        }
        for (n3 = 0; n3 < 61; ++n3) {
            this.c(this.S);
        }
        System.arraycopy(this.S, 0, this.c, 0, this.c.length);
    }

    private void a() {
        Pack.longToLittleEndian(this.j * 8L, this.d, 0);
        while (this.i != 0) {
            this.update((byte)0);
        }
        this.processBlock(this.d, 0);
        this.processBlock(this.f, 0);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.a();
        System.arraycopy(this.c, 0, byArray, n2, this.c.length);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        int n2;
        this.j = 0L;
        this.i = 0;
        for (n2 = 0; n2 < this.c.length; ++n2) {
            this.c[n2] = 0;
        }
        for (n2 = 0; n2 < this.d.length; ++n2) {
            this.d[n2] = 0;
        }
        for (n2 = 0; n2 < this.e.length; ++n2) {
            this.e[n2] = 0;
        }
        for (n2 = 0; n2 < this.g[1].length; ++n2) {
            this.g[1][n2] = 0;
        }
        for (n2 = 0; n2 < this.g[3].length; ++n2) {
            this.g[3][n2] = 0;
        }
        for (n2 = 0; n2 < this.f.length; ++n2) {
            this.f[n2] = 0;
        }
        for (n2 = 0; n2 < this.h.length; ++n2) {
            this.h[n2] = 0;
        }
        System.arraycopy(n, 0, this.g[2], 0, n.length);
    }

    private void d(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 != this.f.length; ++i2) {
            int n3 = (this.f[i2] & 0xFF) + (byArray[i2] & 0xFF) + n2;
            this.f[i2] = (byte)n3;
            n2 = n3 >>> 8;
        }
    }

    private void a(byte[] byArray, short[] sArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            sArray[i2] = (short)(byArray[i2 * 2 + 1] << 8 & 0xFF00 | byArray[i2 * 2] & 0xFF);
        }
    }

    private void a(short[] sArray, byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byArray[i2 * 2 + 1] = (byte)(sArray[i2] >> 8);
            byArray[i2 * 2] = (byte)sArray[i2];
        }
    }

    @Override
    public int getByteLength() {
        return 32;
    }

    @Override
    public Memoable copy() {
        return new GOST3411Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        GOST3411Digest gOST3411Digest = (GOST3411Digest)memoable;
        this.l = gOST3411Digest.l;
        this.k.init(true, new ParametersWithSBox(null, this.l));
        this.reset();
        System.arraycopy(gOST3411Digest.c, 0, this.c, 0, gOST3411Digest.c.length);
        System.arraycopy(gOST3411Digest.d, 0, this.d, 0, gOST3411Digest.d.length);
        System.arraycopy(gOST3411Digest.e, 0, this.e, 0, gOST3411Digest.e.length);
        System.arraycopy(gOST3411Digest.f, 0, this.f, 0, gOST3411Digest.f.length);
        System.arraycopy(gOST3411Digest.g[1], 0, this.g[1], 0, gOST3411Digest.g[1].length);
        System.arraycopy(gOST3411Digest.g[2], 0, this.g[2], 0, gOST3411Digest.g[2].length);
        System.arraycopy(gOST3411Digest.g[3], 0, this.g[3], 0, gOST3411Digest.g[3].length);
        System.arraycopy(gOST3411Digest.h, 0, this.h, 0, gOST3411Digest.h.length);
        this.i = gOST3411Digest.i;
        this.j = gOST3411Digest.j;
    }
}

