/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.commitments;

import com.aspose.psd.internal.bouncycastle.crypto.Commitment;
import com.aspose.psd.internal.bouncycastle.crypto.Committer;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class HashCommitter
implements Committer {
    private final Digest a;
    private final int b;
    private final SecureRandom c;

    public HashCommitter(ExtendedDigest extendedDigest, SecureRandom secureRandom) {
        this.a = extendedDigest;
        this.b = extendedDigest.getByteLength();
        this.c = secureRandom;
    }

    @Override
    public Commitment commit(byte[] byArray) {
        if (byArray.length > this.b / 2) {
            throw new DataLengthException("Message to be committed to too large for digest.");
        }
        byte[] byArray2 = new byte[this.b - byArray.length];
        this.c.nextBytes(byArray2);
        return new Commitment(byArray2, this.a(byArray2, byArray));
    }

    @Override
    public boolean isRevealed(Commitment commitment, byte[] byArray) {
        if (byArray.length + commitment.getSecret().length != this.b) {
            throw new DataLengthException("Message and witness secret lengths do not match.");
        }
        byte[] byArray2 = this.a(commitment.getSecret(), byArray);
        return Arrays.constantTimeAreEqual(commitment.getCommitment(), byArray2);
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[this.a.getDigestSize()];
        this.a.update(byArray, 0, byArray.length);
        this.a.update(byArray2, 0, byArray2.length);
        this.a.doFinal(byArray3, 0);
        return byArray3;
    }
}

