/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms.jcajce;

import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cms.KeyTransRecipientInfoGenerator;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.m;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.n;
import com.aspose.psd.internal.bouncycastle.operator.AsymmetricKeyWrapper;
import com.aspose.psd.internal.bouncycastle.operator.jcajce.JceAsymmetricKeyWrapper;
import com.aspose.psd.internal.bouncycastle.operator.jcajce.JceKTSKeyWrapper;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JceKTSKeyTransRecipientInfoGenerator
extends KeyTransRecipientInfoGenerator {
    private static final byte[] a = Hex.decode("0c14416e6f6e796d6f75732053656e64657220202020");

    private JceKTSKeyTransRecipientInfoGenerator(X509Certificate x509Certificate, IssuerAndSerialNumber issuerAndSerialNumber, String string, int n2) throws CertificateEncodingException {
        super(issuerAndSerialNumber, (AsymmetricKeyWrapper)new JceKTSKeyWrapper(x509Certificate, string, n2, a, JceKTSKeyTransRecipientInfoGenerator.a(issuerAndSerialNumber)));
    }

    public JceKTSKeyTransRecipientInfoGenerator(X509Certificate x509Certificate, String string, int n2) throws CertificateEncodingException {
        this(x509Certificate, new IssuerAndSerialNumber(new JcaX509CertificateHolder(x509Certificate).toASN1Structure()), string, n2);
    }

    public JceKTSKeyTransRecipientInfoGenerator(byte[] byArray, PublicKey publicKey, String string, int n2) {
        super(byArray, (AsymmetricKeyWrapper)new JceKTSKeyWrapper(publicKey, string, n2, a, JceKTSKeyTransRecipientInfoGenerator.a(byArray)));
    }

    private static byte[] a(IssuerAndSerialNumber issuerAndSerialNumber) throws CertificateEncodingException {
        try {
            return issuerAndSerialNumber.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new m("Cannot process extracted IssuerAndSerialNumber: " + iOException.getMessage(), iOException);
        }
    }

    private static byte[] a(byte[] byArray) {
        try {
            return new DEROctetString(byArray).getEncoded();
        }
        catch (IOException iOException) {
            throw new n("Cannot process subject key identifier: " + iOException.getMessage(), iOException);
        }
    }

    public JceKTSKeyTransRecipientInfoGenerator(X509Certificate x509Certificate, AlgorithmIdentifier algorithmIdentifier) throws CertificateEncodingException {
        super(new IssuerAndSerialNumber(new JcaX509CertificateHolder(x509Certificate).toASN1Structure()), (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(algorithmIdentifier, x509Certificate.getPublicKey()));
    }

    public JceKTSKeyTransRecipientInfoGenerator(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        super(byArray, (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(algorithmIdentifier, publicKey));
    }

    public JceKTSKeyTransRecipientInfoGenerator setProvider(String string) {
        ((JceKTSKeyWrapper)this.wrapper).setProvider(string);
        return this;
    }

    public JceKTSKeyTransRecipientInfoGenerator setProvider(Provider provider) {
        ((JceKTSKeyWrapper)this.wrapper).setProvider(provider);
        return this;
    }
}

