/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert.selector;

import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Target;
import com.aspose.psd.internal.bouncycastle.asn1.x509.TargetInformation;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Targets;
import com.aspose.psd.internal.bouncycastle.cert.AttributeCertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.AttributeCertificateIssuer;
import com.aspose.psd.internal.bouncycastle.cert.X509AttributeCertificateHolder;
import com.aspose.psd.internal.bouncycastle.util.Selector;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;

public class X509AttributeCertificateHolderSelector
implements Selector {
    private final AttributeCertificateHolder a;
    private final AttributeCertificateIssuer b;
    private final BigInteger c;
    private final Date d;
    private final X509AttributeCertificateHolder e;
    private final Collection f;
    private final Collection g;

    X509AttributeCertificateHolderSelector(AttributeCertificateHolder attributeCertificateHolder, AttributeCertificateIssuer attributeCertificateIssuer, BigInteger bigInteger, Date date, X509AttributeCertificateHolder x509AttributeCertificateHolder, Collection collection, Collection collection2) {
        this.a = attributeCertificateHolder;
        this.b = attributeCertificateIssuer;
        this.c = bigInteger;
        this.d = date;
        this.e = x509AttributeCertificateHolder;
        this.f = collection;
        this.g = collection2;
    }

    public boolean match(Object object) {
        Extension extension;
        if (!(object instanceof X509AttributeCertificateHolder)) {
            return false;
        }
        X509AttributeCertificateHolder x509AttributeCertificateHolder = (X509AttributeCertificateHolder)object;
        if (this.e != null && !this.e.equals(x509AttributeCertificateHolder)) {
            return false;
        }
        if (this.c != null && !x509AttributeCertificateHolder.getSerialNumber().equals(this.c)) {
            return false;
        }
        if (this.a != null && !x509AttributeCertificateHolder.getHolder().equals(this.a)) {
            return false;
        }
        if (this.b != null && !x509AttributeCertificateHolder.getIssuer().equals(this.b)) {
            return false;
        }
        if (this.d != null && !x509AttributeCertificateHolder.isValidOn(this.d)) {
            return false;
        }
        if (!(this.f.isEmpty() && this.g.isEmpty() || (extension = x509AttributeCertificateHolder.getExtension(Extension.targetInformation)) == null)) {
            int n2;
            Target[] targetArray;
            Targets targets;
            int n3;
            boolean bl2;
            TargetInformation targetInformation;
            try {
                targetInformation = TargetInformation.getInstance(extension.getParsedValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            Targets[] targetsArray = targetInformation.getTargetsObjects();
            if (!this.f.isEmpty()) {
                bl2 = false;
                block2: for (n3 = 0; n3 < targetsArray.length; ++n3) {
                    targets = targetsArray[n3];
                    targetArray = targets.getTargets();
                    for (n2 = 0; n2 < targetArray.length; ++n2) {
                        if (!this.f.contains(GeneralName.getInstance(targetArray[n2].getTargetName()))) continue;
                        bl2 = true;
                        continue block2;
                    }
                }
                if (!bl2) {
                    return false;
                }
            }
            if (!this.g.isEmpty()) {
                bl2 = false;
                block4: for (n3 = 0; n3 < targetsArray.length; ++n3) {
                    targets = targetsArray[n3];
                    targetArray = targets.getTargets();
                    for (n2 = 0; n2 < targetArray.length; ++n2) {
                        if (!this.g.contains(GeneralName.getInstance(targetArray[n2].getTargetGroup()))) continue;
                        bl2 = true;
                        continue block4;
                    }
                }
                if (!bl2) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Object clone() {
        X509AttributeCertificateHolderSelector x509AttributeCertificateHolderSelector = new X509AttributeCertificateHolderSelector(this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        return x509AttributeCertificateHolderSelector;
    }

    public X509AttributeCertificateHolder getAttributeCert() {
        return this.e;
    }

    public Date getAttributeCertificateValid() {
        if (this.d != null) {
            return new Date(this.d.getTime());
        }
        return null;
    }

    public AttributeCertificateHolder getHolder() {
        return this.a;
    }

    public AttributeCertificateIssuer getIssuer() {
        return this.b;
    }

    public BigInteger getSerialNumber() {
        return this.c;
    }

    public Collection getTargetNames() {
        return this.f;
    }

    public Collection getTargetGroups() {
        return this.g;
    }
}

