/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.DEROutputStream;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.CertificateList;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.psd.internal.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.aspose.psd.internal.bouncycastle.asn1.x509.TBSCertList;
import com.aspose.psd.internal.bouncycastle.cert.CertException;
import com.aspose.psd.internal.bouncycastle.cert.CertIOException;
import com.aspose.psd.internal.bouncycastle.cert.X509CRLEntryHolder;
import com.aspose.psd.internal.bouncycastle.cert.a;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifierProvider;
import com.aspose.psd.internal.bouncycastle.util.Encodable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

public class X509CRLHolder
implements Encodable,
Serializable {
    private static final long a = 20170722001L;
    private transient CertificateList b;
    private transient boolean c;
    private transient Extensions d;
    private transient GeneralNames e;

    private static CertificateList a(InputStream inputStream) throws IOException {
        try {
            ASN1Primitive aSN1Primitive = new ASN1InputStream(inputStream, true).readObject();
            if (aSN1Primitive == null) {
                throw new IOException("no content found");
            }
            return CertificateList.getInstance(aSN1Primitive);
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    private static boolean a(Extensions extensions) {
        if (extensions == null) {
            return false;
        }
        Extension extension = extensions.getExtension(Extension.issuingDistributionPoint);
        return extension != null && IssuingDistributionPoint.getInstance(extension.getParsedValue()).isIndirectCRL();
    }

    public X509CRLHolder(byte[] byArray) throws IOException {
        this(X509CRLHolder.a(new ByteArrayInputStream(byArray)));
    }

    public X509CRLHolder(InputStream inputStream) throws IOException {
        this(X509CRLHolder.a(inputStream));
    }

    public X509CRLHolder(CertificateList certificateList) {
        this.a(certificateList);
    }

    private void a(CertificateList certificateList) {
        this.b = certificateList;
        this.d = certificateList.getTBSCertList().getExtensions();
        this.c = X509CRLHolder.a(this.d);
        this.e = new GeneralNames(new GeneralName(certificateList.getIssuer()));
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.b.getEncoded();
    }

    public X500Name getIssuer() {
        return X500Name.getInstance(this.b.getIssuer());
    }

    public X509CRLEntryHolder getRevokedCertificate(BigInteger bigInteger) {
        GeneralNames generalNames = this.e;
        Enumeration enumeration = this.b.getRevokedCertificateEnumeration();
        while (enumeration.hasMoreElements()) {
            Extension extension;
            TBSCertList.CRLEntry cRLEntry = (TBSCertList.CRLEntry)enumeration.nextElement();
            if (cRLEntry.getUserCertificate().getValue().equals(bigInteger)) {
                return new X509CRLEntryHolder(cRLEntry, this.c, generalNames);
            }
            if (!this.c || !cRLEntry.hasExtensions() || (extension = cRLEntry.getExtensions().getExtension(Extension.certificateIssuer)) == null) continue;
            generalNames = GeneralNames.getInstance(extension.getParsedValue());
        }
        return null;
    }

    public Collection getRevokedCertificates() {
        TBSCertList.CRLEntry[] cRLEntryArray = this.b.getRevokedCertificates();
        ArrayList<X509CRLEntryHolder> arrayList = new ArrayList<X509CRLEntryHolder>(cRLEntryArray.length);
        GeneralNames generalNames = this.e;
        Enumeration enumeration = this.b.getRevokedCertificateEnumeration();
        while (enumeration.hasMoreElements()) {
            TBSCertList.CRLEntry cRLEntry = (TBSCertList.CRLEntry)enumeration.nextElement();
            X509CRLEntryHolder x509CRLEntryHolder = new X509CRLEntryHolder(cRLEntry, this.c, generalNames);
            arrayList.add(x509CRLEntryHolder);
            generalNames = x509CRLEntryHolder.getCertificateIssuer();
        }
        return arrayList;
    }

    public boolean hasExtensions() {
        return this.d != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.d != null) {
            return this.d.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public Extensions getExtensions() {
        return this.d;
    }

    public List getExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.c(this.d);
    }

    public Set getCriticalExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.a(this.d);
    }

    public Set getNonCriticalExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.b(this.d);
    }

    public CertificateList toASN1Structure() {
        return this.b;
    }

    public boolean isSignatureValid(ContentVerifierProvider contentVerifierProvider) throws CertException {
        ContentVerifier contentVerifier;
        TBSCertList tBSCertList = this.b.getTBSCertList();
        if (!com.aspose.psd.internal.bouncycastle.cert.a.a(tBSCertList.getSignature(), this.b.getSignatureAlgorithm())) {
            throw new CertException("signature invalid - algorithm identifier mismatch");
        }
        try {
            contentVerifier = contentVerifierProvider.get(tBSCertList.getSignature());
            OutputStream outputStream = contentVerifier.getOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(outputStream);
            dEROutputStream.writeObject(tBSCertList);
            outputStream.close();
        }
        catch (Exception exception) {
            throw new CertException("unable to process signature: " + exception.getMessage(), exception);
        }
        return contentVerifier.verify(this.b.getSignature().getOctets());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509CRLHolder)) {
            return false;
        }
        X509CRLHolder x509CRLHolder = (X509CRLHolder)object;
        return this.b.equals(x509CRLHolder.b);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a(CertificateList.getInstance(objectInputStream.readObject()));
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

