/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1String;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralNames;

public class RoleSyntax
extends ASN1Object {
    private GeneralNames a;
    private GeneralName b;

    public static RoleSyntax getInstance(Object object) {
        if (object instanceof RoleSyntax) {
            return (RoleSyntax)object;
        }
        if (object != null) {
            return new RoleSyntax(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RoleSyntax(GeneralNames generalNames, GeneralName generalName) {
        if (generalName == null || generalName.getTagNo() != 6 || ((ASN1String)((Object)generalName.getName())).getString().equals("")) {
            throw new IllegalArgumentException("the role name MUST be non empty and MUST use the URI option of GeneralName");
        }
        this.a = generalNames;
        this.b = generalName;
    }

    public RoleSyntax(GeneralName generalName) {
        this(null, generalName);
    }

    public RoleSyntax(String string) {
        this(new GeneralName(6, string == null ? "" : string));
    }

    private RoleSyntax(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        block4: for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(i2));
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = GeneralNames.getInstance(aSN1TaggedObject, false);
                    continue block4;
                }
                case 1: {
                    this.b = GeneralName.getInstance(aSN1TaggedObject, true);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag in RoleSyntax");
                }
            }
        }
    }

    public GeneralNames getRoleAuthority() {
        return this.a;
    }

    public GeneralName getRoleName() {
        return this.b;
    }

    public String getRoleNameAsString() {
        ASN1String aSN1String = (ASN1String)((Object)this.b.getName());
        return aSN1String.getString();
    }

    public String[] getRoleAuthorityAsString() {
        if (this.a == null) {
            return new String[0];
        }
        GeneralName[] generalNameArray = this.a.getNames();
        String[] stringArray = new String[generalNameArray.length];
        for (int i2 = 0; i2 < generalNameArray.length; ++i2) {
            ASN1Encodable aSN1Encodable = generalNameArray[i2].getName();
            stringArray[i2] = aSN1Encodable instanceof ASN1String ? ((ASN1String)((Object)aSN1Encodable)).getString() : aSN1Encodable.toString();
        }
        return stringArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.a));
        }
        aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Name: " + this.getRoleNameAsString() + " - Auth: ");
        if (this.a == null || this.a.getNames().length == 0) {
            stringBuffer.append("N/A");
        } else {
            String[] stringArray = this.getRoleAuthorityAsString();
            stringBuffer.append('[').append(stringArray[0]);
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringBuffer.append(", ").append(stringArray[i2]);
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }
}

