/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralName;
import java.math.BigInteger;

public class GeneralSubtree
extends ASN1Object {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private GeneralName b;
    private ASN1Integer c;
    private ASN1Integer d;

    private GeneralSubtree(ASN1Sequence aSN1Sequence) {
        this.b = GeneralName.getInstance(aSN1Sequence.getObjectAt(0));
        block0 : switch (aSN1Sequence.size()) {
            case 1: {
                break;
            }
            case 2: {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(1));
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.c = ASN1Integer.getInstance(aSN1TaggedObject, false);
                        break block0;
                    }
                    case 1: {
                        this.d = ASN1Integer.getInstance(aSN1TaggedObject, false);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
            }
            case 3: {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(1));
                if (aSN1TaggedObject.getTagNo() != 0) {
                    throw new IllegalArgumentException("Bad tag number for 'minimum': " + aSN1TaggedObject.getTagNo());
                }
                this.c = ASN1Integer.getInstance(aSN1TaggedObject, false);
                aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(2));
                if (aSN1TaggedObject.getTagNo() != 1) {
                    throw new IllegalArgumentException("Bad tag number for 'maximum': " + aSN1TaggedObject.getTagNo());
                }
                this.d = ASN1Integer.getInstance(aSN1TaggedObject, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
            }
        }
    }

    public GeneralSubtree(GeneralName generalName, BigInteger bigInteger, BigInteger bigInteger2) {
        this.b = generalName;
        if (bigInteger2 != null) {
            this.d = new ASN1Integer(bigInteger2);
        }
        this.c = bigInteger == null ? null : new ASN1Integer(bigInteger);
    }

    public GeneralSubtree(GeneralName generalName) {
        this(generalName, null, null);
    }

    public static GeneralSubtree getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return new GeneralSubtree(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static GeneralSubtree getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof GeneralSubtree) {
            return (GeneralSubtree)object;
        }
        return new GeneralSubtree(ASN1Sequence.getInstance(object));
    }

    public GeneralName getBase() {
        return this.b;
    }

    public BigInteger getMinimum() {
        if (this.c == null) {
            return a;
        }
        return this.c.getValue();
    }

    public BigInteger getMaximum() {
        if (this.d == null) {
            return null;
        }
        return this.d.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        if (this.c != null && !this.c.getValue().equals(a)) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.c));
        }
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.d));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

