/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cmc;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.cmc.TaggedCertificationRequest;
import com.aspose.psd.internal.bouncycastle.asn1.crmf.CertReqMsg;
import java.io.IOException;

public class TaggedRequest
extends ASN1Object
implements ASN1Choice {
    public static final int TCR = 0;
    public static final int CRM = 1;
    public static final int ORM = 2;
    private final int a;
    private final ASN1Encodable b;

    public TaggedRequest(TaggedCertificationRequest taggedCertificationRequest) {
        this.a = 0;
        this.b = taggedCertificationRequest;
    }

    public TaggedRequest(CertReqMsg certReqMsg) {
        this.a = 1;
        this.b = certReqMsg;
    }

    private TaggedRequest(ASN1Sequence aSN1Sequence) {
        this.a = 2;
        this.b = aSN1Sequence;
    }

    public static TaggedRequest getInstance(Object object) {
        if (object instanceof TaggedRequest) {
            return (TaggedRequest)object;
        }
        if (object != null) {
            if (object instanceof ASN1Encodable) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(((ASN1Encodable)object).toASN1Primitive());
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        return new TaggedRequest(TaggedCertificationRequest.getInstance(aSN1TaggedObject, false));
                    }
                    case 1: {
                        return new TaggedRequest(CertReqMsg.getInstance(aSN1TaggedObject, false));
                    }
                    case 2: {
                        return new TaggedRequest(ASN1Sequence.getInstance(aSN1TaggedObject, false));
                    }
                }
                throw new IllegalArgumentException("unknown tag in getInstance(): " + aSN1TaggedObject.getTagNo());
            }
            if (object instanceof byte[]) {
                try {
                    return TaggedRequest.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("unknown encoding in getInstance()");
                }
            }
            throw new IllegalArgumentException("unknown object in getInstance(): " + object.getClass().getName());
        }
        return null;
    }

    public int getTagNo() {
        return this.a;
    }

    public ASN1Encodable getValue() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.a, this.b);
    }
}

