/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.fileformats.psd.rawcolor;

import com.aspose.psd.PixelDataFormat;
import com.aspose.psd.fileformats.psd.rawcolor.ColorComponent;
import com.aspose.psd.internal.Exceptions.ArgumentException;
import com.aspose.psd.internal.bG.aW;
import com.aspose.psd.internal.cv.z;
import com.aspose.psd.internal.gK.d;
import com.aspose.psd.system.collections.Generic.List;

public final class RawColor {
    private ColorComponent[] a;
    private short b;

    public final ColorComponent[] getComponents() {
        return this.a;
    }

    private void a(ColorComponent[] colorComponentArray) {
        this.a = colorComponentArray;
    }

    public final short getColorMode() {
        return this.b;
    }

    public final void setColorMode(short value) {
        this.b = value;
    }

    public final String getColorModeName() {
        z z2 = new z();
        for (ColorComponent colorComponent : this.getComponents()) {
            z2.a(colorComponent.getName());
        }
        return z2.toString();
    }

    public final int getBitDepth() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getComponents().length; ++i2) {
            n2 += this.getComponents()[i2].getBitDepth() & 0xFF;
        }
        return n2;
    }

    public final int getAsInt() {
        int n2 = 0;
        int n3 = this.getBitDepth();
        if (n3 > 32) {
            throw new ArgumentException(aW.a("The Bit Depth of Raw Color is {0} that is more than 32, you can not read it as Int", new Object[]{n3}));
        }
        int n4 = this.getComponents().length;
        byte by2 = (byte)n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            by2 = (byte)((by2 & 0xFF) - (this.getComponents()[i2].getBitDepth() & 0xFF));
            n2 |= (int)this.getComponents()[i2].getValue() << (by2 & 0xFF);
        }
        return n2;
    }

    public final void setAsInt(int value) {
        int n2 = this.getBitDepth();
        if (n2 > 32) {
            throw new ArgumentException(aW.a("The Bit Depth of Raw Color is {0}. You can not set is as Int, pleae set the single channels data", new Object[]{n2}));
        }
        int n3 = this.getComponents().length;
        byte by2 = (byte)n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            by2 = (byte)((by2 & 0xFF) - (this.getComponents()[i2].getBitDepth() & 0xFF));
            this.getComponents()[i2].setValue((byte)(value >> (by2 & 0xFF) & 0xFF) & 0xFF);
        }
    }

    public final long getAsLong() {
        long l2 = 0L;
        int n2 = this.getBitDepth();
        if (n2 > 64) {
            throw new ArgumentException(aW.a("The Bit Depth of Raw Color is {0} that is more than 32, you can not read it as Int", new Object[]{n2}));
        }
        int n3 = this.getComponents().length;
        byte by2 = (byte)n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            by2 = (byte)((by2 & 0xFF) - (this.getComponents()[i2].getBitDepth() & 0xFF));
            l2 |= this.getComponents()[i2].getValue() << (by2 & 0xFF);
        }
        return l2;
    }

    public final void setAsLong(long value) {
        int n2 = this.getBitDepth();
        if (n2 > 64) {
            throw new ArgumentException(aW.a("The Bit Depth of Raw Color is {0}. You can not set is as Int, pleae set the single channels data", new Object[]{n2}));
        }
        int n3 = this.getComponents().length;
        byte by2 = (byte)n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            by2 = (byte)((by2 & 0xFF) - (this.getComponents()[i2].getBitDepth() & 0xFF));
            this.getComponents()[i2].setValue(d.h((int)(value >> (by2 & 0xFF) & 0xFFFFL), 8));
        }
    }

    public RawColor(ColorComponent[] components) {
        this.a(components);
    }

    public RawColor(PixelDataFormat pixelDataFormat) {
        this(pixelDataFormat, 0);
    }

    public RawColor(PixelDataFormat pixelDataFormat, short colorMode) {
        List<ColorComponent> list = new List<ColorComponent>();
        String[] stringArray = this.a(pixelDataFormat);
        if (stringArray.length != pixelDataFormat.getChannelsCount()) {
            throw new ArgumentException("Channels count differs from PixelFormat, index of channels can not be obtained. Please create RawColor with Components' Array argument");
        }
        for (int i2 = 0; i2 < pixelDataFormat.getChannelsCount(); ++i2) {
            int n2 = pixelDataFormat.getChannelBits()[i2];
            list.addItem(new ColorComponent((byte)n2, stringArray[i2]));
        }
        this.a(list.toArray(new ColorComponent[0]));
        this.setColorMode(colorMode);
    }

    private String[] a(PixelDataFormat pixelDataFormat) {
        switch (pixelDataFormat.getPixelFormat()) {
            case 0: {
                return new String[]{"Grayscale Grayscale"};
            }
            case 1: {
                return new String[]{"B Blue", "G Green", "R Red", "A Alpha"};
            }
            case 2: {
                return new String[]{"A Alpha", "R Red", "G Green", "B Blue"};
            }
            case 3: {
                return new String[]{"Y Luma", "Cb Blue-Difference", "Cr Red-Difference"};
            }
            case 4: {
                return new String[]{"C Cyan", "M Magenta", "Y Yellow", "K Key"};
            }
            case 5: {
                return new String[]{"Y Luma", "Cb Blue-Difference", "Cr Red-Difference", "K Black-Chroma"};
            }
            case 6: {
                return new String[]{"L Lightness", "A Color", "B Color"};
            }
        }
        throw new ArgumentException(String.format("RawColor hasn't predetermined RawColor structure for format {0}. Please create Raw Color Manually", pixelDataFormat));
    }

    private int a(String string) {
        if (aW.b(string)) {
            return -1;
        }
        return aW.d(string, 'A');
    }
}

