/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.fileformats.psd.layers.layerresources;

import com.aspose.psd.StreamContainer;
import com.aspose.psd.coreexceptions.imageformats.PsdImageArgumentException;
import com.aspose.psd.internal.bG.aE;
import com.aspose.psd.internal.bG.aW;
import com.aspose.psd.internal.bG.bD;
import com.aspose.psd.internal.gL.x;

public class ColorRangeHsl {
    private short a;
    private short b;
    private short c;
    private short d;
    private short e;
    private short f;
    private short g;

    public ColorRangeHsl() {
        this.setHue((short)0);
        this.setSaturation((short)0);
        this.setLightness((short)0);
    }

    public ColorRangeHsl(byte[] data) {
        if (data.length != 14) {
            throw new PsdImageArgumentException(aW.a(new Object[]{"Expected length of ", aE.a(this), " is 14"}));
        }
        this.setMostLeftBorder(x.g(data, 0));
        this.setLeftBorder(x.g(data, 2));
        this.setRightBorder(x.g(data, 4));
        this.setMostRightBorder(x.g(data, 6));
        this.setHue(x.g(data, 8));
        this.setSaturation(x.g(data, 10));
        this.setLightness(x.g(data, 12));
    }

    ColorRangeHsl(short mostLeft, short left, short right, short mostRight) {
        this.a = mostLeft;
        this.b = left;
        this.c = right;
        this.d = mostRight;
    }

    public static ColorRangeHsl a(short s2, short s3, short s4, short s5) {
        return new ColorRangeHsl(s2, s3, s4, s5);
    }

    public final short getHue() {
        return this.e;
    }

    public final void setHue(short value) {
        this.e = value;
    }

    public final short getSaturation() {
        return this.f;
    }

    public final void setSaturation(short value) {
        this.f = value;
    }

    public final short getLightness() {
        return this.g;
    }

    public final void setLightness(short value) {
        this.g = value;
    }

    public final short getMostLeftBorder() {
        return (short)(this.a % 360);
    }

    public final void setMostLeftBorder(short value) {
        this.a = value;
        this.a();
    }

    public final short getLeftBorder() {
        return (short)(this.b % 360);
    }

    public final void setLeftBorder(short value) {
        this.b = value;
        this.a();
    }

    public final short getRightBorder() {
        return (short)(this.c % 360);
    }

    public final void setRightBorder(short value) {
        this.c = value;
        this.a();
    }

    public final short getMostRightBorder() {
        return (short)(this.d % 360);
    }

    public final void setMostRightBorder(short value) {
        this.d = value;
        this.a();
    }

    public final boolean isHueInBigRange(double hue) {
        return hue >= (double)this.a && hue <= (double)this.d || hue + 360.0 >= (double)this.a && hue + 360.0 <= (double)this.d;
    }

    public final boolean isHueInSmallRange(double hue) {
        return hue >= (double)this.b && hue <= (double)this.c || hue + 360.0 >= (double)this.b && hue + 360.0 <= (double)this.c;
    }

    public final double getRangeCoefficient(double hue) {
        if (bD.a((hue - (double)this.a) % 360.0) <= bD.a(((double)this.d - hue) % 360.0)) {
            return (hue - (double)this.a + 360.0) % 360.0 / (double)(this.b - this.a);
        }
        return ((double)this.d - hue + 360.0) % 360.0 / (double)(this.d - this.c);
    }

    public final void save(StreamContainer streamContainer) {
        streamContainer.write(x.a(this.getMostLeftBorder()));
        streamContainer.write(x.a(this.getLeftBorder()));
        streamContainer.write(x.a(this.getRightBorder()));
        streamContainer.write(x.a(this.getMostRightBorder()));
        streamContainer.write(x.a(this.getHue()));
        streamContainer.write(x.a(this.getSaturation()));
        streamContainer.write(x.a(this.getLightness()));
    }

    private void a() {
        if (this.b < this.a) {
            this.b = (short)(this.b + 360);
        }
        if (this.c < this.b) {
            this.c = (short)(this.c + 360);
        }
        if (this.d < this.c) {
            this.d = (short)(this.d + 360);
        }
    }
}

