/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd;

import com.aspose.psd.Color;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.bG.bD;
import com.aspose.psd.internal.bm.a;
import com.aspose.psd.internal.gK.d;
import com.aspose.psd.internal.gL.aF;
import com.aspose.psd.system.io.Stream;
import java.io.InputStream;

public final class CmykColorHelper {
    private CmykColorHelper() {
    }

    public static int getC(int cmyk) {
        return cmyk >> 24 & 0xFF;
    }

    public static int getM(int cmyk) {
        return cmyk >> 16 & 0xFF;
    }

    public static int getY(int cmyk) {
        return cmyk >> 8 & 0xFF;
    }

    public static int getK(int cmyk) {
        return cmyk & 0xFF;
    }

    public static int fromComponents(int cyan, int magenta, int yellow, int black) {
        CmykColorHelper.a(cyan, "cyan");
        CmykColorHelper.a(magenta, "magenta");
        CmykColorHelper.a(yellow, "yellow");
        CmykColorHelper.a(black, "black");
        return cyan << 24 | magenta << 16 | yellow << 8 | black;
    }

    private static void a(int n2, String string) {
        if ((n2 & 0xFF) != n2) {
            throw new ArgumentOutOfRangeException(string);
        }
    }

    public static int[] toCmyk(int[] argbPixels) {
        int[] nArray = new int[argbPixels.length];
        for (int i2 = 0; i2 < argbPixels.length; ++i2) {
            int n2 = argbPixels[i2] & 0xFF;
            int n3 = argbPixels[i2] >> 8 & 0xFF;
            int n4 = argbPixels[i2] >> 16 & 0xFF;
            int n5 = bD.d(bD.d(255 - n2, 255 - n3), 255 - n4);
            if (n5 < 255) {
                int n6 = 255 - n5;
                int n7 = 255 * (n6 - n4) / n6;
                int n8 = 255 * (n6 - n3) / n6;
                int n9 = 255 * (n6 - n2) / n6;
                nArray[i2] = n7 << 24 | n8 << 16 | n9 << 8 | n5;
                continue;
            }
            nArray[i2] = n5;
        }
        return nArray;
    }

    public static byte[] toCmykBytes(int[] argbPixels, int startIndex, int length) {
        int n2 = bD.d(startIndex + length, argbPixels.length);
        byte[] byArray = new byte[(n2 - startIndex) * 4];
        int n3 = 0;
        for (int i2 = startIndex; i2 < n2; ++i2) {
            int n4 = argbPixels[i2] & 0xFF;
            int n5 = argbPixels[i2] >> 8 & 0xFF;
            int n6 = argbPixels[i2] >> 16 & 0xFF;
            int n7 = bD.d(bD.d(255 - n4, 255 - n5), 255 - n6);
            if (n7 < 255) {
                int n8 = 255 - n7;
                byArray[n3++] = (byte)(255 * (n8 - n6) / n8);
                byArray[n3++] = (byte)(255 * (n8 - n5) / n8);
                byArray[n3++] = (byte)(255 * (n8 - n4) / n8);
                byArray[n3++] = (byte)n7;
                continue;
            }
            byArray[n3++] = 0;
            byArray[n3++] = 0;
            byArray[n3++] = 0;
            byArray[n3++] = (byte)n7;
        }
        return byArray;
    }

    public static int toCmyk(int argbPixel) {
        int n2 = argbPixel & 0xFF;
        int n3 = argbPixel >> 8 & 0xFF;
        int n4 = argbPixel >> 16 & 0xFF;
        int n5 = bD.d(bD.d(255 - n2, 255 - n3), 255 - n4);
        if (n5 < 255) {
            int n6 = 255 - n5;
            int n7 = 255 * (n6 - n4) / n6;
            int n8 = 255 * (n6 - n3) / n6;
            int n9 = 255 * (n6 - n2) / n6;
            return n7 << 24 | n8 << 16 | n9 << 8 | n5;
        }
        return n5;
    }

    public static int toCmyk(Color pixel) {
        return CmykColorHelper.toCmyk(pixel.toArgb());
    }

    public static int[] toCmyk(Color[] pixels) {
        int[] nArray = new int[pixels.length];
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int n2 = pixels[i2].toArgb();
            int n3 = n2 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 >> 16 & 0xFF;
            int n6 = bD.d(bD.d(255 - n3, 255 - n4), 255 - n5);
            if (n6 < 255) {
                int n7 = 255 - n6;
                int n8 = 255 * (n7 - n5) / n7;
                int n9 = 255 * (n7 - n4) / n7;
                int n10 = 255 * (n7 - n3) / n7;
                nArray[i2] = n8 << 24 | n9 << 16 | n10 << 8 | n6;
                continue;
            }
            nArray[i2] = n6;
        }
        return nArray;
    }

    public static Color[] toArgb(int[] cmykPixels) {
        Color[] colorArray = new Color[cmykPixels.length];
        for (int i2 = 0; i2 < cmykPixels.length; ++i2) {
            int n2 = cmykPixels[i2];
            int n3 = n2 >> 24 & 0xFF;
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = (255 - n3) * (255 - n6) / 255;
            int n8 = (255 - n4) * (255 - n6) / 255;
            int n9 = (255 - n5) * (255 - n6) / 255;
            int n10 = 0xFF000000 | n7 << 16 | n8 << 8 | n9;
            colorArray[i2] = Color.fromArgb(n10);
        }
        return colorArray;
    }

    public static Color toArgb(int cmykPixel) {
        int n2 = cmykPixel >> 24 & 0xFF;
        int n3 = cmykPixel >> 16 & 0xFF;
        int n4 = cmykPixel >> 8 & 0xFF;
        int n5 = cmykPixel & 0xFF;
        int n6 = (255 - n2) * (255 - n5) / 255;
        int n7 = (255 - n3) * (255 - n5) / 255;
        int n8 = (255 - n4) * (255 - n5) / 255;
        int n9 = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
        return Color.fromArgb(n9);
    }

    public static int[] toArgb32(int[] cmykPixels) {
        int[] nArray = new int[cmykPixels.length];
        for (int i2 = 0; i2 < cmykPixels.length; ++i2) {
            int n2 = cmykPixels[i2];
            int n3 = n2 >> 24 & 0xFF;
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = (255 - n3) * (255 - n6) / 255;
            int n8 = (255 - n4) * (255 - n6) / 255;
            int n9 = (255 - n5) * (255 - n6) / 255;
            nArray[i2] = 0xFF000000 | n7 << 16 | n8 << 8 | n9;
        }
        return nArray;
    }

    public static Color[] toArgbIcc(int[] cmykPixels) {
        return CmykColorHelper.toArgbIcc_internalized(cmykPixels, aF.a().getStream(), aF.b().getStream());
    }

    public static Color[] toArgbIcc(int[] cmykPixels, InputStream cmykIccStream, InputStream rgbIccStream) {
        return CmykColorHelper.toArgbIcc_internalized(cmykPixels, Stream.fromJava(cmykIccStream), Stream.fromJava(rgbIccStream));
    }

    static Color[] toArgbIcc_internalized(int[] cmykPixels, Stream cmykIccStream, Stream rgbIccStream) {
        a a2 = new a(cmykIccStream, rgbIccStream);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        Color[] colorArray = new Color[cmykPixels.length];
        for (int i2 = 0; i2 < cmykPixels.length; ++i2) {
            int n2 = cmykPixels[i2];
            dArray2[0] = (double)(n2 >> 24 & 0xFF) / 255.0;
            dArray2[1] = (double)(n2 >> 16 & 0xFF) / 255.0;
            dArray2[2] = (double)(n2 >> 8 & 0xFF) / 255.0;
            dArray2[3] = (double)(n2 & 0xFF) / 255.0;
            a2.a(dArray2, dArray);
            int n3 = d.b(dArray[0] * 255.0) & 0xFF;
            int n4 = d.b(dArray[1] * 255.0) & 0xFF;
            int n5 = d.b(dArray[2] * 255.0) & 0xFF;
            int n6 = 0xFF000000 | n3 << 16 | n4 << 8 | n5;
            colorArray[i2] = Color.fromArgb(n6);
        }
        return colorArray;
    }

    public static Color toArgbIcc(int cmykPixel) {
        return CmykColorHelper.toArgbIcc_internalized(cmykPixel, aF.a().getStream(), aF.b().getStream());
    }

    public static Color toArgbIcc(int cmykPixel, InputStream cmykIccStream, InputStream rgbIccStream) {
        return CmykColorHelper.toArgbIcc_internalized(cmykPixel, Stream.fromJava(cmykIccStream), Stream.fromJava(rgbIccStream));
    }

    static Color toArgbIcc_internalized(int cmykPixel, Stream cmykIccStream, Stream rgbIccStream) {
        a a2 = new a(cmykIccStream, rgbIccStream);
        double[] dArray = new double[3];
        double[] dArray2 = new double[]{(double)(cmykPixel >> 24 & 0xFF) / 255.0, (double)(cmykPixel >> 16 & 0xFF) / 255.0, (double)(cmykPixel >> 8 & 0xFF) / 255.0, (double)(cmykPixel & 0xFF) / 255.0};
        a2.a(dArray2, dArray);
        int n2 = d.b(dArray[0] * 255.0) & 0xFF;
        int n3 = d.b(dArray[1] * 255.0) & 0xFF;
        int n4 = d.b(dArray[2] * 255.0) & 0xFF;
        int n5 = 0xFF000000 | n2 << 16 | n3 << 8 | n4;
        return Color.fromArgb(n5);
    }

    public static int[] toCmykIcc(Color[] pixels, InputStream rgbIccStream, InputStream cmykIccStream) {
        return CmykColorHelper.toCmykIcc_internalized(pixels, Stream.fromJava(rgbIccStream), Stream.fromJava(cmykIccStream));
    }

    static int[] toCmykIcc_internalized(Color[] pixels, Stream rgbIccStream, Stream cmykIccStream) {
        a a2 = new a(rgbIccStream, cmykIccStream);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        int[] nArray = new int[pixels.length];
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int n2 = pixels[i2].toArgb();
            dArray[0] = (double)(n2 >> 16 & 0xFF) / 255.0;
            dArray[1] = (double)(n2 >> 8 & 0xFF) / 255.0;
            dArray[2] = (double)(n2 & 0xFF) / 255.0;
            a2.a(dArray, dArray2);
            int n3 = d.b(dArray2[0] * 255.0) & 0xFF;
            int n4 = d.b(dArray2[1] * 255.0) & 0xFF;
            int n5 = d.b(dArray2[2] * 255.0) & 0xFF;
            int n6 = d.b(dArray2[3] * 255.0) & 0xFF;
            nArray[i2] = n3 << 24 | n4 << 16 | n5 << 8 | n6;
        }
        return nArray;
    }

    public static byte[] toCmykIccBytes(int[] pixels, int startIndex, int length, InputStream rgbIccStream, InputStream cmykIccStream) {
        return CmykColorHelper.a(pixels, startIndex, length, Stream.fromJava(rgbIccStream), Stream.fromJava(cmykIccStream));
    }

    public static byte[] a(int[] nArray, int n2, int n3, Stream stream, Stream stream2) {
        a a2 = new a(stream, stream2);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        int n4 = bD.d(n2 + n3, nArray.length);
        byte[] byArray = new byte[(n4 - n2) * 4];
        int n5 = 0;
        for (int i2 = n2; i2 < n4; ++i2) {
            dArray[0] = (double)(nArray[i2] >> 16 & 0xFF) / 255.0;
            dArray[1] = (double)(nArray[i2] >> 8 & 0xFF) / 255.0;
            dArray[2] = (double)(nArray[i2] & 0xFF) / 255.0;
            a2.a(dArray, dArray2);
            byArray[n5++] = d.b(dArray2[0] * 255.0);
            byArray[n5++] = d.b(dArray2[1] * 255.0);
            byArray[n5++] = d.b(dArray2[2] * 255.0);
            byArray[n5++] = d.b(dArray2[3] * 255.0);
        }
        return byArray;
    }

    public static int[] toCmykIcc(Color[] pixels) {
        return CmykColorHelper.toCmykIcc_internalized(pixels, aF.b().getStream(), aF.a().getStream());
    }

    public static int toCmykIcc(Color pixel) {
        return CmykColorHelper.toCmykIcc_internalized(pixel, aF.b().getStream(), aF.a().getStream());
    }

    public static int toCmykIcc(Color pixel, InputStream rgbIccStream, InputStream cmykIccStream) {
        return CmykColorHelper.toCmykIcc_internalized(pixel, Stream.fromJava(rgbIccStream), Stream.fromJava(cmykIccStream));
    }

    static int toCmykIcc_internalized(Color pixel, Stream rgbIccStream, Stream cmykIccStream) {
        a a2 = new a(rgbIccStream, cmykIccStream);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        int n2 = pixel.toArgb();
        dArray[0] = (double)(n2 >> 16 & 0xFF) / 255.0;
        dArray[1] = (double)(n2 >> 8 & 0xFF) / 255.0;
        dArray[2] = (double)(n2 & 0xFF) / 255.0;
        a2.a(dArray, dArray2);
        int n3 = d.b(dArray2[0] * 255.0) & 0xFF;
        int n4 = d.b(dArray2[1] * 255.0) & 0xFF;
        int n5 = d.b(dArray2[2] * 255.0) & 0xFF;
        int n6 = d.b(dArray2[3] * 255.0) & 0xFF;
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }
}

