/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.psd.internal.bouncycastle.asn1.x509.CertificatePair;
import com.aspose.psd.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jce.provider.X509CertificateObject;
import com.aspose.psd.internal.bouncycastle.x509.c;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;

public class X509CertificatePair {
    private final JcaJceHelper a = new BCJcaJceHelper();
    private X509Certificate b;
    private X509Certificate c;

    public X509CertificatePair(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        this.b = x509Certificate;
        this.c = x509Certificate2;
    }

    public X509CertificatePair(CertificatePair certificatePair) throws CertificateParsingException {
        if (certificatePair.getForward() != null) {
            this.b = new X509CertificateObject(certificatePair.getForward());
        }
        if (certificatePair.getReverse() != null) {
            this.c = new X509CertificateObject(certificatePair.getReverse());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        Certificate certificate = null;
        Certificate certificate2 = null;
        try {
            if (this.b != null && (certificate = Certificate.getInstance(new ASN1InputStream(this.b.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for forward");
            }
            if (this.c != null && (certificate2 = Certificate.getInstance(new ASN1InputStream(this.c.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for reverse");
            }
            return new CertificatePair(certificate, certificate2).getEncoded("DER");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new c(illegalArgumentException.toString(), illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new c(iOException.toString(), iOException);
        }
    }

    public X509Certificate getForward() {
        return this.b;
    }

    public X509Certificate getReverse() {
        return this.c;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof X509CertificatePair)) {
            return false;
        }
        X509CertificatePair x509CertificatePair = (X509CertificatePair)object;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.b != null) {
            bl3 = this.b.equals(x509CertificatePair.b);
        } else if (x509CertificatePair.b != null) {
            bl3 = false;
        }
        if (this.c != null) {
            bl2 = this.c.equals(x509CertificatePair.c);
        } else if (x509CertificatePair.c != null) {
            bl2 = false;
        }
        return bl3 && bl2;
    }

    public int hashCode() {
        int n2 = -1;
        if (this.b != null) {
            n2 ^= this.b.hashCode();
        }
        if (this.c != null) {
            n2 *= 17;
            n2 ^= this.c.hashCode();
        }
        return n2;
    }
}

