/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA256Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA512Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHAKEDigest;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTSigner;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.interfaces.StateAwareSignature;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPrivateKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPublicKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSMTSignatureSpi
extends Signature
implements StateAwareSignature {
    private Digest a;
    private XMSSMTSigner b;
    private ASN1ObjectIdentifier c;
    private SecureRandom d;

    protected XMSSMTSignatureSpi(String string) {
        super(string);
    }

    protected XMSSMTSignatureSpi(String string, Digest digest, XMSSMTSigner xMSSMTSigner) {
        super(string);
        this.a = digest;
        this.b = xMSSMTSigner;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCXMSSMTPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to XMSSMT");
        }
        CipherParameters cipherParameters = ((BCXMSSMTPublicKey)publicKey).getKeyParams();
        this.c = null;
        this.a.reset();
        this.b.init(false, cipherParameters);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.d = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters cipherParameters;
        if (privateKey instanceof BCXMSSMTPrivateKey) {
            cipherParameters = ((BCXMSSMTPrivateKey)privateKey).getKeyParams();
            this.c = ((BCXMSSMTPrivateKey)privateKey).getTreeDigestOID();
            if (this.d != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, this.d);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to XMSSMT");
        }
        this.a.reset();
        this.b.init(true, cipherParameters);
    }

    @Override
    protected void engineUpdate(byte by2) throws SignatureException {
        this.a.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.a.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a.a(this.a);
        try {
            byte[] byArray2 = this.b.generateSignature(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            if (exception instanceof IllegalStateException) {
                throw new SignatureException(exception.getMessage());
            }
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a.a(this.a);
        return this.b.verifySignature(byArray2, byArray);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public PrivateKey getUpdatedPrivateKey() {
        if (this.c == null) {
            throw new IllegalStateException("signature object not in a signing state");
        }
        BCXMSSMTPrivateKey bCXMSSMTPrivateKey = new BCXMSSMTPrivateKey(this.c, (XMSSMTPrivateKeyParameters)this.b.getUpdatedPrivateKey());
        this.c = null;
        return bCXMSSMTPrivateKey;
    }

    public static class withSha256
    extends XMSSMTSignatureSpi {
        public withSha256() {
            super("SHA256withXMSSMT", new SHA256Digest(), new XMSSMTSigner());
        }
    }

    public static class withSha512
    extends XMSSMTSignatureSpi {
        public withSha512() {
            super("SHA512withXMSSMT", new SHA512Digest(), new XMSSMTSigner());
        }
    }

    public static class withShake128
    extends XMSSMTSignatureSpi {
        public withShake128() {
            super("SHAKE128withXMSSMT", new SHAKEDigest(128), new XMSSMTSigner());
        }
    }

    public static class withShake256
    extends XMSSMTSignatureSpi {
        public withShake256() {
            super("SHAKE256withXMSSMT", new SHAKEDigest(256), new XMSSMTSigner());
        }
    }
}

