/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.newhope;

import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.ExchangePair;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.newhope.NHAgreement;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.newhope.BCNHPrivateKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.newhope.BCNHPublicKey;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private NHAgreement a;
    private BCNHPublicKey b;
    private NHExchangePairGenerator c;
    private byte[] d;

    public KeyAgreementSpi() {
        super("NH", null);
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key != null) {
            this.a = new NHAgreement();
            this.a.init(((BCNHPrivateKey)key).getKeyParams());
        } else {
            this.c = new NHExchangePairGenerator(secureRandom);
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("NewHope does not require parameters");
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl2) throws InvalidKeyException, IllegalStateException {
        if (!bl2) {
            throw new IllegalStateException("NewHope can only be between two parties.");
        }
        this.b = (BCNHPublicKey)key;
        if (this.c != null) {
            ExchangePair exchangePair = this.c.generateExchange((AsymmetricKeyParameter)this.b.getKeyParams());
            this.d = exchangePair.getSharedValue();
            return new BCNHPublicKey((NHPublicKeyParameters)exchangePair.getPublicKey());
        }
        this.d = this.a.calculateAgreement(this.b.getKeyParams());
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] byArray = Arrays.clone(this.d);
        Arrays.fill(this.d, (byte)0);
        return byArray;
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        System.arraycopy(this.d, 0, byArray, n2, this.d.length);
        Arrays.fill(this.d, (byte)0);
        return this.d.length;
    }

    @Override
    protected byte[] calcSecret() {
        return this.engineGenerateSecret();
    }
}

