/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.l;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;

public final class XMSSMTPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSMTParameters a;
    private final long b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;
    private final BDSStateMap g;

    private XMSSMTPrivateKeyParameters(Builder builder) {
        super(true);
        this.a = builder.a;
        if (this.a == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.a.getDigestSize();
        byte[] byArray = builder.h;
        if (byArray != null) {
            if (builder.i == null) {
                throw new NullPointerException("xmss == null");
            }
            int n3 = this.a.getHeight();
            int n4 = (n3 + 7) / 8;
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n2;
            int n9 = 0;
            this.b = XMSSUtil.bytesToXBigEndian(byArray, n9, n4);
            if (!XMSSUtil.isIndexValid(n3, this.b)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
            this.d = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
            this.e = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
            this.f = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
            BDSStateMap bDSStateMap = null;
            try {
                bDSStateMap = (BDSStateMap)XMSSUtil.deserialize(byArray2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            bDSStateMap.setXMSS(builder.i);
            this.g = bDSStateMap;
        } else {
            this.b = builder.b;
            byte[] byArray3 = builder.c;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.c = byArray3;
            } else {
                this.c = new byte[n2];
            }
            byte[] byArray4 = builder.d;
            if (byArray4 != null) {
                if (byArray4.length != n2) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.d = byArray4;
            } else {
                this.d = new byte[n2];
            }
            byte[] byArray5 = builder.e;
            if (byArray5 != null) {
                if (byArray5.length != n2) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.e = byArray5;
            } else {
                this.e = new byte[n2];
            }
            byte[] byArray6 = builder.f;
            if (byArray6 != null) {
                if (byArray6.length != n2) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.f = byArray6;
            } else {
                this.f = new byte[n2];
            }
            BDSStateMap bDSStateMap = builder.g;
            if (bDSStateMap != null) {
                this.g = bDSStateMap;
            } else {
                long l2 = builder.b;
                int n10 = this.a.getHeight();
                this.g = XMSSUtil.isIndexValid(n10, l2) && byArray5 != null && byArray3 != null ? new BDSStateMap(this.a, builder.b, byArray5, byArray3) : new BDSStateMap();
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.a.getDigestSize();
        int n3 = (this.a.getHeight() + 7) / 8;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n3 + n4 + n5 + n6 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        byte[] byArray2 = XMSSUtil.toBytesBigEndian(this.b, n3);
        XMSSUtil.copyBytesAtOffset(byArray, byArray2, n9);
        XMSSUtil.copyBytesAtOffset(byArray, this.c, n9 += n3);
        XMSSUtil.copyBytesAtOffset(byArray, this.d, n9 += n4);
        XMSSUtil.copyBytesAtOffset(byArray, this.e, n9 += n5);
        XMSSUtil.copyBytesAtOffset(byArray, this.f, n9 += n6);
        byte[] byArray3 = null;
        try {
            byArray3 = XMSSUtil.serialize(this.g);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("error serializing bds state");
        }
        return Arrays.concatenate(byArray, byArray3);
    }

    public long getIndex() {
        return this.b;
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.c);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.d);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.e);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.f);
    }

    BDSStateMap getBDSState() {
        return this.g;
    }

    public XMSSMTParameters getParameters() {
        return this.a;
    }

    public XMSSMTPrivateKeyParameters getNextKey() {
        BDSStateMap bDSStateMap = new BDSStateMap(this.g, this.a, this.getIndex(), this.e, this.c);
        return new Builder(this.a).withIndex(this.b + 1L).withSecretKeySeed(this.c).withSecretKeyPRF(this.d).withPublicSeed(this.e).withRoot(this.f).withBDSState(bDSStateMap).build();
    }

    /* synthetic */ XMSSMTPrivateKeyParameters(Builder builder, l l2) {
        this(builder);
    }

    public static class Builder {
        private final XMSSMTParameters a;
        private long b = 0L;
        private byte[] c = null;
        private byte[] d = null;
        private byte[] e = null;
        private byte[] f = null;
        private BDSStateMap g = null;
        private byte[] h = null;
        private XMSSParameters i = null;

        public Builder(XMSSMTParameters xMSSMTParameters) {
            this.a = xMSSMTParameters;
        }

        public Builder withIndex(long l2) {
            this.b = l2;
            return this;
        }

        public Builder withSecretKeySeed(byte[] byArray) {
            this.c = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] byArray) {
            this.d = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.e = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withRoot(byte[] byArray) {
            this.f = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withBDSState(BDSStateMap bDSStateMap) {
            this.g = bDSStateMap;
            return this;
        }

        public Builder withPrivateKey(byte[] byArray, XMSSParameters xMSSParameters) {
            this.h = XMSSUtil.cloneArray(byArray);
            this.i = xMSSParameters;
            return this;
        }

        public XMSSMTPrivateKeyParameters build() {
            return new XMSSMTPrivateKeyParameters(this, null);
        }
    }
}

