/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pkcs;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.ContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.MacData;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.Pfx;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import com.aspose.psd.internal.bouncycastle.pkcs.PKCSException;
import com.aspose.psd.internal.bouncycastle.pkcs.PKCSIOException;
import com.aspose.psd.internal.bouncycastle.pkcs.a;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;

public class PKCS12PfxPdu {
    private Pfx a;

    private static Pfx a(byte[] byArray) throws IOException {
        try {
            return Pfx.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new PKCSIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PKCSIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public PKCS12PfxPdu(Pfx pfx) {
        this.a = pfx;
    }

    public PKCS12PfxPdu(byte[] byArray) throws IOException {
        this(PKCS12PfxPdu.a(byArray));
    }

    public ContentInfo[] getContentInfos() {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(ASN1OctetString.getInstance(this.a.getAuthSafe().getContent()).getOctets());
        ContentInfo[] contentInfoArray = new ContentInfo[aSN1Sequence.size()];
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            contentInfoArray[i2] = ContentInfo.getInstance(aSN1Sequence.getObjectAt(i2));
        }
        return contentInfoArray;
    }

    public boolean hasMac() {
        return this.a.getMacData() != null;
    }

    public AlgorithmIdentifier getMacAlgorithmID() {
        MacData macData = this.a.getMacData();
        if (macData != null) {
            return macData.getMac().getAlgorithmId();
        }
        return null;
    }

    public boolean isMacValid(PKCS12MacCalculatorBuilderProvider pKCS12MacCalculatorBuilderProvider, char[] cArray) throws PKCSException {
        if (this.hasMac()) {
            MacData macData = this.a.getMacData();
            a a2 = new a(pKCS12MacCalculatorBuilderProvider.get(new AlgorithmIdentifier(macData.getMac().getAlgorithmId().getAlgorithm(), new PKCS12PBEParams(macData.getSalt(), macData.getIterationCount().intValue()))));
            try {
                MacData macData2 = a2.a(cArray, ASN1OctetString.getInstance(this.a.getAuthSafe().getContent()).getOctets());
                return Arrays.constantTimeAreEqual(macData2.getEncoded(), this.a.getMacData().getEncoded());
            }
            catch (IOException iOException) {
                throw new PKCSException("unable to process AuthSafe: " + iOException.getMessage());
            }
        }
        throw new IllegalStateException("no MAC present on PFX");
    }

    public Pfx toASN1Structure() {
        return this.a;
    }

    public byte[] getEncoded() throws IOException {
        return this.toASN1Structure().getEncoded();
    }

    public byte[] getEncoded(String string) throws IOException {
        return this.toASN1Structure().getEncoded(string);
    }
}

