/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.DERBitString;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.psd.internal.bouncycastle.asn1.x9.X9ECPoint;
import com.aspose.psd.internal.bouncycastle.asn1.x9.X9IntegerConverter;
import com.aspose.psd.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.aspose.psd.internal.bouncycastle.jce.interfaces.ECPointEncoder;
import com.aspose.psd.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.psd.internal.bouncycastle.jce.spec.ECParameterSpec;
import com.aspose.psd.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class BCECPublicKey
implements ECPointEncoder,
com.aspose.psd.internal.bouncycastle.jce.interfaces.ECPublicKey,
ECPublicKey {
    static final long serialVersionUID = 2422789860422731812L;
    private String a = "EC";
    private boolean b;
    private transient ECPublicKeyParameters c;
    private transient java.security.spec.ECParameterSpec d;
    private transient ProviderConfiguration e;

    public BCECPublicKey(String string, BCECPublicKey bCECPublicKey) {
        this.a = string;
        this.c = bCECPublicKey.c;
        this.d = bCECPublicKey.d;
        this.b = bCECPublicKey.b;
        this.e = bCECPublicKey.e;
    }

    public BCECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        this.a = string;
        this.d = eCPublicKeySpec.getParams();
        this.c = new ECPublicKeyParameters(EC5Util.convertPoint(this.d, eCPublicKeySpec.getW(), false), EC5Util.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
        this.e = providerConfiguration;
    }

    public BCECPublicKey(String string, com.aspose.psd.internal.bouncycastle.jce.spec.ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        this.a = string;
        if (eCPublicKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPublicKeySpec.getParams().getSeed());
            this.c = new ECPublicKeyParameters(eCPublicKeySpec.getQ(), ECUtil.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
            this.d = EC5Util.convertSpec(ellipticCurve, eCPublicKeySpec.getParams());
        } else {
            ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            this.c = new ECPublicKeyParameters(eCParameterSpec.getCurve().createPoint(eCPublicKeySpec.getQ().getAffineXCoord().toBigInteger(), eCPublicKeySpec.getQ().getAffineYCoord().toBigInteger()), EC5Util.getDomainParameters(providerConfiguration, null));
            this.d = null;
        }
        this.e = providerConfiguration;
    }

    public BCECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, java.security.spec.ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        this.c = eCPublicKeyParameters;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = this.a(ellipticCurve, eCDomainParameters);
        } else {
            this.d = eCParameterSpec;
        }
        this.e = providerConfiguration;
    }

    public BCECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = this.a(ellipticCurve, eCDomainParameters);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.d = EC5Util.convertSpec(ellipticCurve, eCParameterSpec);
        }
        this.c = eCPublicKeyParameters;
        this.e = providerConfiguration;
    }

    public BCECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ProviderConfiguration providerConfiguration) {
        this.a = string;
        this.c = eCPublicKeyParameters;
        this.d = null;
        this.e = providerConfiguration;
    }

    public BCECPublicKey(ECPublicKey eCPublicKey, ProviderConfiguration providerConfiguration) {
        this.a = eCPublicKey.getAlgorithm();
        this.d = eCPublicKey.getParams();
        this.c = new ECPublicKeyParameters(EC5Util.convertPoint(this.d, eCPublicKey.getW(), false), EC5Util.getDomainParameters(providerConfiguration, eCPublicKey.getParams()));
    }

    BCECPublicKey(String string, SubjectPublicKeyInfo subjectPublicKeyInfo, ProviderConfiguration providerConfiguration) {
        this.a = string;
        this.e = providerConfiguration;
        this.a(subjectPublicKeyInfo);
    }

    private java.security.spec.ECParameterSpec a(EllipticCurve ellipticCurve, ECDomainParameters eCDomainParameters) {
        return new java.security.spec.ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    private void a(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        int n2;
        X962Parameters x962Parameters = X962Parameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        ECCurve eCCurve = EC5Util.getCurve(this.e, x962Parameters);
        this.d = EC5Util.convertToSpec(x962Parameters, eCCurve);
        DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
        byte[] byArray = dERBitString.getBytes();
        ASN1OctetString aSN1OctetString = new DEROctetString(byArray);
        if (byArray[0] == 4 && byArray[1] == byArray.length - 2 && (byArray[2] == 2 || byArray[2] == 3) && (n2 = new X9IntegerConverter().getByteLength(eCCurve)) >= byArray.length - 3) {
            try {
                aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, aSN1OctetString);
        this.c = new ECPublicKeyParameters(x9ECPoint.getPoint(), ECUtil.getDomainParameters(this.e, x962Parameters));
    }

    @Override
    public String getAlgorithm() {
        return this.a;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        X962Parameters x962Parameters = com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(this.d, this.b);
        ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(new X9ECPoint(this.c.getQ(), this.b).toASN1Primitive());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), aSN1OctetString.getOctets());
        return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    @Override
    public java.security.spec.ECParameterSpec getParams() {
        return this.d;
    }

    @Override
    public ECParameterSpec getParameters() {
        if (this.d == null) {
            return null;
        }
        return EC5Util.convertSpec(this.d, this.b);
    }

    @Override
    public java.security.spec.ECPoint getW() {
        return EC5Util.convertPoint(this.c.getQ());
    }

    @Override
    public ECPoint getQ() {
        ECPoint eCPoint = this.c.getQ();
        if (this.d == null) {
            return eCPoint.getDetachedPoint();
        }
        return eCPoint;
    }

    ECPublicKeyParameters engineGetKeyParameters() {
        return this.c;
    }

    ECParameterSpec engineGetSpec() {
        if (this.d != null) {
            return EC5Util.convertSpec(this.d, this.b);
        }
        return this.e.getEcImplicitlyCa();
    }

    public String toString() {
        return ECUtil.publicKeyToString("EC", this.c.getQ(), this.engineGetSpec());
    }

    @Override
    public void setPointFormat(String string) {
        this.b = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECPublicKey)) {
            return false;
        }
        BCECPublicKey bCECPublicKey = (BCECPublicKey)object;
        return this.c.getQ().equals(bCECPublicKey.c.getQ()) && this.engineGetSpec().equals(bCECPublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.c.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.e = BouncyCastleProvider.CONFIGURATION;
        this.a(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

