/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.dsa;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DSA;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.NullDigest;
import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.aspose.psd.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class DSASigner
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest a;
    private DSA b;
    private SecureRandom c;

    protected DSASigner(Digest digest, DSA dSA) {
        this.a = digest;
        this.b = dSA;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = DSAUtil.generatePublicKeyParameter(publicKey);
        this.a.reset();
        this.b.init(false, asymmetricKeyParameter);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.c = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters cipherParameters = DSAUtil.generatePrivateKeyParameter(privateKey);
        if (this.c != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.c);
        }
        this.a.reset();
        this.b.init(true, cipherParameters);
    }

    @Override
    protected void engineUpdate(byte by2) throws SignatureException {
        this.a.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.a.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        try {
            BigInteger[] bigIntegerArray = this.b.generateSignature(byArray);
            return this.a(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger[] bigIntegerArray;
        byte[] byArray2 = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray2, 0);
        try {
            bigIntegerArray = this.a(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.b.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    private byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Integer[]{new ASN1Integer(bigInteger), new ASN1Integer(bigInteger2)};
        return new DERSequence(aSN1EncodableArray).getEncoded("DER");
    }

    private BigInteger[] a(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        if (aSN1Sequence.size() != 2) {
            throw new IOException("malformed signature");
        }
        if (!Arrays.areEqual(byArray, aSN1Sequence.getEncoded("DER"))) {
            throw new IOException("malformed signature");
        }
        return new BigInteger[]{((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue()};
    }

    public static class detDSA
    extends DSASigner {
        public detDSA() {
            super(DigestFactory.createSHA1(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA1())));
        }
    }

    public static class detDSA224
    extends DSASigner {
        public detDSA224() {
            super(DigestFactory.createSHA224(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA224())));
        }
    }

    public static class detDSA256
    extends DSASigner {
        public detDSA256() {
            super(DigestFactory.createSHA256(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA256())));
        }
    }

    public static class detDSA384
    extends DSASigner {
        public detDSA384() {
            super(DigestFactory.createSHA384(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA384())));
        }
    }

    public static class detDSA512
    extends DSASigner {
        public detDSA512() {
            super(DigestFactory.createSHA512(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA512())));
        }
    }

    public static class detDSASha3_224
    extends DSASigner {
        public detDSASha3_224() {
            super(DigestFactory.createSHA3_224(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_224())));
        }
    }

    public static class detDSASha3_256
    extends DSASigner {
        public detDSASha3_256() {
            super(DigestFactory.createSHA3_256(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_256())));
        }
    }

    public static class detDSASha3_384
    extends DSASigner {
        public detDSASha3_384() {
            super(DigestFactory.createSHA3_384(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_384())));
        }
    }

    public static class detDSASha3_512
    extends DSASigner {
        public detDSASha3_512() {
            super(DigestFactory.createSHA3_512(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_512())));
        }
    }

    public static class dsa224
    extends DSASigner {
        public dsa224() {
            super(DigestFactory.createSHA224(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa256
    extends DSASigner {
        public dsa256() {
            super(DigestFactory.createSHA256(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa384
    extends DSASigner {
        public dsa384() {
            super(DigestFactory.createSHA384(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa512
    extends DSASigner {
        public dsa512() {
            super(DigestFactory.createSHA512(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_224
    extends DSASigner {
        public dsaSha3_224() {
            super(DigestFactory.createSHA3_224(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_256
    extends DSASigner {
        public dsaSha3_256() {
            super(DigestFactory.createSHA3_256(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_384
    extends DSASigner {
        public dsaSha3_384() {
            super(DigestFactory.createSHA3_384(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_512
    extends DSASigner {
        public dsaSha3_512() {
            super(DigestFactory.createSHA3_512(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class noneDSA
    extends DSASigner {
        public noneDSA() {
            super(new NullDigest(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class stdDSA
    extends DSASigner {
        public stdDSA() {
            super(DigestFactory.createSHA1(), new com.aspose.psd.internal.bouncycastle.crypto.signers.DSASigner());
        }
    }
}

