/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce;

import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.psd.internal.bouncycastle.jcajce.PKIXCRLStore;
import com.aspose.psd.internal.bouncycastle.jcajce.PKIXCertStore;
import com.aspose.psd.internal.bouncycastle.jcajce.PKIXCertStoreSelector;
import com.aspose.psd.internal.bouncycastle.jcajce.d;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PKIXExtendedParameters
implements CertPathParameters {
    public static final int PKIX_VALIDITY_MODEL = 0;
    public static final int CHAIN_VALIDITY_MODEL = 1;
    private final PKIXParameters a;
    private final PKIXCertStoreSelector b;
    private final Date c;
    private final List<PKIXCertStore> d;
    private final Map<GeneralName, PKIXCertStore> e;
    private final List<PKIXCRLStore> f;
    private final Map<GeneralName, PKIXCRLStore> g;
    private final boolean h;
    private final boolean i;
    private final int j;
    private final Set<TrustAnchor> k;

    private PKIXExtendedParameters(Builder builder) {
        this.a = builder.a;
        this.c = builder.b;
        this.d = Collections.unmodifiableList(builder.d);
        this.e = Collections.unmodifiableMap(new HashMap(builder.e));
        this.f = Collections.unmodifiableList(builder.f);
        this.g = Collections.unmodifiableMap(new HashMap(builder.g));
        this.b = builder.c;
        this.h = builder.h;
        this.i = builder.j;
        this.j = builder.i;
        this.k = Collections.unmodifiableSet(builder.k);
    }

    public List<PKIXCertStore> getCertificateStores() {
        return this.d;
    }

    public Map<GeneralName, PKIXCertStore> getNamedCertificateStoreMap() {
        return this.e;
    }

    public List<PKIXCRLStore> getCRLStores() {
        return this.f;
    }

    public Map<GeneralName, PKIXCRLStore> getNamedCRLStoreMap() {
        return this.g;
    }

    public Date getDate() {
        return new Date(this.c.getTime());
    }

    public boolean isUseDeltasEnabled() {
        return this.i;
    }

    public int getValidityModel() {
        return this.j;
    }

    @Override
    public Object clone() {
        return this;
    }

    public PKIXCertStoreSelector getTargetConstraints() {
        return this.b;
    }

    public Set getTrustAnchors() {
        return this.k;
    }

    public Set getInitialPolicies() {
        return this.a.getInitialPolicies();
    }

    public String getSigProvider() {
        return this.a.getSigProvider();
    }

    public boolean isExplicitPolicyRequired() {
        return this.a.isExplicitPolicyRequired();
    }

    public boolean isAnyPolicyInhibited() {
        return this.a.isAnyPolicyInhibited();
    }

    public boolean isPolicyMappingInhibited() {
        return this.a.isPolicyMappingInhibited();
    }

    public List getCertPathCheckers() {
        return this.a.getCertPathCheckers();
    }

    public List<CertStore> getCertStores() {
        return this.a.getCertStores();
    }

    public boolean isRevocationEnabled() {
        return this.h;
    }

    /* synthetic */ PKIXExtendedParameters(Builder builder, d d2) {
        this(builder);
    }

    public static class Builder {
        private final PKIXParameters a;
        private final Date b;
        private PKIXCertStoreSelector c;
        private List<PKIXCertStore> d = new ArrayList<PKIXCertStore>();
        private Map<GeneralName, PKIXCertStore> e = new HashMap<GeneralName, PKIXCertStore>();
        private List<PKIXCRLStore> f = new ArrayList<PKIXCRLStore>();
        private Map<GeneralName, PKIXCRLStore> g = new HashMap<GeneralName, PKIXCRLStore>();
        private boolean h;
        private int i = 0;
        private boolean j = false;
        private Set<TrustAnchor> k;

        public Builder(PKIXParameters pKIXParameters) {
            Date date;
            this.a = (PKIXParameters)pKIXParameters.clone();
            CertSelector certSelector = pKIXParameters.getTargetCertConstraints();
            if (certSelector != null) {
                this.c = new PKIXCertStoreSelector.Builder(certSelector).build();
            }
            this.b = (date = pKIXParameters.getDate()) == null ? new Date() : date;
            this.h = pKIXParameters.isRevocationEnabled();
            this.k = pKIXParameters.getTrustAnchors();
        }

        public Builder(PKIXExtendedParameters pKIXExtendedParameters) {
            this.a = pKIXExtendedParameters.a;
            this.b = pKIXExtendedParameters.c;
            this.c = pKIXExtendedParameters.b;
            this.d = new ArrayList<PKIXCertStore>(pKIXExtendedParameters.d);
            this.e = new HashMap<GeneralName, PKIXCertStore>(pKIXExtendedParameters.e);
            this.f = new ArrayList<PKIXCRLStore>(pKIXExtendedParameters.f);
            this.g = new HashMap<GeneralName, PKIXCRLStore>(pKIXExtendedParameters.g);
            this.j = pKIXExtendedParameters.i;
            this.i = pKIXExtendedParameters.j;
            this.h = pKIXExtendedParameters.isRevocationEnabled();
            this.k = pKIXExtendedParameters.getTrustAnchors();
        }

        public Builder addCertificateStore(PKIXCertStore pKIXCertStore) {
            this.d.add(pKIXCertStore);
            return this;
        }

        public Builder addNamedCertificateStore(GeneralName generalName, PKIXCertStore pKIXCertStore) {
            this.e.put(generalName, pKIXCertStore);
            return this;
        }

        public Builder addCRLStore(PKIXCRLStore pKIXCRLStore) {
            this.f.add(pKIXCRLStore);
            return this;
        }

        public Builder addNamedCRLStore(GeneralName generalName, PKIXCRLStore pKIXCRLStore) {
            this.g.put(generalName, pKIXCRLStore);
            return this;
        }

        public Builder setTargetConstraints(PKIXCertStoreSelector pKIXCertStoreSelector) {
            this.c = pKIXCertStoreSelector;
            return this;
        }

        public Builder setUseDeltasEnabled(boolean bl2) {
            this.j = bl2;
            return this;
        }

        public Builder setValidityModel(int n2) {
            this.i = n2;
            return this;
        }

        public Builder setTrustAnchor(TrustAnchor trustAnchor) {
            this.k = Collections.singleton(trustAnchor);
            return this;
        }

        public Builder setTrustAnchors(Set<TrustAnchor> set) {
            this.k = set;
            return this;
        }

        public void setRevocationEnabled(boolean bl2) {
            this.h = bl2;
        }

        public PKIXExtendedParameters build() {
            return new PKIXExtendedParameters(this, null);
        }
    }
}

