/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.eac.operator.jcajce;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.eac.operator.EACSigner;
import com.aspose.psd.internal.bouncycastle.eac.operator.jcajce.b;
import com.aspose.psd.internal.bouncycastle.eac.operator.jcajce.e;
import com.aspose.psd.internal.bouncycastle.eac.operator.jcajce.f;
import com.aspose.psd.internal.bouncycastle.eac.operator.jcajce.g;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.psd.internal.bouncycastle.operator.OperatorStreamException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Hashtable;

public class JcaEACSignerBuilder {
    private static final Hashtable a = new Hashtable();
    private b b = new com.aspose.psd.internal.bouncycastle.eac.operator.jcajce.a();

    public JcaEACSignerBuilder setProvider(String string) {
        this.b = new f(string);
        return this;
    }

    public JcaEACSignerBuilder setProvider(Provider provider) {
        this.b = new g(provider);
        return this;
    }

    public EACSigner build(String string, PrivateKey privateKey) throws OperatorCreationException {
        return this.build((ASN1ObjectIdentifier)a.get(string), privateKey);
    }

    public EACSigner build(ASN1ObjectIdentifier aSN1ObjectIdentifier, PrivateKey privateKey) throws OperatorCreationException {
        Signature signature;
        try {
            signature = this.b.a(aSN1ObjectIdentifier);
            signature.initSign(privateKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OperatorCreationException("unable to find algorithm: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new OperatorCreationException("unable to find provider: " + noSuchProviderException.getMessage(), noSuchProviderException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new OperatorCreationException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        a a2 = new a(signature);
        return new e(this, aSN1ObjectIdentifier, a2);
    }

    public static int max(int n2, int n3) {
        return n2 > n3 ? n2 : n3;
    }

    private static byte[] a(byte[] byArray) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
        BigInteger bigInteger = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue();
        BigInteger bigInteger2 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
        byte[] byArray2 = bigInteger.toByteArray();
        byte[] byArray3 = bigInteger2.toByteArray();
        int n2 = JcaEACSignerBuilder.b(byArray2);
        int n3 = JcaEACSignerBuilder.b(byArray3);
        int n4 = JcaEACSignerBuilder.max(n2, n3);
        byte[] byArray4 = new byte[n4 * 2];
        Arrays.fill(byArray4, (byte)0);
        JcaEACSignerBuilder.a(byArray2, byArray4, n4 - n2);
        JcaEACSignerBuilder.a(byArray3, byArray4, 2 * n4 - n3);
        return byArray4;
    }

    private static int b(byte[] byArray) {
        int n2 = byArray.length;
        if (byArray[0] == 0) {
            --n2;
        }
        return n2;
    }

    private static void a(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = byArray.length;
        int n4 = 0;
        if (byArray[0] == 0) {
            --n3;
            n4 = 1;
        }
        System.arraycopy(byArray, n4, byArray2, n2, n3);
    }

    static /* synthetic */ byte[] access$000(byte[] byArray) {
        return JcaEACSignerBuilder.a(byArray);
    }

    static {
        a.put("SHA1withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1);
        a.put("SHA256withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256);
        a.put("SHA1withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1);
        a.put("SHA256withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256);
        a.put("SHA512withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_512);
        a.put("SHA512withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_512);
        a.put("SHA1withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_1);
        a.put("SHA224withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_224);
        a.put("SHA256withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_256);
        a.put("SHA384withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_384);
        a.put("SHA512withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_512);
    }

    private class a
    extends OutputStream {
        private Signature b;

        a(Signature signature) {
            this.b = signature;
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            try {
                this.b.update(byArray, n2, n3);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            try {
                this.b.update(byArray);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        @Override
        public void write(int n2) throws IOException {
            try {
                this.b.update((byte)n2);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        byte[] a() throws SignatureException {
            return this.b.sign();
        }
    }
}

