/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.util;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.DERNull;
import com.aspose.psd.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.crypto.util.PBKDFConfig;
import com.aspose.psd.internal.bouncycastle.crypto.util.e;
import com.aspose.psd.internal.bouncycastle.util.Integers;
import java.util.HashMap;
import java.util.Map;

public class PBKDF2Config
extends PBKDFConfig {
    public static final AlgorithmIdentifier PRF_SHA1 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA256 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA512 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA3_256 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_256, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA3_512 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512, DERNull.INSTANCE);
    private static final Map a = new HashMap();
    private final int b;
    private final int c;
    private final AlgorithmIdentifier d;

    static int getSaltSize(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (!a.containsKey(aSN1ObjectIdentifier)) {
            throw new IllegalStateException("no salt size for algorithm: " + aSN1ObjectIdentifier);
        }
        return (Integer)a.get(aSN1ObjectIdentifier);
    }

    private PBKDF2Config(Builder builder) {
        super(PKCSObjectIdentifiers.id_PBKDF2);
        this.b = builder.a;
        this.d = builder.c;
        this.c = builder.b < 0 ? PBKDF2Config.getSaltSize(this.d.getAlgorithm()) : builder.b;
    }

    public int getIterationCount() {
        return this.b;
    }

    public AlgorithmIdentifier getPRF() {
        return this.d;
    }

    public int getSaltLength() {
        return this.c;
    }

    /* synthetic */ PBKDF2Config(Builder builder, e e2) {
        this(builder);
    }

    static {
        a.put(PKCSObjectIdentifiers.id_hmacWithSHA1, Integers.valueOf(20));
        a.put(PKCSObjectIdentifiers.id_hmacWithSHA256, Integers.valueOf(32));
        a.put(PKCSObjectIdentifiers.id_hmacWithSHA512, Integers.valueOf(64));
        a.put(PKCSObjectIdentifiers.id_hmacWithSHA224, Integers.valueOf(28));
        a.put(PKCSObjectIdentifiers.id_hmacWithSHA384, Integers.valueOf(48));
        a.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, Integers.valueOf(28));
        a.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, Integers.valueOf(32));
        a.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, Integers.valueOf(48));
        a.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, Integers.valueOf(64));
        a.put(CryptoProObjectIdentifiers.gostR3411Hmac, Integers.valueOf(32));
        a.put(RosstandartObjectIdentifiers.id_tc26_hmac_gost_3411_12_256, Integers.valueOf(32));
        a.put(RosstandartObjectIdentifiers.id_tc26_hmac_gost_3411_12_512, Integers.valueOf(64));
        a.put(GMObjectIdentifiers.hmac_sm3, Integers.valueOf(32));
    }

    public static class Builder {
        private int a = 1024;
        private int b = -1;
        private AlgorithmIdentifier c = PRF_SHA1;

        public Builder withIterationCount(int n2) {
            this.a = n2;
            return this;
        }

        public Builder withPRF(AlgorithmIdentifier algorithmIdentifier) {
            this.c = algorithmIdentifier;
            return this;
        }

        public Builder withSaltLength(int n2) {
            this.b = n2;
            return this;
        }

        public PBKDF2Config build() {
            return new PBKDF2Config(this, null);
        }
    }
}

