/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.signers;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.CryptoException;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.Signer;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SM3Digest;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithID;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.crypto.signers.DSAKCalculator;
import com.aspose.psd.internal.bouncycastle.crypto.signers.RandomDSAKCalculator;
import com.aspose.psd.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.psd.internal.bouncycastle.math.ec.ECConstants;
import com.aspose.psd.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.psd.internal.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2Signer
implements Signer,
ECConstants {
    private final DSAKCalculator a = new RandomDSAKCalculator();
    private final SM3Digest b = new SM3Digest();
    private ECDomainParameters c;
    private ECPoint d;
    private ECKeyParameters e;
    private byte[] f;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        byte[] byArray;
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithID) {
            cipherParameters2 = ((ParametersWithID)cipherParameters).getParameters();
            byArray = ((ParametersWithID)cipherParameters).getID();
        } else {
            cipherParameters2 = cipherParameters;
            byArray = Hex.decode("31323334353637383132333435363738");
        }
        if (bl2) {
            if (cipherParameters2 instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters2;
                this.e = (ECKeyParameters)parametersWithRandom.getParameters();
                this.c = this.e.getParameters();
                this.a.init(this.c.getN(), parametersWithRandom.getRandom());
            } else {
                this.e = (ECKeyParameters)cipherParameters2;
                this.c = this.e.getParameters();
                this.a.init(this.c.getN(), new SecureRandom());
            }
            this.d = this.createBasePointMultiplier().multiply(this.c.getG(), ((ECPrivateKeyParameters)this.e).getD()).normalize();
        } else {
            this.e = (ECKeyParameters)cipherParameters2;
            this.c = this.e.getParameters();
            this.d = ((ECPublicKeyParameters)this.e).getQ();
        }
        this.f = this.a(byArray);
        this.b.update(this.f, 0, this.f.length);
    }

    @Override
    public void update(byte by2) {
        this.b.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.b.update(byArray, n2, n3);
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        try {
            BigInteger[] bigIntegerArray = this.derDecode(byArray);
            if (bigIntegerArray != null) {
                return this.a(bigIntegerArray[0], bigIntegerArray[1]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void reset() {
        this.b.reset();
        if (this.f != null) {
            this.b.update(this.f, 0, this.f.length);
        }
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray = this.a();
        BigInteger bigInteger3 = this.c.getN();
        BigInteger bigInteger4 = this.calculateE(byArray);
        BigInteger bigInteger5 = ((ECPrivateKeyParameters)this.e).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        while (true) {
            BigInteger bigInteger6 = this.a.nextK();
            Object object = eCMultiplier.multiply(this.c.getG(), bigInteger6).normalize();
            bigInteger2 = bigInteger4.add(((ECPoint)object).getAffineXCoord().toBigInteger()).mod(bigInteger3);
            if (bigInteger2.equals(ZERO) || bigInteger2.add(bigInteger6).equals(bigInteger3)) continue;
            object = bigInteger5.add(ONE).modInverse(bigInteger3);
            bigInteger = bigInteger6.subtract(bigInteger2.multiply(bigInteger5)).mod(bigInteger3);
            if (!(bigInteger = ((BigInteger)object).multiply(bigInteger).mod(bigInteger3)).equals(ZERO)) break;
        }
        try {
            return this.derEncode(bigInteger2, bigInteger);
        }
        catch (IOException iOException) {
            throw new CryptoException("unable to encode signature: " + iOException.getMessage(), iOException);
        }
    }

    private boolean a(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = this.c.getN();
        if (bigInteger.compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ONE) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        byte[] byArray = this.a();
        BigInteger bigInteger4 = this.calculateE(byArray);
        BigInteger bigInteger5 = bigInteger.add(bigInteger2).mod(bigInteger3);
        if (bigInteger5.equals(ZERO)) {
            return false;
        }
        ECPoint eCPoint = ((ECPublicKeyParameters)this.e).getQ();
        ECPoint eCPoint2 = ECAlgorithms.sumOfTwoMultiplies(this.c.getG(), bigInteger2, eCPoint, bigInteger5).normalize();
        if (eCPoint2.isInfinity()) {
            return false;
        }
        BigInteger bigInteger6 = bigInteger4.add(eCPoint2.getAffineXCoord().toBigInteger()).mod(bigInteger3);
        return bigInteger6.equals(bigInteger);
    }

    private byte[] a() {
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        this.reset();
        return byArray;
    }

    private byte[] a(byte[] byArray) {
        this.b.reset();
        this.a((Digest)this.b, byArray);
        this.a((Digest)this.b, this.c.getCurve().getA());
        this.a((Digest)this.b, this.c.getCurve().getB());
        this.a((Digest)this.b, this.c.getG().getAffineXCoord());
        this.a((Digest)this.b, this.c.getG().getAffineYCoord());
        this.a((Digest)this.b, this.d.getAffineXCoord());
        this.a((Digest)this.b, this.d.getAffineYCoord());
        byte[] byArray2 = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray2, 0);
        return byArray2;
    }

    private void a(Digest digest, byte[] byArray) {
        int n2 = byArray.length * 8;
        digest.update((byte)(n2 >> 8 & 0xFF));
        digest.update((byte)(n2 & 0xFF));
        digest.update(byArray, 0, byArray.length);
    }

    private void a(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = eCFieldElement.getEncoded();
        digest.update(byArray, 0, byArray.length);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected BigInteger calculateE(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    protected BigInteger[] derDecode(byte[] byArray) throws IOException {
        BigInteger bigInteger;
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(byArray));
        if (aSN1Sequence.size() != 2) {
            return null;
        }
        BigInteger bigInteger2 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue();
        byte[] byArray2 = this.derEncode(bigInteger2, bigInteger = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual(byArray2, byArray)) {
            return null;
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    protected byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(bigInteger));
        aSN1EncodableVector.add(new ASN1Integer(bigInteger2));
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }
}

