/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.params;

import com.aspose.psd.internal.bouncycastle.crypto.KeyGenerationParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKeyGenerationParameters
extends KeyGenerationParameters {
    private BigInteger a;
    private int b;

    public RSAKeyGenerationParameters(BigInteger bigInteger, SecureRandom secureRandom, int n2, int n3) {
        super(secureRandom, n2);
        if (n2 < 12) {
            throw new IllegalArgumentException("key strength too small");
        }
        if (!bigInteger.testBit(0)) {
            throw new IllegalArgumentException("public exponent cannot be even");
        }
        this.a = bigInteger;
        this.b = n3;
    }

    public BigInteger getPublicExponent() {
        return this.a;
    }

    public int getCertainty() {
        return this.b;
    }
}

