/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.agreement;

import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.generators.DHKeyPairGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.DHParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DHAgreement {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private DHPrivateKeyParameters b;
    private DHParameters c;
    private BigInteger d;
    private SecureRandom e;

    public void init(CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.e = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            this.e = new SecureRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.b = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.c = this.b.getParameters();
    }

    public BigInteger calculateMessage() {
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(new DHKeyGenerationParameters(this.e, this.c));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        this.d = ((DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getX();
        return ((DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getY();
    }

    public BigInteger calculateAgreement(DHPublicKeyParameters dHPublicKeyParameters, BigInteger bigInteger) {
        if (!dHPublicKeyParameters.getParameters().equals(this.c)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        BigInteger bigInteger2 = this.c.getP();
        BigInteger bigInteger3 = dHPublicKeyParameters.getY();
        if (bigInteger3 == null || bigInteger3.compareTo(a) <= 0 || bigInteger3.compareTo(bigInteger2.subtract(a)) >= 0) {
            throw new IllegalArgumentException("Diffie-Hellman public key is weak");
        }
        BigInteger bigInteger4 = bigInteger3.modPow(this.d, bigInteger2);
        if (bigInteger4.equals(a)) {
            throw new IllegalStateException("Shared key can't be 1");
        }
        return bigInteger.modPow(this.b.getX(), bigInteger2).multiply(bigInteger4).mod(bigInteger2);
    }
}

