/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.BERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERSet;
import com.aspose.psd.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.cms.SignedData;
import com.aspose.psd.internal.bouncycastle.asn1.cms.SignerInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cert.X509AttributeCertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.X509CRLHolder;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.CMSProcessable;
import com.aspose.psd.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.aspose.psd.internal.bouncycastle.cms.CMSTypedData;
import com.aspose.psd.internal.bouncycastle.cms.PKCS7ProcessableObject;
import com.aspose.psd.internal.bouncycastle.cms.SignerInformation;
import com.aspose.psd.internal.bouncycastle.cms.SignerInformationStore;
import com.aspose.psd.internal.bouncycastle.cms.SignerInformationVerifier;
import com.aspose.psd.internal.bouncycastle.cms.SignerInformationVerifierProvider;
import com.aspose.psd.internal.bouncycastle.cms.m;
import com.aspose.psd.internal.bouncycastle.cms.n;
import com.aspose.psd.internal.bouncycastle.cms.o;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.psd.internal.bouncycastle.util.Encodable;
import com.aspose.psd.internal.bouncycastle.util.Store;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CMSSignedData
implements Encodable {
    private static final n a = n.a;
    SignedData signedData;
    ContentInfo contentInfo;
    CMSTypedData signedContent;
    SignerInformationStore signerInfoStore;
    private Map b;

    private CMSSignedData(CMSSignedData cMSSignedData) {
        this.signedData = cMSSignedData.signedData;
        this.contentInfo = cMSSignedData.contentInfo;
        this.signedContent = cMSSignedData.signedContent;
        this.signerInfoStore = cMSSignedData.signerInfoStore;
    }

    public CMSSignedData(byte[] byArray) throws CMSException {
        this(o.a(byArray));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, byte[] byArray) throws CMSException {
        this(cMSProcessable, o.a(byArray));
    }

    public CMSSignedData(Map map, byte[] byArray) throws CMSException {
        this(map, o.a(byArray));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, InputStream inputStream) throws CMSException {
        this(cMSProcessable, o.a((InputStream)new ASN1InputStream(inputStream)));
    }

    public CMSSignedData(InputStream inputStream) throws CMSException {
        this(o.a(inputStream));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, ContentInfo contentInfo) throws CMSException {
        this.signedContent = cMSProcessable instanceof CMSTypedData ? (CMSTypedData)cMSProcessable : new m(this, cMSProcessable);
        this.contentInfo = contentInfo;
        this.signedData = this.a();
    }

    public CMSSignedData(Map map, ContentInfo contentInfo) throws CMSException {
        this.b = map;
        this.contentInfo = contentInfo;
        this.signedData = this.a();
    }

    public CMSSignedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        this.signedData = this.a();
        ASN1Encodable aSN1Encodable = this.signedData.getEncapContentInfo().getContent();
        this.signedContent = aSN1Encodable != null ? (aSN1Encodable instanceof ASN1OctetString ? new CMSProcessableByteArray(this.signedData.getEncapContentInfo().getContentType(), ((ASN1OctetString)aSN1Encodable).getOctets()) : new PKCS7ProcessableObject(this.signedData.getEncapContentInfo().getContentType(), aSN1Encodable)) : null;
    }

    private SignedData a() throws CMSException {
        try {
            return SignedData.getInstance(this.contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public int getVersion() {
        return this.signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set aSN1Set = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            for (int i2 = 0; i2 != aSN1Set.size(); ++i2) {
                SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i2));
                ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signedData.getEncapContentInfo().getContentType();
                if (this.b == null) {
                    arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, this.signedContent, null));
                    continue;
                }
                Object k2 = this.b.keySet().iterator().next();
                byte[] byArray = k2 instanceof String ? (byte[])this.b.get(signerInfo.getDigestAlgorithm().getAlgorithm().getId()) : (byte[])this.b.get(signerInfo.getDigestAlgorithm().getAlgorithm());
                arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, null, byArray));
            }
            this.signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this.signerInfoStore;
    }

    public boolean isDetachedSignature() {
        return this.signedData.getEncapContentInfo().getContent() == null && this.signedData.getSignerInfos().size() > 0;
    }

    public boolean isCertificateManagementMessage() {
        return this.signedData.getEncapContentInfo().getContent() == null && this.signedData.getSignerInfos().size() == 0;
    }

    public Store<X509CertificateHolder> getCertificates() {
        return a.a(this.signedData.getCertificates());
    }

    public Store<X509CRLHolder> getCRLs() {
        return a.c(this.signedData.getCRLs());
    }

    public Store<X509AttributeCertificateHolder> getAttributeCertificates() {
        return a.b(this.signedData.getCertificates());
    }

    public Store getOtherRevocationInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return a.a(aSN1ObjectIdentifier, this.signedData.getCRLs());
    }

    public Set<AlgorithmIdentifier> getDigestAlgorithmIDs() {
        HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>(this.signedData.getDigestAlgorithms().size());
        Enumeration enumeration = this.signedData.getDigestAlgorithms().getObjects();
        while (enumeration.hasMoreElements()) {
            hashSet.add(AlgorithmIdentifier.getInstance(enumeration.nextElement()));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSTypedData getSignedContent() {
        return this.signedContent;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public boolean verifySignatures(SignerInformationVerifierProvider signerInformationVerifierProvider) throws CMSException {
        return this.verifySignatures(signerInformationVerifierProvider, false);
    }

    public boolean verifySignatures(SignerInformationVerifierProvider signerInformationVerifierProvider, boolean bl2) throws CMSException {
        Collection<SignerInformation> collection = this.getSignerInfos().getSigners();
        for (SignerInformation signerInformation : collection) {
            try {
                SignerInformationVerifier signerInformationVerifier = signerInformationVerifierProvider.get(signerInformation.getSID());
                if (!signerInformation.verify(signerInformationVerifier)) {
                    return false;
                }
                if (bl2) continue;
                Collection<SignerInformation> collection2 = signerInformation.getCounterSignatures().getSigners();
                Iterator<SignerInformation> iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    if (this.a(iterator.next(), signerInformationVerifierProvider)) continue;
                    return false;
                }
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("failure in verifier provider: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        }
        return true;
    }

    private boolean a(SignerInformation signerInformation, SignerInformationVerifierProvider signerInformationVerifierProvider) throws OperatorCreationException, CMSException {
        SignerInformationVerifier signerInformationVerifier = signerInformationVerifierProvider.get(signerInformation.getSID());
        if (!signerInformation.verify(signerInformationVerifier)) {
            return false;
        }
        Collection<SignerInformation> collection = signerInformation.getCounterSignatures().getSigners();
        Iterator<SignerInformation> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.a(iterator.next(), signerInformationVerifierProvider)) continue;
            return false;
        }
        return true;
    }

    public static CMSSignedData replaceSigners(CMSSignedData cMSSignedData, SignerInformationStore signerInformationStore) {
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        cMSSignedData2.signerInfoStore = signerInformationStore;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (SignerInformation object2 : signerInformationStore.getSigners()) {
            aSN1EncodableVector.add(n.a.a(object2.getDigestAlgorithmID()));
            aSN1EncodableVector2.add(object2.toASN1Structure());
        }
        DERSet dERSet = new DERSet(aSN1EncodableVector);
        DERSet dERSet2 = new DERSet(aSN1EncodableVector2);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)cMSSignedData.signedData.toASN1Primitive();
        aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(aSN1Sequence.getObjectAt(0));
        aSN1EncodableVector2.add(dERSet);
        for (int i2 = 2; i2 != aSN1Sequence.size() - 1; ++i2) {
            aSN1EncodableVector2.add(aSN1Sequence.getObjectAt(i2));
        }
        aSN1EncodableVector2.add(dERSet2);
        cMSSignedData2.signedData = SignedData.getInstance(new BERSequence(aSN1EncodableVector2));
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), cMSSignedData2.signedData);
        return cMSSignedData2;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData cMSSignedData, Store store, Store store2, Store store3) throws CMSException {
        Iterable iterable;
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        ASN1Set aSN1Set = null;
        Iterable iterable2 = null;
        if (store != null || store2 != null) {
            ASN1Set aSN1Set2;
            iterable = new ArrayList();
            if (store != null) {
                iterable.addAll(o.a(store));
            }
            if (store2 != null) {
                iterable.addAll(o.b(store2));
            }
            if ((aSN1Set2 = o.a(iterable)).size() != 0) {
                aSN1Set = aSN1Set2;
            }
        }
        if (store3 != null && ((ASN1Set)(iterable = o.a(o.c(store3)))).size() != 0) {
            iterable2 = iterable;
        }
        cMSSignedData2.signedData = new SignedData(cMSSignedData.signedData.getDigestAlgorithms(), cMSSignedData.signedData.getEncapContentInfo(), aSN1Set, (ASN1Set)iterable2, cMSSignedData.signedData.getSignerInfos());
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), cMSSignedData2.signedData);
        return cMSSignedData2;
    }
}

