/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.asn1.x509.PolicyInformation;

public class CertificatePolicies
extends ASN1Object {
    private final PolicyInformation[] a;

    public static CertificatePolicies getInstance(Object object) {
        if (object instanceof CertificatePolicies) {
            return (CertificatePolicies)object;
        }
        if (object != null) {
            return new CertificatePolicies(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static CertificatePolicies getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static CertificatePolicies fromExtensions(Extensions extensions) {
        return CertificatePolicies.getInstance(extensions.getExtensionParsedValue(Extension.certificatePolicies));
    }

    public CertificatePolicies(PolicyInformation policyInformation) {
        this.a = new PolicyInformation[]{policyInformation};
    }

    public CertificatePolicies(PolicyInformation[] policyInformationArray) {
        this.a = policyInformationArray;
    }

    private CertificatePolicies(ASN1Sequence aSN1Sequence) {
        this.a = new PolicyInformation[aSN1Sequence.size()];
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            this.a[i2] = PolicyInformation.getInstance(aSN1Sequence.getObjectAt(i2));
        }
    }

    public PolicyInformation[] getPolicyInformation() {
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.a.length];
        System.arraycopy(this.a, 0, policyInformationArray, 0, this.a.length);
        return policyInformationArray;
    }

    public PolicyInformation getPolicyInformation(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            if (!aSN1ObjectIdentifier.equals(this.a[i2].getPolicyIdentifier())) continue;
            return this.a[i2];
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.a[i2]);
        }
        return "CertificatePolicies: [" + stringBuffer + "]";
    }
}

