/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERBitString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AttCertIssuer;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AttCertValidityPeriod;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Holder;

public class AttributeCertificateInfo
extends ASN1Object {
    private ASN1Integer a;
    private Holder b;
    private AttCertIssuer c;
    private AlgorithmIdentifier d;
    private ASN1Integer e;
    private AttCertValidityPeriod f;
    private ASN1Sequence g;
    private DERBitString h;
    private Extensions i;

    public static AttributeCertificateInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return AttributeCertificateInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static AttributeCertificateInfo getInstance(Object object) {
        if (object instanceof AttributeCertificateInfo) {
            return (AttributeCertificateInfo)object;
        }
        if (object != null) {
            return new AttributeCertificateInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private AttributeCertificateInfo(ASN1Sequence aSN1Sequence) {
        int n2;
        if (aSN1Sequence.size() < 6 || aSN1Sequence.size() > 9) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
            n2 = 1;
        } else {
            this.a = new ASN1Integer(0L);
            n2 = 0;
        }
        this.b = Holder.getInstance(aSN1Sequence.getObjectAt(n2));
        this.c = AttCertIssuer.getInstance(aSN1Sequence.getObjectAt(n2 + 1));
        this.d = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n2 + 2));
        this.e = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n2 + 3));
        this.f = AttCertValidityPeriod.getInstance(aSN1Sequence.getObjectAt(n2 + 4));
        this.g = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n2 + 5));
        for (int i2 = n2 + 6; i2 < aSN1Sequence.size(); ++i2) {
            ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(i2);
            if (aSN1Encodable instanceof DERBitString) {
                this.h = DERBitString.getInstance(aSN1Sequence.getObjectAt(i2));
                continue;
            }
            if (!(aSN1Encodable instanceof ASN1Sequence) && !(aSN1Encodable instanceof Extensions)) continue;
            this.i = Extensions.getInstance(aSN1Sequence.getObjectAt(i2));
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public Holder getHolder() {
        return this.b;
    }

    public AttCertIssuer getIssuer() {
        return this.c;
    }

    public AlgorithmIdentifier getSignature() {
        return this.d;
    }

    public ASN1Integer getSerialNumber() {
        return this.e;
    }

    public AttCertValidityPeriod getAttrCertValidityPeriod() {
        return this.f;
    }

    public ASN1Sequence getAttributes() {
        return this.g;
    }

    public DERBitString getIssuerUniqueID() {
        return this.h;
    }

    public Extensions getExtensions() {
        return this.i;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a.getValue().intValue() != 0) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        aSN1EncodableVector.add(this.g);
        if (this.h != null) {
            aSN1EncodableVector.add(this.h);
        }
        if (this.i != null) {
            aSN1EncodableVector.add(this.i);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

