/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.pkcs;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;

public class PrivateKeyInfo
extends ASN1Object {
    private ASN1OctetString a;
    private AlgorithmIdentifier b;
    private ASN1Set c;

    public static PrivateKeyInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return PrivateKeyInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static PrivateKeyInfo getInstance(Object object) {
        if (object instanceof PrivateKeyInfo) {
            return (PrivateKeyInfo)object;
        }
        if (object != null) {
            return new PrivateKeyInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) throws IOException {
        this(algorithmIdentifier, aSN1Encodable, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable, ASN1Set aSN1Set) throws IOException {
        this.a = new DEROctetString(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
        this.b = algorithmIdentifier;
        this.c = aSN1Set;
    }

    public PrivateKeyInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        BigInteger bigInteger = ((ASN1Integer)enumeration.nextElement()).getValue();
        if (bigInteger.intValue() != 0) {
            throw new IllegalArgumentException("wrong version for private key info");
        }
        this.b = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.a = ASN1OctetString.getInstance(enumeration.nextElement());
        if (enumeration.hasMoreElements()) {
            this.c = ASN1Set.getInstance((ASN1TaggedObject)enumeration.nextElement(), false);
        }
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithm() {
        return this.b;
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.b;
    }

    public ASN1Encodable parsePrivateKey() throws IOException {
        return ASN1Primitive.fromByteArray(this.a.getOctets());
    }

    public ASN1Primitive getPrivateKey() {
        try {
            return this.parsePrivateKey().toASN1Primitive();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to parse private key");
        }
    }

    public ASN1Set getAttributes() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(0L));
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.a);
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

