/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.esf;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.psd.internal.bouncycastle.asn1.x500.DirectoryString;
import java.util.Enumeration;

public class SignerLocation
extends ASN1Object {
    private DirectoryString a;
    private DirectoryString b;
    private ASN1Sequence c;

    private SignerLocation(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 1: {
                    this.b = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 2: {
                    this.c = aSN1TaggedObject.isExplicit() ? ASN1Sequence.getInstance(aSN1TaggedObject, true) : ASN1Sequence.getInstance(aSN1TaggedObject, false);
                    if (this.c == null || this.c.size() <= 6) continue block5;
                    throw new IllegalArgumentException("postal address must contain less than 6 strings");
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
    }

    private SignerLocation(DirectoryString directoryString, DirectoryString directoryString2, ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence != null && aSN1Sequence.size() > 6) {
            throw new IllegalArgumentException("postal address must contain less than 6 strings");
        }
        this.a = directoryString;
        this.b = directoryString2;
        this.c = aSN1Sequence;
    }

    public SignerLocation(DirectoryString directoryString, DirectoryString directoryString2, DirectoryString[] directoryStringArray) {
        this(directoryString, directoryString2, (ASN1Sequence)new DERSequence(directoryStringArray));
    }

    public SignerLocation(DERUTF8String dERUTF8String, DERUTF8String dERUTF8String2, ASN1Sequence aSN1Sequence) {
        this(DirectoryString.getInstance(dERUTF8String), DirectoryString.getInstance(dERUTF8String2), aSN1Sequence);
    }

    public static SignerLocation getInstance(Object object) {
        if (object == null || object instanceof SignerLocation) {
            return (SignerLocation)object;
        }
        return new SignerLocation(ASN1Sequence.getInstance(object));
    }

    public DirectoryString getCountry() {
        return this.a;
    }

    public DirectoryString getLocality() {
        return this.b;
    }

    public DirectoryString[] getPostal() {
        if (this.c == null) {
            return null;
        }
        DirectoryString[] directoryStringArray = new DirectoryString[this.c.size()];
        for (int i2 = 0; i2 != directoryStringArray.length; ++i2) {
            directoryStringArray[i2] = DirectoryString.getInstance(this.c.getObjectAt(i2));
        }
        return directoryStringArray;
    }

    public DERUTF8String getCountryName() {
        if (this.a == null) {
            return null;
        }
        return new DERUTF8String(this.getCountry().getString());
    }

    public DERUTF8String getLocalityName() {
        if (this.b == null) {
            return null;
        }
        return new DERUTF8String(this.getLocality().getString());
    }

    public ASN1Sequence getPostalAddress() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

