/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cmc;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.cmc.TaggedRequest;
import com.aspose.psd.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.util.Arrays;

public class EncryptedPOP
extends ASN1Object {
    private final TaggedRequest a;
    private final ContentInfo b;
    private final AlgorithmIdentifier c;
    private final AlgorithmIdentifier d;
    private final byte[] e;

    private EncryptedPOP(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 5) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = TaggedRequest.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ContentInfo.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(2));
        this.d = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(3));
        this.e = Arrays.clone(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(4)).getOctets());
    }

    public EncryptedPOP(TaggedRequest taggedRequest, ContentInfo contentInfo, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) {
        this.a = taggedRequest;
        this.b = contentInfo;
        this.c = algorithmIdentifier;
        this.d = algorithmIdentifier2;
        this.e = Arrays.clone(byArray);
    }

    public static EncryptedPOP getInstance(Object object) {
        if (object instanceof EncryptedPOP) {
            return (EncryptedPOP)object;
        }
        if (object != null) {
            return new EncryptedPOP(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public TaggedRequest getRequest() {
        return this.a;
    }

    public ContentInfo getCms() {
        return this.b;
    }

    public AlgorithmIdentifier getThePOPAlgID() {
        return this.c;
    }

    public AlgorithmIdentifier getWitnessAlgID() {
        return this.d;
    }

    public byte[] getWitness() {
        return Arrays.clone(this.e);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(new DEROctetString(this.e));
        return new DERSequence(aSN1EncodableVector);
    }
}

