/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.bc;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate;

public class EncryptedPrivateKeyData
extends ASN1Object {
    private final EncryptedPrivateKeyInfo a;
    private final Certificate[] b;

    public EncryptedPrivateKeyData(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] certificateArray) {
        this.a = encryptedPrivateKeyInfo;
        this.b = new Certificate[certificateArray.length];
        System.arraycopy(certificateArray, 0, this.b, 0, certificateArray.length);
    }

    private EncryptedPrivateKeyData(ASN1Sequence aSN1Sequence) {
        this.a = EncryptedPrivateKeyInfo.getInstance(aSN1Sequence.getObjectAt(0));
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        this.b = new Certificate[aSN1Sequence2.size()];
        for (int i2 = 0; i2 != this.b.length; ++i2) {
            this.b[i2] = Certificate.getInstance(aSN1Sequence2.getObjectAt(i2));
        }
    }

    public static EncryptedPrivateKeyData getInstance(Object object) {
        if (object instanceof EncryptedPrivateKeyData) {
            return (EncryptedPrivateKeyData)object;
        }
        if (object != null) {
            return new EncryptedPrivateKeyData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Certificate[] getCertificateChain() {
        Certificate[] certificateArray = new Certificate[this.b.length];
        System.arraycopy(this.b, 0, certificateArray, 0, this.b.length);
        return certificateArray;
    }

    public EncryptedPrivateKeyInfo getEncryptedPrivateKeyInfo() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new DERSequence(this.b));
        return new DERSequence(aSN1EncodableVector);
    }
}

