/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.rendering;

import com.aspose.pdf.internal.html.collections.lf;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.css.CSSPrimitiveValue;
import com.aspose.pdf.internal.html.dom.css.CSSValue;
import com.aspose.pdf.internal.html.dom.css.IViewCSS;
import com.aspose.pdf.internal.html.dom.svg.SVGDocument;
import com.aspose.pdf.internal.html.dom.svg.SVGSVGElement;
import com.aspose.pdf.internal.html.drawing.LengthOrAuto;
import com.aspose.pdf.internal.html.drawing.Page;
import com.aspose.pdf.internal.html.drawing.Unit;
import com.aspose.pdf.internal.html.drawing.UnitType;
import com.aspose.pdf.internal.html.lj;
import com.aspose.pdf.internal.html.rendering.IDevice;
import com.aspose.pdf.internal.html.rendering.Renderer;
import com.aspose.pdf.internal.html.rendering.RenderingOptions;
import com.aspose.pdf.internal.l26h.l0f;
import com.aspose.pdf.internal.l26h.l1v;
import com.aspose.pdf.internal.l33p.le;
import com.aspose.pdf.internal.l34f.lI;
import com.aspose.pdf.internal.l35l.lu;
import com.aspose.pdf.internal.l37n.ld;
import com.aspose.pdf.internal.l42f.lt;
import com.aspose.pdf.internal.ms.System.l10j;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.ly;

public class SvgRenderer
extends Renderer<SVGDocument> {
    @Override
    public void render(IDevice device, l10j timeout, SVGDocument[] documents) {
        this.render(device, true, timeout.l0if(), documents);
    }

    @Override
    public void render(IDevice device, l10j timeout, SVGDocument document) {
        SVGDocument[] sVGDocumentArray = new SVGDocument[]{document};
        this.render(device, true, timeout.l0if(), sVGDocumentArray);
    }

    private void render(IDevice device, boolean needFlush, l10j timeout, SVGDocument[] documents) {
        com.aspose.pdf.internal.l38f.lf[] lfArray = new com.aspose.pdf.internal.l38f.lf[documents.length];
        for (int i = 0; i < documents.length; ++i) {
            lfArray[i] = new com.aspose.pdf.internal.l38f.ld(documents[i]);
        }
        this.render(device, needFlush, timeout.l0if(), lfArray);
    }

    @Override
    public void render(IDevice device, SVGSVGElement ... elements) {
        this.render(device, true, elements);
    }

    public void render(IDevice device, boolean needFlush, SVGSVGElement ... elements) {
        com.aspose.pdf.internal.l38f.lf[] lfArray = new com.aspose.pdf.internal.l38f.lf[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            lfArray[i] = new com.aspose.pdf.internal.l38f.ld(elements[i]);
        }
        this.render(device, needFlush, l10j.lj.l0if(), lfArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void render(IDevice device, boolean needFlush, l10j timeout, com.aspose.pdf.internal.l38f.lf ... sources) {
        if (sources.length == 0) {
            return;
        }
        l5f l5f2 = (l5f)((l1v)l0f.lI("Func3<IDevice, RendererBase, IDisposable>")).lI(device, this);
        try {
            this.validatePageSetup(device.getOptions().getPageSetup());
        }
        finally {
            if (l5f2 != null) {
                l5f2.dispose();
            }
        }
        try {
            lf lf2 = new lf(this, sources[0].lI(), ly.lI(sources), device);
            try {
                while (lf2.hasNext()) {
                    SVGSVGElement sVGSVGElement;
                    if (lf2.lf() == null || (sVGSVGElement = ((lt)lf2.lf()).lI()) == null) continue;
                    Document document = sVGSVGElement.getOwnerDocument();
                    com.aspose.pdf.internal.l44t.lI lI2 = document.getContext().getService(com.aspose.pdf.internal.l44t.lI.class);
                    try {
                        RenderingOptions renderingOptions = ld.lI(device.getOptions(), document);
                        com.aspose.pdf.internal.l96y.lI lI3 = new com.aspose.pdf.internal.l96y.lI(document.getBrowsingContext(), renderingOptions);
                        try {
                            Object object;
                            Object object2;
                            document.getBrowsingContext().lh().lI(timeout.l0if());
                            document.getContext().getService(com.aspose.pdf.internal.html.services.lj.class).lI(document);
                            if (renderingOptions.getPageSetup().getAdjustToWidestPage() && (((CSSPrimitiveValue)(object2 = (CSSPrimitiveValue)(object = ((IViewCSS)((Object)document.getContext().getWindow())).getComputedStyle(sVGSVGElement)).getPropertyCSSValue("width"))).getPrimitiveType() & 0xFFFF) != 2) {
                                renderingOptions = this.adjustPageSize(lu.lI((CSSValue)object2, null, null).getValue(UnitType.PT), renderingOptions.deepClone());
                            }
                            object = com.aspose.pdf.internal.l33p.lj.lI(renderingOptions, document);
                            try {
                                object2 = new com.aspose.pdf.internal.l44v.lI((lj)document.getContext());
                                document.getContext().addService(object2, com.aspose.pdf.internal.l44t.lI.class);
                                object2.lI(document);
                                document.getContext().addService(new com.aspose.pdf.internal.l35if.lf(), lI.class);
                                com.aspose.pdf.internal.l33p.ld ld2 = new com.aspose.pdf.internal.l33p.ld((com.aspose.pdf.internal.l33p.lj)object);
                                com.aspose.pdf.internal.l33h.lf lf3 = ld2.lI(sVGSVGElement);
                                le le2 = le.lI(device, document);
                                try {
                                    lf3.lI(le2);
                                }
                                finally {
                                    if (le2 == null) continue;
                                    le2.dispose();
                                }
                            }
                            finally {
                                if (object == null) continue;
                                object.dispose();
                            }
                        }
                        finally {
                            if (lI3 == null) continue;
                            lI3.dispose();
                        }
                    }
                    finally {
                        document.getBrowsingContext().lh().lI();
                        document.getContext().getService(com.aspose.pdf.internal.html.services.lj.class).lI(document);
                        document.getContext().addService(lI2, com.aspose.pdf.internal.l44t.lI.class);
                        document.getContext().addService(null, lI.class);
                    }
                }
                return;
            }
            finally {
                if (lf2 != null) {
                    lf2.dispose();
                }
            }
        }
        finally {
            if (needFlush) {
                device.flush();
            }
        }
    }

    private RenderingOptions adjustPageSize(double svgWidth, RenderingOptions renderingOptions) {
        boolean bl = false;
        if (renderingOptions.getPageSetup().getFirstPage() != null) {
            bl |= this.needsResize(renderingOptions.getPageSetup().getFirstPage(), svgWidth);
        }
        if (renderingOptions.getPageSetup().getAnyPage() == null) {
            bl |= this.needsResize(renderingOptions.getPageSetup().getLeftPage(), svgWidth);
            if (bl |= this.needsResize(renderingOptions.getPageSetup().getRightPage(), svgWidth)) {
                this.updatePageWidth(renderingOptions.getPageSetup().getLeftPage(), svgWidth);
                this.updatePageWidth(renderingOptions.getPageSetup().getRightPage(), svgWidth);
            }
        } else if (bl |= this.needsResize(renderingOptions.getPageSetup().getAnyPage(), svgWidth)) {
            this.updatePageWidth(renderingOptions.getPageSetup().getAnyPage(), svgWidth);
        }
        if (bl && renderingOptions.getPageSetup().getFirstPage() != null) {
            this.updatePageWidth(renderingOptions.getPageSetup().getFirstPage(), svgWidth);
        }
        return renderingOptions;
    }

    private void updatePageWidth(Page page, double widestBlock) {
        page.getSize().setWidth(Unit.fromPoints(widestBlock + this.getMarginWidth(page.getMargin().getLeft()) + this.getMarginWidth(page.getMargin().getRight())));
    }

    private boolean needsResize(Page page, double widestBlock) {
        double d = this.getMarginWidth(page.getMargin().getLeft()) + this.getMarginWidth(page.getMargin().getRight());
        return widestBlock + d > page.getSize().getWidth().getValue(UnitType.PT);
    }

    private double getMarginWidth(LengthOrAuto lengthOrAuto) {
        return lengthOrAuto.isAuto() ? 0.0 : lengthOrAuto.getLength().getValue(UnitType.PT);
    }
}

