/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom.svg.datatypes;

import com.aspose.pdf.internal.html.dom.IBrowsingContext;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.lf;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGValueType;
import com.aspose.pdf.internal.html.lj;
import com.aspose.pdf.internal.l31f.lI;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l6l;
import com.aspose.pdf.internal.ms.System.l8t;
import com.aspose.pdf.internal.ms.System.l9n;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGAngle")
public class SVGAngle
extends SVGValueType {
    @DOMNameAttribute(name="SVG_ANGLETYPE_UNKNOWN")
    public static final int SVG_ANGLETYPE_UNKNOWN = 0;
    @DOMNameAttribute(name="SVG_ANGLETYPE_UNSPECIFIED")
    public static final int SVG_ANGLETYPE_UNSPECIFIED = 1;
    @DOMNameAttribute(name="SVG_ANGLETYPE_DEG")
    public static final int SVG_ANGLETYPE_DEG = 2;
    @DOMNameAttribute(name="SVG_ANGLETYPE_RAD")
    public static final int SVG_ANGLETYPE_RAD = 3;
    @DOMNameAttribute(name="SVG_ANGLETYPE_GRAD")
    public static final int SVG_ANGLETYPE_GRAD = 4;
    private static final String[] Units = new String[]{l10l.lI, l10l.lI, "deg", "rad", "grad"};
    private IBrowsingContext context;
    private float value;
    private int unitType;

    public SVGAngle(lj context) {
        this(context, 0.0f, 1);
    }

    public SVGAngle(IBrowsingContext context, float value, int unitType) {
        this.context = context;
        this.value = value;
        this.unitType = unitType;
    }

    @DOMNameAttribute(name="unitType")
    public int getUnitType() {
        return this.unitType;
    }

    @DOMNameAttribute(name="value")
    public float getValue() {
        return this.value;
    }

    @DOMNameAttribute(name="value")
    public void setValue(float value) {
        if (this.isReadOnly()) {
            throw lI.lk();
        }
        if (!l8t.lI(Float.valueOf(this.value), Float.valueOf(value))) {
            this.value = value;
            this.setField("Value");
        }
    }

    @DOMNameAttribute(name="valueInSpecifiedUnits")
    public float getValueInSpecifiedUnits() {
        return this.value;
    }

    @DOMNameAttribute(name="valueInSpecifiedUnits")
    public void setValueInSpecifiedUnits(float value) {
        if (this.isReadOnly()) {
            throw lI.lk();
        }
        if (!l8t.lI(Float.valueOf(this.value), Float.valueOf(value))) {
            this.value = value;
            this.setField("Value");
        }
    }

    @DOMNameAttribute(name="valueAsString")
    public String getValueAsString() {
        return l10l.lI(new String[]{l9n.lI(this.value, (l6l)lf.lf), Units[this.unitType & 0xFFFF]});
    }

    @DOMNameAttribute(name="valueAsString")
    public void setValueAsString(String value) {
        if (this.isReadOnly()) {
            throw lI.lk();
        }
        SVGAngle sVGAngle = (SVGAngle)this.context.getService(com.aspose.pdf.internal.l34f.lf.class).lI(com.aspose.pdf.internal.l34f.lj.lI(SVGAngle.class)).lI(this.context, value);
        int n = sVGAngle.getUnitType();
        if (!l8t.lI(this.unitType, n)) {
            this.unitType = n;
            this.setField("UnitType");
        }
        float f = sVGAngle.getValue();
        if (!l8t.lI(Float.valueOf(this.value), Float.valueOf(f))) {
            this.value = f;
            this.setField("Value");
        }
    }

    @DOMNameAttribute(name="newValueSpecifiedUnits")
    public void newValueSpecifiedUnits(int newUnitType, float valueInSpecifiedUnits) {
        switch (newUnitType) {
            case 2: {
                this.setValueInSpecifiedUnits(valueInSpecifiedUnits);
                this.value = valueInSpecifiedUnits;
                this.unitType = newUnitType;
                break;
            }
            case 4: {
                this.setValueInSpecifiedUnits(valueInSpecifiedUnits);
                this.value = valueInSpecifiedUnits * 10.0f / 9.0f;
                this.unitType = newUnitType;
                break;
            }
            case 3: {
                this.setValueInSpecifiedUnits(valueInSpecifiedUnits);
                this.unitType = newUnitType;
                break;
            }
            case 1: {
                this.setValueInSpecifiedUnits(valueInSpecifiedUnits);
                this.value = (float)((double)valueInSpecifiedUnits * Math.PI);
                this.unitType = newUnitType;
                break;
            }
            default: {
                throw lI.lc();
            }
        }
    }

    @DOMNameAttribute(name="convertToSpecifiedUnits")
    public void convertToSpecifiedUnits(int unitType) {
    }

    @Override
    public Object deepClone() {
        return new SVGAngle(this.context, this.value, this.unitType);
    }
}

