/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom;

import com.aspose.pdf.internal.html.collections.NamedNodeMap;
import com.aspose.pdf.internal.html.collections.NodeList;
import com.aspose.pdf.internal.html.dom.Attr;
import com.aspose.pdf.internal.html.dom.DOMObject;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.DocumentFragment;
import com.aspose.pdf.internal.html.dom.DocumentType;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.EventTarget;
import com.aspose.pdf.internal.html.dom.ProcessingInstruction;
import com.aspose.pdf.internal.html.dom.Text;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMParameterAttribute;
import com.aspose.pdf.internal.html.dom.l0l;
import com.aspose.pdf.internal.html.dom.mutations.MutationRecord;
import com.aspose.pdf.internal.html.dom.traversal.ITreeWalker;
import com.aspose.pdf.internal.html.dom.xpath.IXPathNSResolver;
import com.aspose.pdf.internal.l26h.l1l;
import com.aspose.pdf.internal.l26h.l2v;
import com.aspose.pdf.internal.l32v.lf;
import com.aspose.pdf.internal.l68if.l0t;
import com.aspose.pdf.internal.l71l.l1j;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lh;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l7n;
import com.aspose.pdf.internal.ms.System.l8t;
import com.aspose.pdf.internal.ms.System.ly;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@DOMObjectAttribute
@DOMNameAttribute(name="Node")
public abstract class Node
extends EventTarget
implements IXPathNSResolver {
    @DOMNameAttribute(name="ELEMENT_NODE")
    public static final int ELEMENT_NODE = 1;
    @DOMNameAttribute(name="ATTRIBUTE_NODE")
    public static final int ATTRIBUTE_NODE = 2;
    @DOMNameAttribute(name="TEXT_NODE")
    public static final int TEXT_NODE = 3;
    @DOMNameAttribute(name="CDATA_SECTION_NODE")
    public static final int CDATA_SECTION_NODE = 4;
    @DOMNameAttribute(name="ENTITY_REFERENCE_NODE")
    public static final int ENTITY_REFERENCE_NODE = 5;
    @DOMNameAttribute(name="ENTITY_NODE")
    public static final int ENTITY_NODE = 6;
    @DOMNameAttribute(name="PROCESSING_INSTRUCTION_NODE")
    public static final int PROCESSING_INSTRUCTION_NODE = 7;
    @DOMNameAttribute(name="COMMENT_NODE")
    public static final int COMMENT_NODE = 8;
    @DOMNameAttribute(name="DOCUMENT_NODE")
    public static final int DOCUMENT_NODE = 9;
    @DOMNameAttribute(name="DOCUMENT_TYPE_NODE")
    public static final int DOCUMENT_TYPE_NODE = 10;
    @DOMNameAttribute(name="DOCUMENT_FRAGMENT_NODE")
    public static final int DOCUMENT_FRAGMENT_NODE = 11;
    @DOMNameAttribute(name="NOTATION_NODE")
    public static final int NOTATION_NODE = 12;
    @DOMNameAttribute(name="DOCUMENT_POSITION_DISCONNECTED")
    private static final int DOCUMENT_POSITION_DISCONNECTED = 1;
    @DOMNameAttribute(name="DOCUMENT_POSITION_PRECEDING")
    private static final int DOCUMENT_POSITION_PRECEDING = 2;
    @DOMNameAttribute(name="DOCUMENT_POSITION_FOLLOWING")
    private static final int DOCUMENT_POSITION_FOLLOWING = 4;
    @DOMNameAttribute(name="DOCUMENT_POSITION_CONTAINS")
    private static final int DOCUMENT_POSITION_CONTAINS = 8;
    @DOMNameAttribute(name="DOCUMENT_POSITION_CONTAINED_BY")
    private static final int DOCUMENT_POSITION_CONTAINED_BY = 16;
    @DOMNameAttribute(name="DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC")
    private static final int DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    public lf flags = new lf();
    public Document nodeDocument;
    protected Node parent;
    private lI children;
    private Node first;
    private Node last;
    private Node previous;
    private Node next;
    private com.aspose.pdf.internal.l32v.lf auto_RegisteredObservers;
    private String auto_LocalName;
    private String auto_NamespaceURI;
    private String auto_Prefix;

    protected Node(Document document) {
        Document document2 = document;
        if (document2 == null) {
            document2 = com.aspose.pdf.internal.l35j.lf.lI(Document.class, this) ? (Document)this : null;
        }
        this.nodeDocument = document2;
        com.aspose.pdf.internal.l96u.lI.lI(this.nodeDocument != null, "Unknown type of node.");
        this.children = new lI(this);
        this.setRegisteredObservers(new com.aspose.pdf.internal.l32v.lf());
    }

    public static void adoptNode(Node node, Document document) {
        Document document2 = node.nodeDocument;
        if (node.parent != null) {
            Node.remove(node, node.parent, false);
        }
        if (document != document2) {
            Node.adoptDescendantNode(node, document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void adoptDescendantNode(Node node, Document document) {
        node.nodeDocument = document;
        if (node.getNodeType() == 1) {
            l0t l0t2 = ((Element)node).getAttributes().iterator();
            try {
                while (l0t2.hasNext()) {
                    Attr attr = (Attr)l0t2.next();
                    attr.nodeDocument = document;
                }
            }
            finally {
                if (lb.lf((Object)l0t2, l5f.class)) {
                    ((l5f)((Object)l0t2)).dispose();
                }
            }
        }
        com.aspose.pdf.internal.html.lj.lI().lI(node, document);
        node = node.first;
        while (node != null) {
            Node.adoptDescendantNode(node, document);
            node = node.next;
        }
    }

    private static boolean isEqualNode(Node a, Node b) {
        DOMObject dOMObject;
        DOMObject dOMObject2;
        if (l8t.lf(a, b)) {
            return true;
        }
        if (l8t.lf(a, null) || l8t.lf(b, null)) {
            return false;
        }
        if ((a.getNodeType() & 0xFFFF) != (b.getNodeType() & 0xFFFF)) {
            return false;
        }
        switch (a.getNodeType()) {
            case 10: {
                dOMObject2 = (DocumentType)a;
                dOMObject = (DocumentType)b;
                if (l10l.lb(((DocumentType)dOMObject2).getName(), ((DocumentType)dOMObject).getName()) && l10l.lb(((DocumentType)dOMObject2).getPublicId(), ((DocumentType)dOMObject).getPublicId()) && l10l.lb(((DocumentType)dOMObject2).getSystemId(), ((DocumentType)dOMObject).getSystemId())) break;
                return false;
            }
            case 1: {
                dOMObject2 = (Element)a;
                dOMObject = (Element)b;
                if (l10l.lb(((Element)dOMObject2).getNamespaceURI(), ((Element)dOMObject).getNamespaceURI()) && l10l.lb(((Element)dOMObject2).getPrefix(), ((Element)dOMObject).getPrefix()) && l10l.lb(((Element)dOMObject2).getLocalName(), ((Element)dOMObject).getLocalName()) && ((Element)dOMObject2).getAttributes().getLength() == ((Element)dOMObject).getAttributes().getLength()) break;
                return false;
            }
            case 2: {
                dOMObject2 = (Attr)a;
                dOMObject = (Attr)b;
                if (l10l.lb(((Attr)dOMObject2).getNamespaceURI(), ((Attr)dOMObject).getNamespaceURI()) && l10l.lb(((Attr)dOMObject2).getLocalName(), ((Attr)dOMObject).getLocalName()) && l10l.lb(((Attr)dOMObject2).getValue(), ((Attr)dOMObject).getValue())) break;
                return false;
            }
            case 7: {
                dOMObject2 = (ProcessingInstruction)a;
                dOMObject = (ProcessingInstruction)b;
                if (l10l.lb(((ProcessingInstruction)dOMObject2).getTarget(), ((ProcessingInstruction)dOMObject).getTarget()) && l10l.lb(((com.aspose.pdf.internal.html.dom.lI)dOMObject2).getData(), ((com.aspose.pdf.internal.html.dom.lI)dOMObject).getData())) break;
                return false;
            }
            case 3: 
            case 8: {
                if (l10l.lb(((com.aspose.pdf.internal.html.dom.lI)a).getData(), ((com.aspose.pdf.internal.html.dom.lI)b).getData())) break;
                return false;
            }
        }
        if (a.getNodeType() == 1) {
            dOMObject2 = ((Element)a).getAttributes();
            dOMObject = ((Element)b).getAttributes();
            for (int i = 0; i < ((NamedNodeMap)dOMObject2).getLength(); ++i) {
                if (Node.isEqualNode(((NamedNodeMap)dOMObject2).get_Item(i), ((NamedNodeMap)dOMObject).get_Item(i))) continue;
                return false;
            }
        }
        dOMObject2 = a.first;
        dOMObject = b.first;
        while (dOMObject2 != null) {
            if (!Node.isEqualNode((Node)dOMObject2, (Node)dOMObject)) {
                return false;
            }
            dOMObject2 = ((Node)dOMObject2).next;
            dOMObject = ((Node)dOMObject).next;
        }
        return dOMObject == null;
    }

    private static void ensurePreInsertionValidity(Node node, Node parent, Node child) {
        if ((parent.getNodeType() & 0xFFFF) != 9 && (parent.getNodeType() & 0xFFFF) != 11 && (parent.getNodeType() & 0xFFFF) != 1) {
            throw com.aspose.pdf.internal.l31f.lI.lu();
        }
        if (Node.containsIncludingHostElements(node, parent)) {
            throw com.aspose.pdf.internal.l31f.lI.lu();
        }
        if (child != null && child.parent != parent) {
            throw com.aspose.pdf.internal.l31f.lI.lv();
        }
        if ((node.getNodeType() & 0xFFFF) != 11 && (node.getNodeType() & 0xFFFF) != 10 && (node.getNodeType() & 0xFFFF) != 1 && (node.getNodeType() & 0xFFFF) != 3 && (node.getNodeType() & 0xFFFF) != 7 && (node.getNodeType() & 0xFFFF) != 8) {
            throw com.aspose.pdf.internal.l31f.lI.lu();
        }
        if (node.getNodeType() == 3 && parent.getNodeType() == 9 || node.getNodeType() == 10 && (parent.getNodeType() & 0xFFFF) != 9) {
            throw com.aspose.pdf.internal.l31f.lI.lu();
        }
        if (parent.getNodeType() == 9) {
            if (node.getNodeType() == 11) {
                if (node.hasMultipleChildrenOfType(1) || node.hasChildOfType(3)) {
                    throw com.aspose.pdf.internal.l31f.lI.lu();
                }
                if (node.hasChildOfType(1) && (parent.hasChildOfType(1) || com.aspose.pdf.internal.l35j.lf.lI(child, 10) || child != null && com.aspose.pdf.internal.l35j.lf.lI(child.next, 10))) {
                    throw com.aspose.pdf.internal.l31f.lI.lu();
                }
            } else if (node.getNodeType() == 1 ? parent.hasChildOfType(1) || com.aspose.pdf.internal.l35j.lf.lI(child, 10) || child != null && com.aspose.pdf.internal.l35j.lf.lI(child.next, 10) : node.getNodeType() == 10 && (parent.hasChildOfType(10) || child != null && com.aspose.pdf.internal.l35j.lf.lI(child.previous, 1) || child == null && parent.hasChildOfType(1))) {
                throw com.aspose.pdf.internal.l31f.lI.lu();
            }
        }
    }

    private static Node preInsert(Node node, Node parent, Node child) {
        Node.ensurePreInsertionValidity(node, parent, child);
        Node node2 = child;
        if (node2 == node) {
            node.next = node2;
        }
        parent.nodeDocument.adoptNode(node);
        Node.insert(node, parent, node2, false);
        return node;
    }

    private static void insert(Node node, Node parent, Node child, boolean suppressObservers) {
        Node[] nodeArray;
        int n;
        int n2 = n = node.getNodeType() == 11 ? node.children.getLength() : 1;
        if (child != null) {
            // empty if block
        }
        if (node.getNodeType() == 11) {
            nodeArray = ((DocumentFragment)node).getChildNodes().toArray();
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        Node[] nodeArray3 = nodeArray;
        if (node.getNodeType() == 11) {
            for (Node node2 : nodeArray3) {
                Node.remove(node2, node, true);
            }
            ((com.aspose.pdf.internal.html.lj)node.nodeDocument.getContext()).lI(node, MutationRecord.EMPTY_NODES, ly.lI(nodeArray3), null, null);
        }
        Node node3 = child == null ? parent.last : child.previous;
        for (Node node4 : nodeArray3) {
            if (child == null) {
                parent.children.lI(node4);
            } else {
                parent.children.lI(node4, child);
            }
            if (node.getNodeType() == 3) {
                com.aspose.pdf.internal.html.lj.lI().lf(parent);
            }
            com.aspose.pdf.internal.html.lj.lI().lI(node4);
        }
        if (!suppressObservers) {
            ((com.aspose.pdf.internal.html.lj)node.nodeDocument.getContext()).lI(parent, ly.lI(nodeArray3), MutationRecord.EMPTY_NODES, node3, child);
        }
        node.flags.lj(lf.le);
    }

    private static Node replace(Node child, Node node, Node parent) {
        Node[] nodeArray;
        Node node2;
        if ((parent.getNodeType() & 0xFFFF) != 9 && (parent.getNodeType() & 0xFFFF) != 11 && (parent.getNodeType() & 0xFFFF) != 1) {
            throw com.aspose.pdf.internal.l31f.lI.lu();
        }
        if (Node.containsIncludingHostElements(node, parent)) {
            throw com.aspose.pdf.internal.l31f.lI.lu();
        }
        if (child.parent != parent) {
            throw com.aspose.pdf.internal.l31f.lI.lv();
        }
        if ((node.getNodeType() & 0xFFFF) != 11 && (node.getNodeType() & 0xFFFF) != 10 && (node.getNodeType() & 0xFFFF) != 1 && (node.getNodeType() & 0xFFFF) != 3 && (node.getNodeType() & 0xFFFF) != 7 && (node.getNodeType() & 0xFFFF) != 8) {
            throw com.aspose.pdf.internal.l31f.lI.lu();
        }
        if (node.getNodeType() == 3 && parent.getNodeType() == 9 || node.getNodeType() == 10 && (parent.getNodeType() & 0xFFFF) != 9) {
            throw com.aspose.pdf.internal.l31f.lI.lu();
        }
        if (parent.getNodeType() == 9) {
            if (node.getNodeType() == 11) {
                if (node.hasMultipleChildrenOfType(1) || node.hasChildOfType(3)) {
                    throw com.aspose.pdf.internal.l31f.lI.lu();
                }
                if (node.hasChildOfType(1) && (parent.hasChildOfType(1) && parent.getChildOfType(1) != child || com.aspose.pdf.internal.l35j.lf.lI(child.next, 10))) {
                    throw com.aspose.pdf.internal.l31f.lI.lu();
                }
            } else if (node.getNodeType() == 1 ? parent.hasChildOfType(1) && parent.getChildOfType(1) != child || com.aspose.pdf.internal.l35j.lf.lI(child.next, 10) : node.getNodeType() == 10 && (parent.hasChildOfType(10) && parent.getChildOfType(10) != child || com.aspose.pdf.internal.l35j.lf.lI(child.previous, 1))) {
                throw com.aspose.pdf.internal.l31f.lI.lu();
            }
        }
        if ((node2 = child.next) == node) {
            node.next = node2;
        }
        Node node3 = child.previous;
        parent.nodeDocument.adoptNode(node);
        IGenericList<Node> iGenericList = MutationRecord.EMPTY_NODES;
        if (child.parent != null) {
            iGenericList = ly.lI(new Node[]{child});
            Node.remove(child, parent, true);
        }
        if (node.getNodeType() == 11) {
            nodeArray = ((DocumentFragment)node).getChildNodes().toArray();
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        Node[] nodeArray3 = nodeArray;
        Node.insert(node, parent, node2, true);
        ((com.aspose.pdf.internal.html.lj)node.nodeDocument.getContext()).lI(parent, ly.lI(nodeArray3), iGenericList, node3, node2);
        return child;
    }

    private static Node preRemove(Node child, Node parent) {
        if (child == null || child.parent != parent) {
            throw com.aspose.pdf.internal.l31f.lI.lv();
        }
        Node.remove(child, parent, false);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void remove(Node node, Node parent, boolean suppressObserversFlag) {
        parent.nodeDocument.getIterators().lI(node);
        Node node2 = node.previous;
        Node node3 = node.next;
        parent.children.lf(node);
        com.aspose.pdf.internal.html.lj.lI().lI(node, parent);
        lk<Node> lk2 = lj.lI(node).iterator();
        try {
            while (lk2.hasNext()) {
                Object object;
                Node node4 = (Node)lk2.next();
                com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Object> l0t2 = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Object>();
                l0t l0t3 = node4.getRegisteredObservers().iterator();
                try {
                    while (l0t3.hasNext()) {
                        object = (lf.lI)l0t3.next();
                        if (!((lf.lI)object).lt.getSubtree()) continue;
                        l0t2.addItem(object);
                    }
                }
                finally {
                    if (lb.lf((Object)l0t3, l5f.class)) {
                        ((l5f)((Object)l0t3)).dispose();
                    }
                }
                object = l0t2.iterator();
                try {
                    while (object.hasNext()) {
                        lf.lI lI2 = (lf.lI)object.next();
                        node4.getRegisteredObservers().lI(lI2.lj, lI2.lt.Clone(), lI2);
                    }
                }
                finally {
                    if (!lb.lf(object, l5f.class)) continue;
                    ((l5f)object).dispose();
                }
            }
        }
        finally {
            if (lb.lf(lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
        if (!suppressObserversFlag) {
            ((com.aspose.pdf.internal.html.lj)parent.nodeDocument.getContext()).lI(parent, MutationRecord.EMPTY_NODES, ly.lI(new Node[]{node}), node2, node3);
        }
        if (node.getNodeType() == 3) {
            com.aspose.pdf.internal.html.lj.lI().lf(parent);
        }
        node.flags.lt(lf.le);
    }

    public static void replaceAll(Node node, Node parent) {
        IGenericList<Node> iGenericList;
        IGenericList<Node> iGenericList2;
        if (node != null) {
            parent.nodeDocument.adoptNode(node);
        }
        Node[] nodeArray = parent.children.toArray();
        if (node == null) {
            iGenericList2 = MutationRecord.EMPTY_NODES;
        } else {
            Node[] nodeArray2;
            if (node.getNodeType() == 11) {
                nodeArray2 = node.children.toArray();
            } else {
                Node[] nodeArray3 = new Node[1];
                nodeArray2 = nodeArray3;
                nodeArray3[0] = node;
            }
            iGenericList2 = iGenericList = ly.lI(nodeArray2);
        }
        while (parent.first != null) {
            Node.remove(parent.first, parent, true);
        }
        if (node != null) {
            Node.insert(node, parent, null, true);
        }
        ((com.aspose.pdf.internal.html.lj)parent.nodeDocument.getContext()).lI(parent, iGenericList, ly.lI(nodeArray), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsIncludingHostElements(Node parent, Node node) {
        lk<Node> lk2 = lj.lI(node).iterator();
        try {
            while (lk2.hasNext()) {
                Node node2 = (Node)lk2.next();
                if (node2 != parent) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (lb.lf(lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node deepClone(Node node, Document document, boolean cloneChildren) {
        Iterator iterator;
        if (document == null) {
            document = node.nodeDocument;
        }
        Node node2 = null;
        if (node.getNodeType() == 1) {
            node2 = node.nodeDocument.createElementNS(((Element)node).getNamespaceURI(), node.getNodeName());
            iterator = ((Element)node).getAttributes().iterator();
            try {
                while (iterator.hasNext()) {
                    Node node3 = (Attr)iterator.next();
                    Attr attr = (Attr)Node.deepClone(node3, document, cloneChildren);
                    NamedNodeMap.append(attr, (Element)node2);
                }
            }
            finally {
                if (lb.lf((Object)iterator, l5f.class)) {
                    ((l5f)((Object)iterator)).dispose();
                }
            }
        }
        switch (node.getNodeType()) {
            case 9: {
                iterator = (Document)node;
                node2 = ((Document)((Object)iterator)).getImplementation().createDocument(((Document)((Object)iterator)).getDocumentElement().getNamespaceURI(), null, null);
                break;
            }
            case 10: {
                iterator = (DocumentType)node;
                node2 = node.nodeDocument.createDocumentType(((DocumentType)((Object)iterator)).getName(), ((DocumentType)((Object)iterator)).getPublicId(), ((DocumentType)((Object)iterator)).getSystemId(), ((DocumentType)((Object)iterator)).getInternalSubset());
                break;
            }
            case 11: {
                node2 = node.nodeDocument.createDocumentFragment();
                break;
            }
            case 2: {
                iterator = (Attr)node;
                node2 = node.nodeDocument.createAttributeNS(((Attr)((Object)iterator)).getNamespaceURI(), ((Attr)((Object)iterator)).getNodeName());
                ((Attr)node2).setValue(((Attr)((Object)iterator)).getValue());
                break;
            }
            case 3: {
                node2 = node.nodeDocument.createTextNode(((com.aspose.pdf.internal.html.dom.lI)node).getData());
                break;
            }
            case 8: {
                node2 = node.nodeDocument.createComment(((com.aspose.pdf.internal.html.dom.lI)node).getData());
                break;
            }
            case 7: {
                iterator = (ProcessingInstruction)node;
                node2 = node.nodeDocument.createProcessingInstruction(((ProcessingInstruction)((Object)iterator)).getTarget(), ((com.aspose.pdf.internal.html.dom.lI)((Object)iterator)).getData());
                break;
            }
        }
        if (com.aspose.pdf.internal.l35j.lf.lI(node2, 9)) {
            iterator = (Document)node2;
            document = iterator;
            node2.nodeDocument = iterator;
        } else {
            node2.nodeDocument = document;
        }
        com.aspose.pdf.internal.html.lj.lI().lI(node2, node, (Document)document, cloneChildren);
        if (cloneChildren) {
            for (Node node3 : node.children) {
                node2.children.lI(Node.deepClone(node3, document, cloneChildren));
            }
        }
        return node2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public com.aspose.pdf.internal.l32v.lf getRegisteredObservers() {
        return this.auto_RegisteredObservers;
    }

    private void setRegisteredObservers(com.aspose.pdf.internal.l32v.lf value) {
        this.auto_RegisteredObservers = value;
    }

    @DOMNameAttribute(name="nodeType")
    public abstract int getNodeType();

    @DOMNameAttribute(name="localName")
    public String getLocalName() {
        return this.auto_LocalName;
    }

    @DOMNameAttribute(name="localName")
    protected void setLocalName(String value) {
        this.auto_LocalName = value;
    }

    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    public String getNamespaceURI() {
        return this.auto_NamespaceURI;
    }

    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    protected void setNamespaceURI(String value) {
        this.auto_NamespaceURI = value;
    }

    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public String getPrefix() {
        return this.auto_Prefix;
    }

    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public void setPrefix(String value) {
        this.auto_Prefix = value;
    }

    @DOMNameAttribute(name="nodeName")
    public abstract String getNodeName();

    @DOMNameAttribute(name="baseURI")
    public String getBaseURI() {
        if (this.nodeDocument == null) {
            return null;
        }
        return this.nodeDocument.getBaseURI();
    }

    @DOMNameAttribute(name="ownerDocument")
    @DOMNullableAttribute
    public Document getOwnerDocument() {
        return this.nodeDocument;
    }

    @DOMNameAttribute(name="parentNode")
    @DOMNullableAttribute
    public Node getParentNode() {
        return this.parent;
    }

    public void setParentNode(Node parent) {
        this.parent = parent;
    }

    @DOMNameAttribute(name="parentElement")
    @DOMNullableAttribute
    public Element getParentElement() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getNodeType() == 1) {
            return (Element)((Object)lb.lI(this.parent, Element.class));
        }
        return null;
    }

    @DOMNameAttribute(name="hasChildNodes")
    public boolean hasChildNodes() {
        return this.first != null;
    }

    @DOMNameAttribute(name="childNodes")
    public NodeList getChildNodes() {
        return this.children;
    }

    @DOMNameAttribute(name="firstChild")
    public Node getFirstChild() {
        return this.first;
    }

    @DOMNameAttribute(name="lastChild")
    public Node getLastChild() {
        return this.last;
    }

    @DOMNameAttribute(name="previousSibling")
    public Node getPreviousSibling() {
        return this.previous;
    }

    @DOMNameAttribute(name="nextSibling")
    public Node getNextSibling() {
        return this.next;
    }

    @DOMNameAttribute(name="attributes")
    public NamedNodeMap getAttributes() {
        return null;
    }

    @DOMNameAttribute(name="hasAttributes")
    public boolean hasAttributes() {
        return false;
    }

    @DOMNameAttribute(name="nodeValue")
    public String getNodeValue() {
        return null;
    }

    @DOMNameAttribute(name="nodeValue")
    public void setNodeValue(String value) {
    }

    @DOMNameAttribute(name="textContent")
    public String getTextContent() {
        return null;
    }

    @DOMNameAttribute(name="textContent")
    public void setTextContent(String value) {
    }

    @DOMNameAttribute(name="normalize")
    public void normalize() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 4L, null);
        while (iTreeWalker.nextNode() != null) {
            Text text = (Text)iTreeWalker.getCurrentNode();
            int n = text.getLength();
            if (n == 0) {
                text.parent.removeChild(text);
                continue;
            }
            l1j l1j2 = new l1j();
            Node node = text.getNextSibling();
            while (node != null && node.getNodeType() == 3) {
                Text text2 = (Text)node;
                l1j2.lI(text2.getData());
                n += text2.getLength();
                text.parent.removeChild(node);
                node = text.getNextSibling();
            }
            text.replaceData(text.getLength(), 0, l1j2.toString());
        }
    }

    @DOMNameAttribute(name="cloneNode")
    public Node cloneNode(@DOMParameterAttribute(name="deep", optional=true) boolean deep) {
        return Node.deepClone(this, null, deep);
    }

    @DOMNameAttribute(name="isEqualNode")
    public boolean isEqualNode(@DOMNullableAttribute Node otherNode) {
        return Node.isEqualNode(this, otherNode);
    }

    @DOMNameAttribute(name="isSameNode")
    public boolean isSameNode(Node otherNode) {
        return l8t.lf(this, otherNode);
    }

    @DOMNameAttribute(name="compareDocumentPosition")
    private short compareDocumentPosition(Node other) {
        throw new l7n();
    }

    @DOMNameAttribute(name="lookupPrefix")
    public String lookupPrefix(@DOMNullableAttribute String namespaceURI) {
        return l0l.lf(this, namespaceURI);
    }

    @Override
    @DOMNameAttribute(name="lookupNamespaceURI")
    public String lookupNamespaceURI(@DOMNullableAttribute String prefix) {
        return l0l.lI(this, prefix);
    }

    @DOMNameAttribute(name="isDefaultNamespace")
    public boolean isDefaultNamespace(@DOMNullableAttribute String namespaceURI) {
        return l0l.lj(this, namespaceURI);
    }

    @DOMNameAttribute(name="insertBefore")
    public Node insertBefore(Node node, @DOMNullableAttribute Node child) {
        return Node.preInsert(node, this, child);
    }

    @DOMNameAttribute(name="replaceChild")
    public Node replaceChild(Node node, @DOMNullableAttribute Node child) {
        return Node.replace(child, node, this);
    }

    @DOMNameAttribute(name="removeChild")
    public Node removeChild(Node child) {
        return Node.preRemove(child, this);
    }

    @DOMNameAttribute(name="appendChild")
    public Node appendChild(Node node) {
        Node.preInsert(node, this, null);
        return node;
    }

    @Override
    protected void dispose(boolean disposing) {
        Node node = this.first;
        while (node != null) {
            node.dispose();
            node = node.next;
        }
        super.dispose(disposing);
    }

    private boolean hasChildOfType(int type) {
        Node node = this.first;
        while (node != null) {
            if (node.getNodeType() == type) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    private Node getChildOfType(int type) {
        Node node = this.first;
        while (node != null) {
            if (node.getNodeType() == type) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    private boolean hasMultipleChildrenOfType(int type) {
        boolean bl = false;
        Node node = this.first;
        while (node != null) {
            if (node.getNodeType() == type) {
                if (bl) {
                    return true;
                }
                bl = true;
            }
            node = node.next;
        }
        return false;
    }

    public String toString() {
        return l10l.lI("{0}, Value=\"{1}\"", new Object[]{this.getNodeName(), this.getNodeValue()});
    }

    public static class lf
    extends l2v {
        public static final int lI;
        public static final int lf;
        public static final int lj;
        public static final int lt;
        public static final int lb;
        public static final int ld;
        public static final int lu;
        public static final int le;
        public static final int lh;
        public static final int lk;
        public static final int lv;
        public static final int lc;
        public static final int ly;
        public static final int l0if;
        public static final int l0l;
        public static final int l0t;
        public static final int l0v;
        private static AtomicReference<l2v.lI> l0p;
        private AtomicInteger l0u = new AtomicInteger();

        protected lf(l2v.lI lI2) {
            super(lI2);
        }

        public lf() {
            super(l0p.get());
        }

        public void lb(int n) {
            if (n == l0l) {
                this.l0u.incrementAndGet();
            }
            this.lj(n);
        }

        public void ld(int n) {
            if (n == l0l && this.l0u.decrementAndGet() == 0) {
                this.lt(n);
            }
        }

        static {
            l0p = new AtomicReference<Object>(null);
            l2v.lI lI2 = new l2v.lI();
            lI = lI2.lI("NODE_FIRST_CHILD");
            lf = lI2.lI("NODE_READ_ONLY");
            lt = lI2.lI("DETACHED");
            lj = lI2.lI("SUPPRESS_OBSERVERS");
            lb = lI2.lI("OBSERVER_SUPPRESSED");
            le = lI2.lI("CONNECTED");
            ld = lI2.lI("DIRTY_VALUE_FLAG");
            lu = lI2.lI("DIRTY_CHECKEDNESS_FLAG");
            lh = lI2.lI("NODE_IS_SHAPE");
            lk = lI2.lI("NODE_IS_TEXT_CONTENT");
            lv = lI2.lI("NODE_IS_CONTAINER");
            lc = lI2.lI("NODE_IS_GRAPHICS");
            ly = lI2.lI("NODE_IS_DESCRIPTIVE_ELEMENT");
            l0if = lI2.lI("NODE_NEVER_RENDERED");
            l0l = lI2.lI("DELAYS_THE_LOAD_EVENT");
            l0t = lI2.lI("READY_FOR_POST_LOAD_TASKS");
            l0v = lI2.lI("COMPLETELY_LOADED");
            l0p.set(lI2);
        }
    }

    private static class lj
    implements lh<Node> {
        private l1l<lk<Node>> lI;

        private lj(l1l<lk<Node>> l1l2) {
            this.lI = l1l2;
        }

        public static lh<Node> lI(final Node node) {
            return new lj(new l1l<lk<Node>>(){

                public lk<Node> lI() {
                    return new lI(node);
                }

                @Override
                public /* synthetic */ Object invoke() {
                    return this.lI();
                }
            });
        }

        @Override
        public lk<Node> iterator() {
            return this.lI.invoke();
        }

        private static class lI
        implements lk<Node> {
            private final Node lI;
            private Node lf;

            public lI(Node node) {
                this.lI = node;
            }

            @Override
            public void dispose() {
            }

            @Override
            public boolean hasNext() {
                if (this.lf == null) {
                    this.lf = this.lI;
                    return true;
                }
                if (this.lf.parent != null) {
                    this.lf = this.lf.parent;
                    return true;
                }
                return false;
            }

            @Override
            public void lI() {
                this.lf = null;
            }

            public Node lf() {
                return this.lf;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.lf();
            }
        }
    }

    private static class com.aspose.pdf.internal.html.dom.Node$lI
    extends NodeList {
        private final Node lI;

        public com.aspose.pdf.internal.html.dom.Node$lI(Node node) {
            this.lI = node;
        }

        public void lI(Node node) {
            if (this.lI.first == null) {
                this.lI.first = node;
                this.lI.last = node;
            } else {
                Node node2 = this.lI.last;
                node2.next = node;
                node.previous = node2;
                this.lI.last = node;
            }
            node.parent = this.lI;
        }

        public void lI(Node node, Node node2) {
            Node node3 = node2.previous;
            node.previous = node3;
            node.next = node2;
            if (node3 != null) {
                node3.next = node;
            } else {
                this.lI.first = node;
            }
            node2.previous = node;
            node.parent = this.lI;
        }

        public void lf(Node node) {
            if (this.lI.first == node) {
                this.lI.first = node.next;
            }
            if (this.lI.last == node) {
                this.lI.last = node.previous;
            }
            if (node.previous != null) {
                node.previous.next = node.next;
            }
            if (node.next != null) {
                node.next.previous = node.previous;
            }
            node.next = null;
            node.previous = null;
            node.parent = null;
        }

        @Override
        public Node get_Item(int index) {
            if (index < 0) {
                return null;
            }
            Node node = this.lI.first;
            while (node != null) {
                if (index == 0) {
                    return node;
                }
                --index;
                node = node.next;
            }
            return null;
        }

        @Override
        public int getLength() {
            int n = 0;
            Node node = this.lI.first;
            while (node != null) {
                ++n;
                node = node.next;
            }
            return n;
        }

        @Override
        public lk<Node> iterator() {
            return new lI(this.lI);
        }

        private static class lI
        implements lk<Node> {
            private Node lI;
            private Node lf;

            public lI(Node node) {
                this.lI = node;
            }

            @Override
            public void dispose() {
                this.lI = null;
            }

            @Override
            public boolean hasNext() {
                if (this.lf == null) {
                    this.lf = this.lI.first;
                    return this.lf != null;
                }
                if (this.lf.next == null) {
                    return false;
                }
                this.lf = this.lf.next;
                return true;
            }

            @Override
            public void lI() {
                this.lf = null;
            }

            public Node lf() {
                return this.lf;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.lf();
            }
        }
    }
}

