/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom;

import com.aspose.pdf.internal.html.collections.HTMLCollection;
import com.aspose.pdf.internal.html.collections.NamedNodeMap;
import com.aspose.pdf.internal.html.collections.NodeList;
import com.aspose.pdf.internal.html.dom.Attr;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.IChildNode;
import com.aspose.pdf.internal.html.dom.IParentNode;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.ShadowRoot;
import com.aspose.pdf.internal.html.dom.Text;
import com.aspose.pdf.internal.html.dom.TypeInfo;
import com.aspose.pdf.internal.html.dom.attributes.DOMInitDictParameterAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.le;
import com.aspose.pdf.internal.html.dom.lf;
import com.aspose.pdf.internal.html.dom.traversal.ITreeWalker;
import com.aspose.pdf.internal.html.dom.traversal.filters.lI;
import com.aspose.pdf.internal.html.dom.traversal.filters.lb;
import com.aspose.pdf.internal.html.dom.traversal.filters.ld;
import com.aspose.pdf.internal.html.dom.traversal.filters.lt;
import com.aspose.pdf.internal.html.lc;
import com.aspose.pdf.internal.html.lj;
import com.aspose.pdf.internal.html.services.lk;
import com.aspose.pdf.internal.l30l.l0p;
import com.aspose.pdf.internal.l30l.l0u;
import com.aspose.pdf.internal.l35v.lf;
import com.aspose.pdf.internal.l71l.l1j;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lf;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l8t;

@DOMObjectAttribute
@DOMNameAttribute(name="Element")
public class Element
extends Node
implements IChildNode,
IParentNode {
    private static final l0t<lc> ShadowSupportedElements = new l0t();
    private final String tagName;
    public lc _Tag;
    private ShadowRoot shadowRoot;
    private NamedNodeMap attributes;
    private l0p styleContainer;
    private String localName;
    private String namespaceURI;
    private String prefix;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, Object> store = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf();

    public Element(le name, Document doc) {
        super(doc);
        this.localName = name.lI();
        this.namespaceURI = name.lt();
        this.prefix = name.ld();
        this.tagName = name.lj();
        this._Tag = lc.lf(name.lI());
        this.attributes = new NamedNodeMap(this);
        this.styleContainer = new l0p(this);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes.getLength() > 0;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @DOMNameAttribute(name="tagName")
    public String getTagName() {
        return this.tagName;
    }

    @DOMNameAttribute(name="id")
    public String getId() {
        String string = this.getAttribute("id");
        if (string == null) {
            string = l10l.lI;
        }
        return string;
    }

    @DOMNameAttribute(name="id")
    public void setId(String value) {
        this.setAttribute("id", value);
    }

    @DOMNameAttribute(name="className")
    public String getClassName() {
        String string = this.getAttribute("class");
        if (string == null) {
            string = l10l.lI;
        }
        return string;
    }

    @DOMNameAttribute(name="className")
    public void setClassName(String value) {
        this.setAttribute("class", value);
    }

    @Override
    public String getTextContent() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 4L, null);
        l1j l1j2 = new l1j();
        while (iTreeWalker.nextNode() != null) {
            l1j2.lI(iTreeWalker.getCurrentNode());
        }
        return l1j2.toString();
    }

    @Override
    public void setTextContent(String value) {
        Text text = null;
        if (!l10l.lf(value)) {
            text = new Text(value, this.nodeDocument);
        }
        Element.replaceAll(text, this);
    }

    @DOMNameAttribute(name="getAttribute")
    @DOMNullableAttribute
    public String getAttribute(String name) {
        Attr attr = NamedNodeMap.getAttribute(name, this);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @DOMNameAttribute(name="getAttributeNS")
    @DOMNullableAttribute
    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = NamedNodeMap.getAttribute(namespaceURI, localName, this);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    @DOMNameAttribute(name="setAttribute")
    public void setAttribute(String name, String value) {
        Attr attr;
        if (!lf.lI(name)) {
            throw com.aspose.pdf.internal.l31f.lI.lh();
        }
        if (l10l.lb(lf.lu.lI, this.getNamespaceURI())) {
            name = l10l.ld(name);
        }
        if ((attr = NamedNodeMap.getAttribute(name, this)) == null) {
            attr = new Attr(le.lI(name, this.prefix, null, this.nodeDocument), this.nodeDocument);
            Attr.setValue(this, attr, value);
            NamedNodeMap.append(attr, this);
            return;
        }
        Attr.change(attr, this, value);
    }

    @DOMNameAttribute(name="setAttributeNS")
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String string = null;
        String string2 = null;
        String[] stringArray = new String[]{namespaceURI};
        String[] stringArray2 = new String[]{string2};
        String[] stringArray3 = new String[]{string};
        le.lI(qualifiedName, stringArray, stringArray2, stringArray3, this.nodeDocument);
        namespaceURI = stringArray[0];
        string2 = stringArray2[0];
        string = stringArray3[0];
        NamedNodeMap.setAttribute(this, string, value, string2, namespaceURI);
    }

    @DOMNameAttribute(name="removeAttribute")
    public void removeAttribute(String name) {
        NamedNodeMap.removeAttribute(name, this);
    }

    @DOMNameAttribute(name="removeAttributeNS")
    public void removeAttributeNS(String namespaceURI, String localName) {
        NamedNodeMap.removeAttribute(namespaceURI, localName, this);
    }

    @DOMNameAttribute(name="hasAttribute")
    public boolean hasAttribute(String name) {
        return NamedNodeMap.getAttribute(name, this) != null;
    }

    @DOMNameAttribute(name="hasAttributeNS")
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return NamedNodeMap.getAttribute(namespaceURI, localName, this) != null;
    }

    @DOMNameAttribute(name="getAttributeNode")
    public Attr getAttributeNode(String name) {
        return NamedNodeMap.getAttribute(name, this);
    }

    @DOMNameAttribute(name="setAttributeNode")
    public Attr setAttributeNode(Attr newAttr) {
        return NamedNodeMap.setAttribute(newAttr, this);
    }

    @DOMNameAttribute(name="removeAttributeNode")
    public Attr removeAttributeNode(Attr oldAttr) {
        if (!NamedNodeMap.contains(this, oldAttr)) {
            throw com.aspose.pdf.internal.l31f.lI.lv();
        }
        NamedNodeMap.remove(oldAttr, this);
        return oldAttr;
    }

    @DOMNameAttribute(name="getAttributeNodeNS")
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return NamedNodeMap.getAttribute(namespaceURI, localName, this);
    }

    @DOMNameAttribute(name="setAttributeNodeNS")
    public Attr setAttributeNodeNS(Attr newAttr) {
        return NamedNodeMap.setAttribute(newAttr, this);
    }

    @DOMNameAttribute(name="getElementsByTagName")
    public HTMLCollection getElementsByTagName(String name) {
        return new com.aspose.pdf.internal.html.collections.lj(this, new ld(name));
    }

    @DOMNameAttribute(name="getElementsByTagNameNS")
    public HTMLCollection getElementsByTagNameNS(String namespaceURI, String localName) {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lb(namespaceURI, localName, this.nodeDocument.getNameTable().lI("*")));
    }

    @Override
    public void remove() {
        if (this.getParentNode() != null) {
            this.getParentNode().removeChild(this);
        }
    }

    @Override
    public Element getFirstElementChild() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 1L, null);
        try {
            Element element = (Element)((Object)com.aspose.pdf.internal.l90y.lb.lI(iTreeWalker.firstChild(), Element.class));
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getLastElementChild() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 1L, null);
        try {
            Element element = (Element)((Object)com.aspose.pdf.internal.l90y.lb.lI(iTreeWalker.lastChild(), Element.class));
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getPreviousElementSibling() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getNextElementSibling() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public int getChildElementCount() {
        return this.getChildren().getLength();
    }

    @Override
    public HTMLCollection getChildren() {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lI(this));
    }

    @Override
    public NodeList querySelectorAll(String selector) {
        return this.nodeDocument.getBrowsingContext().lt().lI(selector, (Node)this);
    }

    @Override
    public Element querySelector(String selector) {
        return this.nodeDocument.getBrowsingContext().lt().lf(selector, (Node)this);
    }

    @DOMNameAttribute(name="schemaTypeInfo")
    public TypeInfo getSchemaTypeInfo() {
        return new TypeInfo(this);
    }

    @DOMNameAttribute(name="setIdAttribute")
    public void setIdAttribute(String name, boolean isId) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="setIdAttributeNS")
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="setIdAttributeNode")
    public void setIdAttributeNode(Attr idAttr, boolean isId) {
        Attr attr = this.getAttributeNode(idAttr.getName());
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="innerHTML")
    public String getInnerHTML() {
        return this.nodeDocument.getContext().getService(lk.class).lI().lI((Node)this, new com.aspose.pdf.internal.html.dom.traversal.filters.le(this), true);
    }

    @DOMNameAttribute(name="innerHTML")
    public void setInnerHTML(String value) {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.removeChild(node);
            node = node2;
        }
        ((lj)this.nodeDocument.getContext()).lI(this, value);
    }

    @DOMNameAttribute(name="outerHTML")
    public String getOuterHTML() {
        return this.nodeDocument.getContext().getService(lk.class).lI().lI((Node)this, true);
    }

    @DOMNameAttribute(name="outerHTML")
    public void setOuterHTML(String value) {
    }

    @DOMNameAttribute(name="attachShadow")
    @DOMInitDictParameterAttribute(name="mode", optional=false)
    public ShadowRoot attachShadow(int mode) {
        if (!l10l.lb(this.getNamespaceURI(), lf.lu.lI)) {
            throw com.aspose.pdf.internal.l31f.lI.lc();
        }
        if (!ShadowSupportedElements.containsItem(this._Tag)) {
            throw com.aspose.pdf.internal.l31f.lI.lc();
        }
        if (this.shadowRoot != null) {
            throw com.aspose.pdf.internal.l31f.lI.l0if();
        }
        this.shadowRoot = new ShadowRoot(this.nodeDocument, mode, this);
        return this.shadowRoot;
    }

    @DOMNameAttribute(name="shadowRoot")
    public ShadowRoot getShadowRoot() {
        if (this.shadowRoot == null || this.shadowRoot.getMode() == 1) {
            return null;
        }
        return this.shadowRoot;
    }

    @DOMNameAttribute(name="getElementsByClassName")
    public HTMLCollection getElementsByClassName(String classNames) {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lt(classNames));
    }

    public l0p getStyleContainer() {
        return this.styleContainer;
    }

    public l0u getComputedStyle() {
        return this.styleContainer.lI();
    }

    public l0u getComputedStyle(String pseudoElement) {
        return this.styleContainer.lI(pseudoElement);
    }

    public void setData(String slotName, Object data) {
        this.store.set_Item(slotName, data);
    }

    public Object getData(String slotName) {
        if (this.store.containsKey(slotName)) {
            return this.store.get_Item(slotName);
        }
        return null;
    }

    public boolean equals(lc other) {
        if (l8t.lf(null, other)) {
            return false;
        }
        return l8t.lf(this._Tag, other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean disposing) {
        super.dispose(disposing);
        if (disposing) {
            this.attributes.dispose();
            lf.ld.lI lI2 = ((lf.ld)this.store.getValues()).lI();
            try {
                while (lI2.hasNext()) {
                    Object e = lI2.next();
                    l5f l5f2 = (l5f)((Object)com.aspose.pdf.internal.l90y.lb.lI(e, l5f.class));
                    if (l5f2 == null) continue;
                    l5f2.dispose();
                }
            }
            finally {
                if (com.aspose.pdf.internal.l90y.lb.lf(lI2, l5f.class)) {
                    ((l5f)lI2).dispose();
                }
            }
            this.store.clear();
        }
    }

    public lc getTag() {
        return this._Tag;
    }

    static {
        ShadowSupportedElements.addItem(lf.le.lh);
        ShadowSupportedElements.addItem(lf.le.lc);
        ShadowSupportedElements.addItem(lf.le.l0f);
        ShadowSupportedElements.addItem(lf.le.le);
        ShadowSupportedElements.addItem(lf.le.l1y);
        ShadowSupportedElements.addItem(lf.le.l0j);
        ShadowSupportedElements.addItem(lf.le.ly);
        ShadowSupportedElements.addItem(lf.le.l0if);
        ShadowSupportedElements.addItem(lf.le.l0l);
        ShadowSupportedElements.addItem(lf.le.l0t);
        ShadowSupportedElements.addItem(lf.le.l0v);
        ShadowSupportedElements.addItem(lf.le.l0p);
        ShadowSupportedElements.addItem(lf.le.l0u);
        ShadowSupportedElements.addItem(lf.le.l1n);
        ShadowSupportedElements.addItem(lf.le.lv);
        ShadowSupportedElements.addItem(lf.le.l0y);
        ShadowSupportedElements.addItem(lf.le.lk);
        ShadowSupportedElements.addItem(lf.le.l4t);
    }
}

