/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom;

import com.aspose.pdf.internal.html.collections.HTMLCollection;
import com.aspose.pdf.internal.html.collections.NodeList;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.IParentNode;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.Text;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.traversal.ITreeWalker;
import com.aspose.pdf.internal.html.dom.traversal.filters.lI;
import com.aspose.pdf.internal.html.dom.traversal.filters.le;
import com.aspose.pdf.internal.html.lj;
import com.aspose.pdf.internal.html.services.lk;
import com.aspose.pdf.internal.l71l.l1j;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.ms.System.l10l;

@DOMObjectAttribute
@DOMNameAttribute(name="DocumentFragment")
public class DocumentFragment
extends Node
implements IParentNode {
    public DocumentFragment(Document ownerDocument) {
        super(ownerDocument);
    }

    @Override
    public String getNodeName() {
        return this.nodeDocument.strDocumentFragmentName;
    }

    @Override
    public int getNodeType() {
        return 11;
    }

    public String getInnerHTML() {
        return this.nodeDocument.getContext().getService(lk.class).lI().lI((Node)this, new le(this), true);
    }

    public void setInnerHTML(String value) {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.removeChild(node);
            node = node2;
        }
        ((lj)this.getOwnerDocument().getContext()).lI(this, value);
    }

    public String getOuterHTML() {
        return this.nodeDocument.getContext().getService(lk.class).lI().lI((Node)this, true);
    }

    public void setOuterHTML(String value) {
    }

    @Override
    public String getTextContent() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 4L, null);
        l1j l1j2 = new l1j();
        while (iTreeWalker.nextNode() != null) {
            l1j2.lI(iTreeWalker.getCurrentNode());
        }
        return l1j2.toString();
    }

    @Override
    public void setTextContent(String value) {
        Text text = null;
        if (l10l.lf(value)) {
            text = new Text(value, this.nodeDocument);
        }
        DocumentFragment.replaceAll(text, this);
    }

    @Override
    public HTMLCollection getChildren() {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lI(this));
    }

    @Override
    public Element getFirstElementChild() {
        ITreeWalker iTreeWalker = this.getOwnerDocument().createTreeWalker(this, 1L, null);
        try {
            Element element = (Element)((Object)lb.lI(iTreeWalker.firstChild(), Element.class));
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getLastElementChild() {
        ITreeWalker iTreeWalker = this.getOwnerDocument().createTreeWalker(this, 1L, null);
        try {
            Element element = (Element)((Object)lb.lI(iTreeWalker.lastChild(), Element.class));
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getPreviousElementSibling() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getNextElementSibling() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public int getChildElementCount() {
        return this.getChildren().getLength();
    }

    @Override
    public Element querySelector(String selector) {
        return this.nodeDocument.getBrowsingContext().lt().lf(selector, this);
    }

    @Override
    public NodeList querySelectorAll(String selector) {
        return this.nodeDocument.getBrowsingContext().lt().lI(selector, this);
    }
}

