/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.collections;

import com.aspose.pdf.internal.html.HTMLDocument;
import com.aspose.pdf.internal.html.collections.IDOMCollectionIndexer;
import com.aspose.pdf.internal.html.dom.Attr;
import com.aspose.pdf.internal.html.dom.DOMObject;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.attributes.DOMAccessorAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMIndexerAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.events.lI;
import com.aspose.pdf.internal.html.dom.le;
import com.aspose.pdf.internal.html.dom.lf;
import com.aspose.pdf.internal.html.lj;
import com.aspose.pdf.internal.l26h.l1n;
import com.aspose.pdf.internal.l26h.l1y;
import com.aspose.pdf.internal.l26h.l2j;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lh;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l8t;

@DOMObjectAttribute
@DOMNameAttribute(name="NamedNodeMap")
@DOMIndexerAttribute(indexerType="Attr")
public class NamedNodeMap
extends DOMObject
implements IDOMCollectionIndexer<Attr>,
l1y<Attr>,
lh<Attr>,
l5f {
    private final Element owner;
    private l2j<Attr> attributeObservers = new l2j();
    private l0t<Attr> nodes;

    public NamedNodeMap(Element element) {
        this.owner = element;
        this.nodes = new l0t();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(Element element, Attr attr) {
        lk lk2 = element.getAttributes().nodes.iterator();
        try {
            while (lk2.hasNext()) {
                Attr attr2 = (Attr)lk2.next();
                if (attr2 != attr) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (lb.lf((Object)lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attr getAttribute(String qualifiedName, Element element) {
        if (l10l.lb(element.getNamespaceURI(), lf.lu.lI) && lb.lf((Object)element.nodeDocument, HTMLDocument.class)) {
            qualifiedName = l10l.ld(qualifiedName);
        }
        lk lk2 = element.getAttributes().nodes.iterator();
        try {
            while (lk2.hasNext()) {
                Attr attr = (Attr)lk2.next();
                if (!l10l.lb(qualifiedName, attr.getName())) continue;
                Attr attr2 = attr;
                return attr2;
            }
        }
        finally {
            if (lb.lf((Object)lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attr getAttribute(String namespace, String localName, Element element) {
        if (l10l.lf(namespace)) {
            namespace = null;
        }
        lk lk2 = element.getAttributes().nodes.iterator();
        try {
            while (lk2.hasNext()) {
                Attr attr = (Attr)lk2.next();
                if (!l10l.lb(namespace, attr.getNamespaceURI()) || !l10l.lb(localName, attr.getLocalName())) continue;
                Attr attr2 = attr;
                return attr2;
            }
        }
        finally {
            if (lb.lf((Object)lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
        return null;
    }

    public static Attr setAttribute(Attr attr, Element element) {
        if (attr.getOwnerElement() != null && attr.getOwnerElement() != element) {
            throw com.aspose.pdf.internal.l31f.lI.ly();
        }
        Attr attr2 = NamedNodeMap.getAttribute(attr.getNamespaceURI(), attr.getLocalName(), element);
        if (l8t.lf(attr, attr2)) {
            return attr;
        }
        if (attr2 != null) {
            NamedNodeMap.replace(attr2, attr, element);
        } else {
            NamedNodeMap.append(attr, element);
        }
        return attr2;
    }

    public static Attr removeAttribute(String qualifiedName, Element element) {
        Attr attr = NamedNodeMap.getAttribute(qualifiedName, element);
        if (attr != null) {
            NamedNodeMap.remove(attr, element);
        }
        return attr;
    }

    public static Attr removeAttribute(String namespace, String localName, Element element) {
        Attr attr = NamedNodeMap.getAttribute(namespace, localName, element);
        if (attr != null) {
            NamedNodeMap.remove(attr, element);
        }
        return attr;
    }

    public static String getAttributeValue(Element element, String namespace, String localName) {
        Attr attr = NamedNodeMap.getAttribute(namespace, localName, element);
        if (attr == null) {
            return l10l.lI;
        }
        return attr.getValue();
    }

    public static void setAttribute(Element element, String localName, String value, String prefix, String namespace) {
        Attr attr;
        if (l10l.lf(prefix)) {
            prefix = null;
        }
        if (l10l.lf(namespace)) {
            namespace = null;
        }
        if ((attr = NamedNodeMap.getAttribute(namespace, localName, element)) == null) {
            attr = new Attr(le.lI(localName, prefix, namespace, element.nodeDocument), element.getOwnerDocument());
            Attr.setValue(element, attr, value);
            NamedNodeMap.append(attr, element);
            return;
        }
        Attr.change(attr, element, value);
    }

    public static void replace(Attr oldAttr, Attr newAttr, Element element) {
        ((lj)element.getOwnerDocument().getContext()).lI(element, oldAttr.getLocalName(), oldAttr.getNamespaceURI(), oldAttr.getValue());
        lj.lI().lI(element, oldAttr.getLocalName(), oldAttr.getValue(), newAttr.getValue(), oldAttr.getNamespaceURI());
        l0t<Attr> l0t2 = element.getAttributes().nodes;
        l0t2.set_Item(l0t2.indexOf(oldAttr), newAttr);
        oldAttr.setOwnerElement(null);
        newAttr.setOwnerElement(element);
        element.getAttributes().notifyAttributeChanged(newAttr);
        if (element.EventMap.lj(newAttr.getName())) {
            lI lI2 = element.EventMap.lI(newAttr.getName());
            lI2.lI(newAttr.getValue());
        }
    }

    public static void append(Attr attr, Element element) {
        ((lj)element.getOwnerDocument().getContext()).lI(element, attr.getLocalName(), attr.getNamespaceURI(), null);
        element.getAttributes().nodes.addItem(attr);
        attr.setOwnerElement(element);
        lj.lI().lI(element, attr.getLocalName(), null, attr.getValue(), attr.getNamespaceURI());
        element.getAttributes().notifyAttributeChanged(attr);
        if (element.EventMap.lj(attr.getName())) {
            lI lI2 = element.EventMap.lI(attr.getName());
            lI2.lI(attr.getValue());
        }
    }

    public static void remove(Attr attr, Element element) {
        ((lj)element.getOwnerDocument().getContext()).lI(element, attr.getLocalName(), attr.getNamespaceURI(), attr.getValue());
        lj.lI().lI(element, attr.getLocalName(), attr.getValue(), null, attr.getNamespaceURI());
        element.getAttributes().nodes.removeItem(attr);
        attr.setOwnerElement(null);
        element.getAttributes().notifyAttributeChanged(attr);
        if (element.EventMap.lj(attr.getName())) {
            lI lI2 = element.EventMap.lI(attr.getName());
            lI2.lI((String)null);
        }
    }

    @DOMNameAttribute(name="length")
    public int getLength() {
        return this.nodes.size();
    }

    @Override
    @DOMNameAttribute(name="item")
    public Attr get_Item(int index) {
        return index >= 0 && index < this.nodes.size() ? this.nodes.get_Item(index) : null;
    }

    @DOMAccessorAttribute(type=1)
    public Attr get_Item(String name) {
        return this.getNamedItem(name);
    }

    @DOMNameAttribute(name="getNamedItem")
    public Attr getNamedItem(String name) {
        return NamedNodeMap.getAttribute(name, this.owner);
    }

    @DOMNameAttribute(name="getNamedItemNS")
    public Attr getNamedItemNS(String namespaceURI, String localName) {
        return NamedNodeMap.getAttribute(namespaceURI, localName, this.owner);
    }

    @DOMNameAttribute(name="setNamedItem")
    public Attr setNamedItem(Attr attr) {
        return NamedNodeMap.setAttribute(attr, this.owner);
    }

    @DOMNameAttribute(name="setNamedItemNS")
    public Attr setNamedItemNS(Attr attr) {
        return NamedNodeMap.setAttribute(attr, this.owner);
    }

    @DOMNameAttribute(name="removeNamedItem")
    public Attr removeNamedItem(String name) {
        Attr attr = NamedNodeMap.removeAttribute(name, this.owner);
        if (attr == null) {
            throw com.aspose.pdf.internal.l31f.lI.lv();
        }
        return attr;
    }

    @DOMNameAttribute(name="removeNamedItemNS")
    public Attr removeNamedItemNS(String namespaceURI, String localName) {
        Attr attr = NamedNodeMap.removeAttribute(namespaceURI, localName, this.owner);
        if (attr == null) {
            throw com.aspose.pdf.internal.l31f.lI.lv();
        }
        return attr;
    }

    @Override
    public lk<Attr> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public l5f subscribe(l1n<Attr> observer) {
        return this.attributeObservers.subscribe(observer);
    }

    public void notifyAttributeChanged(Attr attr) {
        this.attributeObservers.lI(attr);
    }

    @Override
    public void dispose() {
        if (this.attributeObservers != null) {
            this.attributeObservers.dispose();
        }
    }
}

