/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html;

import com.aspose.pdf.internal.ms.System.IO.Stream;

public class MeteredStreamCounter
extends Stream {
    private Stream _stream;
    private long _length;
    private long _origin;
    private long _position;

    public MeteredStreamCounter(Stream stream) {
        this._stream = stream;
        this._origin = this._position = stream.getPosition();
        this._length = stream.getLength();
    }

    public Stream getWrappedStream() {
        return this._stream;
    }

    @Override
    public boolean canRead() {
        return this._stream.canRead();
    }

    @Override
    public boolean canSeek() {
        return this._stream.canSeek();
    }

    @Override
    public boolean canWrite() {
        return this._stream.canWrite();
    }

    @Override
    public long getLength() {
        return this._stream.getLength();
    }

    @Override
    public void setLength(long value) {
        this._length = this._origin + (long)((int)value);
        this._stream.setLength(value);
    }

    public long getCalculatedLength() {
        return this._length - this._origin;
    }

    @Override
    public long getPosition() {
        return this._stream.getPosition();
    }

    @Override
    public void setPosition(long value) {
        this._stream.setPosition(value);
    }

    @Override
    public void flush() {
        this._stream.flush();
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        long l = this._length - this._position;
        if (l > (long)count) {
            l = count;
        }
        if (l > 0L) {
            this._position += l;
        }
        return this._stream.read(buffer, offset, count);
    }

    @Override
    public int readByte() {
        if (this._position < this._length) {
            ++this._position;
        }
        return this._stream.readByte();
    }

    @Override
    public long seek(long offset, int loc) {
        switch (loc) {
            case 0: {
                long l = this._origin + (long)((int)offset);
                if (offset < 0L || l < this._origin) break;
                this._position = l;
                break;
            }
            case 1: {
                long l = this._position + (long)((int)offset);
                if (this._position + offset < this._origin || l < this._origin) break;
                this._position = l;
                break;
            }
            case 2: {
                long l = this._length + (long)((int)offset);
                if (this._length + offset < this._origin || l < this._origin) break;
                this._position = l;
                break;
            }
        }
        return this._stream.seek(offset, loc);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        long l = this._position + (long)count;
        if (l >= 0L) {
            if (l > this._length) {
                this._length = l;
            }
            this._position = l;
        }
        this._stream.write(buffer, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this._position >= this._length) {
            this._length = this._position + 1L;
        }
        ++this._position;
        this._stream.writeByte(value);
    }
}

