/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html;

import com.aspose.pdf.internal.html.Configuration;
import com.aspose.pdf.internal.html.HTMLElement;
import com.aspose.pdf.internal.html.Url;
import com.aspose.pdf.internal.html.collections.HTMLCollection;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.css.ICSSStyleDeclaration;
import com.aspose.pdf.internal.html.dom.css.IDocumentCSS;
import com.aspose.pdf.internal.html.dom.css.IViewCSS;
import com.aspose.pdf.internal.html.dom.events.lb;
import com.aspose.pdf.internal.html.dom.lf;
import com.aspose.pdf.internal.html.dom.traversal.filters.ld;
import com.aspose.pdf.internal.html.dom.traversal.filters.lu;
import com.aspose.pdf.internal.html.lc;
import com.aspose.pdf.internal.html.lj;
import com.aspose.pdf.internal.html.net.RequestMessage;
import com.aspose.pdf.internal.html.net.lt;
import com.aspose.pdf.internal.html.rendering.HtmlRenderer;
import com.aspose.pdf.internal.html.rendering.IDevice;
import com.aspose.pdf.internal.html.saving.HTMLSaveOptions;
import com.aspose.pdf.internal.html.saving.MHTMLSaveOptions;
import com.aspose.pdf.internal.html.saving.MarkdownSaveOptions;
import com.aspose.pdf.internal.html.services.lk;
import com.aspose.pdf.internal.l37f.lI;
import com.aspose.pdf.internal.l46v.lf;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.ly;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1y;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import java.io.InputStream;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLDocument")
public class HTMLDocument
extends Document
implements IDocumentCSS {
    private String cookie;
    private IViewCSS defaultView;

    public HTMLDocument() {
        this("about:blank");
    }

    public HTMLDocument(Configuration configuration) {
        this("about:blank", configuration);
    }

    public HTMLDocument(Url url) {
        this(url, new Configuration());
    }

    public HTMLDocument(Url url, Configuration configuration) {
        this(lI.lI(url), configuration, 3);
    }

    public HTMLDocument(String address) {
        this(new Url(address, l10l.lI(new Object[]{com.aspose.pdf.internal.l47n.lf.lI(), Character.valueOf(l1y.lj)})));
    }

    public HTMLDocument(String address, Configuration configuration) {
        this(new Url(address, l10l.lI(new Object[]{com.aspose.pdf.internal.l47n.lf.lI(), Character.valueOf(l1y.lj)})), configuration);
    }

    public HTMLDocument(String content, String baseUri) {
        this(content, baseUri, new Configuration());
    }

    public HTMLDocument(String content, String baseUri, Configuration configuration) {
        this(lI.lI(content, baseUri), configuration, 3);
    }

    public HTMLDocument(InputStream content, String baseUri) {
        this(Stream.fromJava(content), baseUri, new Configuration());
    }

    public HTMLDocument(Stream content, String baseUri) {
        this(content, baseUri, new Configuration());
    }

    public HTMLDocument(InputStream content, String baseUri, Configuration configuration) {
        this(new lt(Stream.fromJava(content), new Url(baseUri, l10l.lI(new Object[]{com.aspose.pdf.internal.l47n.lf.lI(), Character.valueOf(l1y.lj)})).getHref()), configuration);
    }

    public HTMLDocument(Stream content, String baseUri, Configuration configuration) {
        this(lI.lI(content, baseUri), configuration, 3);
    }

    public HTMLDocument(RequestMessage request) {
        this(request, new Configuration());
    }

    public HTMLDocument(RequestMessage request, Configuration configuration) {
        this(request, configuration, 1);
    }

    private HTMLDocument(final RequestMessage request, Configuration configuration, final byte flags) {
        super(new lj(configuration), new Document.lI(){
            {
                this.lI(lb.lt);
                this.lI(request);
                this.lI(flags);
            }
        });
    }

    public HTMLDocument(lj context) {
        super(context);
    }

    @DOMNameAttribute(name="title")
    public String getTitle() {
        Element element = com.aspose.pdf.internal.l35j.lI.lI(this.getElementsByTagName(lf.le.lj.lf()));
        if (element != null) {
            return element.getTextContent();
        }
        return l10l.lI;
    }

    @DOMNameAttribute(name="title")
    public void setTitle(String value) {
        if (this.getDocumentElement() != null && l10l.lb(this.getDocumentElement().getNamespaceURI(), lf.lu.lI)) {
            Element element = com.aspose.pdf.internal.l35j.lI.lI(this.getElementsByTagName(lc.lI(lf.le.lj)));
            if (element != null) {
                element.setTextContent(value);
                return;
            }
            Element element2 = com.aspose.pdf.internal.l35j.lI.lI(this.getElementsByTagName(lc.lI(lf.le.lf)));
            if (element2 == null) {
                return;
            }
            element = this.createElement(lf.le.lj.lf());
            element.setTextContent(value);
            element2.appendChild(element);
        }
    }

    @DOMNameAttribute(name="referrer")
    public String getReferrer() {
        return l10l.lI;
    }

    @DOMNameAttribute(name="domain")
    @DOMNullableAttribute
    public String getDomain() {
        return this.getLocation().getHost();
    }

    @DOMNameAttribute(name="body")
    public HTMLElement getBody() {
        com.aspose.pdf.internal.html.collections.lj lj2 = new com.aspose.pdf.internal.html.collections.lj(this, new lu("BODY", "FRAMESET"));
        return (HTMLElement)com.aspose.pdf.internal.l35j.lI.lI(lj2);
    }

    @DOMNameAttribute(name="body")
    public void setBody(HTMLElement value) {
        com.aspose.pdf.internal.l29t.lI.lI(value, "value");
        HTMLElement hTMLElement = this.getBody();
        if (hTMLElement != null) {
            this.getDocumentElement().replaceChild(hTMLElement, value);
        } else {
            this.getDocumentElement().appendChild(value);
        }
    }

    @DOMNameAttribute(name="images")
    public HTMLCollection getImages() {
        return this.getElementsByTagName("IMG");
    }

    @DOMNameAttribute(name="applets")
    public HTMLCollection getApplets() {
        com.aspose.pdf.internal.ms.System.Collections.Generic.lf lf2 = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf(2);
        lf2.addItem("APPLET", null);
        l0t<ly<String, String>> l0t2 = new l0t<ly<String, String>>(2);
        l0t2.addItem(new ly<String, String>("classid", "clsid:CAFEEFAC-00"));
        l0t2.addItem(new ly<String, String>("classid", "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"));
        lf2.addItem("OBJECT", l0t2);
        l0t<ly<String, String>> l0t3 = new l0t<ly<String, String>>(3);
        l0t3.addItem(new ly<String, String>("type", "application/x-java-applet"));
        l0t3.addItem(new ly<String, String>("type", "application/x-java-bean"));
        l0t3.addItem(new ly<String, String>("type", "application/x-java-vm"));
        lf2.addItem("EMBED", l0t3);
        return new com.aspose.pdf.internal.html.collections.lj(this, new lu("APPLET", "OBJECT", "EMBED"));
    }

    @DOMNameAttribute(name="links")
    public HTMLCollection getLinks() {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lu("A", "AREA"));
    }

    @DOMNameAttribute(name="forms")
    public HTMLCollection getForms() {
        return new com.aspose.pdf.internal.html.collections.lj(this, new ld("FORM"));
    }

    @DOMNameAttribute(name="anchors")
    public HTMLCollection getAnchors() {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lu("A"));
    }

    @DOMNameAttribute(name="cookie")
    public String getCookie() {
        return this.cookie;
    }

    @DOMNameAttribute(name="cookie")
    public void setCookie(String value) {
        this.cookie = value;
    }

    @Override
    public ICSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        return this.getBrowsingContext().lt().lI(elt, pseudoElt);
    }

    public void save(Url url) {
        this.save(url, 0);
    }

    public void save(String path) {
        this.save(new Url(path, l10l.lI(new Object[]{com.aspose.pdf.internal.l47n.lf.lI(), Character.valueOf(l1y.lj)})));
    }

    public void save(String path, int saveFormat) {
        this.save(new Url(path, l10l.lI(new Object[]{com.aspose.pdf.internal.l47n.lf.lI(), Character.valueOf(l1y.lj)})), saveFormat);
    }

    public void save(Url url, int saveFormat) {
        switch (saveFormat) {
            case 0: {
                this.save(url, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(url, MarkdownSaveOptions.getDefault());
                break;
            }
            case 2: {
                this.save(url, new MHTMLSaveOptions());
            }
        }
    }

    public void save(String path, HTMLSaveOptions saveOptions) {
        this.save(new Url(path, l10l.lI(new Object[]{com.aspose.pdf.internal.l47n.lf.lI(), Character.valueOf(l1y.lj)})), saveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, HTMLSaveOptions saveOptions) {
        lf lf2 = this.getContext().getService(lk.class).lI(this.getBrowsingContext());
        l5f l5f2 = lf2.lI((Url)this.getLocation(), saveOptions);
        try {
            lf2.lI().lf(url);
            lf2.lI(this);
        }
        finally {
            if (l5f2 != null) {
                l5f2.dispose();
            }
        }
    }

    public void save(String path, MarkdownSaveOptions saveOptions) {
        this.save(new Url(path, l10l.lI(new Object[]{com.aspose.pdf.internal.l47n.lf.lI(), Character.valueOf(l1y.lj)})), saveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, MarkdownSaveOptions saveOptions) {
        lf lf2 = this.getContext().getService(lk.class).lI(this.getBrowsingContext());
        l5f l5f2 = lf2.lI((Url)this.getLocation(), saveOptions);
        try {
            lf2.lI().lf(url);
            lf2.lI(new com.aspose.pdf.internal.l46v.lj<HTMLElement>(this.getBody(), this.getLocation().getHref()), Node.class);
        }
        finally {
            if (l5f2 != null) {
                l5f2.dispose();
            }
        }
    }

    public void save(String path, MHTMLSaveOptions saveOptions) {
        this.save(new Url(path, l10l.lI(new Object[]{com.aspose.pdf.internal.l47n.lf.lI(), Character.valueOf(l1y.lj)})), saveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, MHTMLSaveOptions saveOptions) {
        lf lf2 = this.getContext().getService(lk.class).lI(this.getBrowsingContext());
        l5f l5f2 = lf2.lI((Url)this.getLocation(), saveOptions);
        try {
            lf2.lI().lI(url);
            lf2.lI().lf(url);
            lf2.lI(this);
        }
        finally {
            if (l5f2 != null) {
                l5f2.dispose();
            }
        }
    }

    @Override
    public void renderTo(IDevice device) {
        HtmlRenderer htmlRenderer = new HtmlRenderer();
        try {
            htmlRenderer.render(device, this);
        }
        finally {
            if (htmlRenderer != null) {
                htmlRenderer.dispose();
            }
        }
    }
}

