/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.doc.ml;

import com.aspose.pdf.internal.doc.ml.FoCommonContext;
import com.aspose.pdf.internal.doc.ml.IXmlWordProperties;
import com.aspose.pdf.internal.doc.ml.WborderProperty;
import com.aspose.pdf.internal.doc.ml.Wtbl;
import com.aspose.pdf.internal.doc.ml.Wtc;
import com.aspose.pdf.internal.doc.ml.WtcPr;
import com.aspose.pdf.internal.doc.ml.Wtr;
import com.aspose.pdf.internal.doc.ml.XmlWordAttribute;
import com.aspose.pdf.internal.doc.ml.XmlWordElement;
import com.aspose.pdf.internal.doc.ml.XslFoAttribute;
import com.aspose.pdf.internal.doc.ml.XslFoMeasurer;
import com.aspose.pdf.internal.doc.ml.XslFoProperties;
import com.aspose.pdf.internal.l96if.l4y;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.ly;

public class WtblBorders
implements IXmlWordProperties {
    private WborderProperty lI;
    private WborderProperty lf;
    private WborderProperty lj;
    private WborderProperty lt;
    private WborderProperty lb;
    private WborderProperty ld;

    private void lI(int n, WborderProperty wborderProperty) {
        switch (n) {
            case 0: {
                this.lI = wborderProperty;
                break;
            }
            case 1: {
                this.lf = wborderProperty;
                break;
            }
            case 2: {
                this.lj = wborderProperty;
                break;
            }
            case 3: {
                this.lt = wborderProperty;
                break;
            }
            case 4: {
                this.lb = wborderProperty;
                break;
            }
            case 5: {
                this.ld = wborderProperty;
            }
        }
    }

    public boolean accept(l4y prl) {
        boolean bl = true;
        int n = 0;
        switch (prl.lj().lb()) {
            case 54789: {
                n = 4;
                break;
            }
            case 54803: {
                n = 8;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (n > 0) {
            for (int i = 0; i < 6; ++i) {
                byte[] byArray = new byte[n];
                ly.lf(ly.lj((Object)prl.lt()), 1 + i * n, ly.lj((Object)byArray), 0, n);
                this.lI(i, new WborderProperty(byArray));
            }
        }
        return bl;
    }

    public XmlWordAttribute[] getAttributes() {
        return new XmlWordAttribute[0];
    }

    public XmlWordElement[] getElements() {
        l0t<XmlWordElement> l0t2 = new l0t<XmlWordElement>();
        l0t2.addItem(new XmlWordElement("top", this.lI));
        l0t2.addItem(new XmlWordElement("left", this.lf));
        l0t2.addItem(new XmlWordElement("bottom", this.lj));
        l0t2.addItem(new XmlWordElement("right", this.lt));
        l0t2.addItem(new XmlWordElement("insideH", this.lb));
        l0t2.addItem(new XmlWordElement("insideV", this.ld));
        return l0t2.toArray(new XmlWordElement[0]);
    }

    public void convertToXslFo(XslFoProperties parent, FoCommonContext common, Wtbl tbl, Wtr tr, Wtc tc) {
        if (this.ld != null) {
            WtblBorders.putBorderSpecificsForCell(parent, this.ld, false, tbl, tr, tc, "vertical");
        }
        if (this.lb != null) {
            WtblBorders.putBorderSpecificsForCell(parent, this.lb, false, tbl, tr, tc, "horizontal");
        }
        if (this.lI != null) {
            WtblBorders.putBorderSpecificsForCell(parent, this.lI, false, tbl, tr, tc, "top");
        }
        if (this.lf != null) {
            WtblBorders.putBorderSpecificsForCell(parent, this.lf, false, tbl, tr, tc, "left");
        }
        if (this.lt != null) {
            WtblBorders.putBorderSpecificsForCell(parent, this.lt, false, tbl, tr, tc, "right");
        }
        if (this.lj != null) {
            WtblBorders.putBorderSpecificsForCell(parent, this.lj, false, tbl, tr, tc, "bottom");
        }
    }

    public static void setBorderStyle(XslFoProperties parent, String attributeName, WborderProperty.WborderValues style) {
        XslFoAttribute xslFoAttribute = new XslFoAttribute(attributeName);
        switch (style.getValue()) {
            case 4: {
                xslFoAttribute.setValue("double");
                break;
            }
            case 5: 
            case 8: 
            case 34: 
            case 69: {
                xslFoAttribute.setValue("dotted");
                break;
            }
            case 6: 
            case 7: 
            case 21: 
            case 22: 
            case 33: 
            case 37: 
            case 68: {
                xslFoAttribute.setValue("dashed");
                break;
            }
            case 24: {
                xslFoAttribute.setValue("groove");
                break;
            }
            case 23: {
                xslFoAttribute.setValue("ridge");
                break;
            }
            case 26: {
                xslFoAttribute.setValue("inset");
                break;
            }
            case 25: {
                xslFoAttribute.setValue("outset");
                break;
            }
            case 0: 
            case 1: {
                xslFoAttribute.setValue("none");
                break;
            }
            default: {
                xslFoAttribute.setValue("solid");
            }
        }
        parent.addAttribute(xslFoAttribute);
    }

    public static void putOneBorderSpecifics(XslFoProperties parent, String side, WborderProperty borderProperty) {
        WtblBorders.setBorderStyle(parent, l10l.lI(new String[]{"border-", side, "-style"}), borderProperty.getVal());
        if (borderProperty.getColor() != null) {
            parent.addAttribute(new XslFoAttribute(l10l.lI(new String[]{"border-", side, "-color"}), borderProperty.getColor().getValueAsString()));
        }
        if (borderProperty.getSz() != 0xFFFFFFFFL) {
            parent.addAttribute(new XslFoAttribute(l10l.lI(new String[]{"border-", side, "-width"}), XslFoMeasurer.toPt((float)(borderProperty.getSz() & 0xFFFFFFFFL) / 16.0f)));
        }
    }

    public static void putBorderSpecificsForCell(XslFoProperties parent, WborderProperty borderProperty, boolean istcBorder, Wtbl tbl, Wtr tr, Wtc tc, String direction) {
        boolean bl = tr.getTcs().indexOf(tc) > 0;
        boolean bl2 = tbl.getTrs().indexOf(tr) > 0;
        boolean bl3 = tr.getTcs().indexOf(tc) < tr.getTcs().size() - 1 && tc.getTcPr().getHmerge().equals(WtcPr.WMergeType.NullValue) || tc.getTcPr().getHmerge().equals(WtcPr.WMergeType.Restart);
        boolean bl4 = false;
        if (tbl.getTrs().indexOf(tr) < tbl.getTrs().size() - 1) {
            Wtc wtc = (Wtc)tbl.getTrs().get_Item(tbl.getTrs().indexOf(tr) + 1).getTcs().lI(tr.getTcs().indexOf(tc));
            boolean bl5 = bl4 = wtc.getTcPr().getVmerge().equals(WtcPr.WMergeType.NullValue) || wtc.getTcPr().getVmerge().equals(WtcPr.WMergeType.Restart);
        }
        if ("vertical".equals(direction)) {
            if (tc != null && tr.getTcs().size() > 1) {
                if (!bl) {
                    WtblBorders.putOneBorderSpecifics(parent, "right", borderProperty);
                } else if (!bl3) {
                    WtblBorders.putOneBorderSpecifics(parent, "left", borderProperty);
                } else {
                    WtblBorders.putOneBorderSpecifics(parent, "left", borderProperty);
                    WtblBorders.putOneBorderSpecifics(parent, "right", borderProperty);
                }
            }
        } else if ("horizontal".equals(direction)) {
            if (tc != null && tbl.getTrs().size() > 1) {
                if (!bl2) {
                    WtblBorders.putOneBorderSpecifics(parent, "bottom", borderProperty);
                } else if (!bl4) {
                    WtblBorders.putOneBorderSpecifics(parent, "top", borderProperty);
                } else {
                    WtblBorders.putOneBorderSpecifics(parent, "bottom", borderProperty);
                    WtblBorders.putOneBorderSpecifics(parent, "top", borderProperty);
                }
            }
        } else if ("top".equals(direction)) {
            if (istcBorder || !bl2) {
                WtblBorders.putOneBorderSpecifics(parent, "top", borderProperty);
            }
        } else if ("right".equals(direction)) {
            if (istcBorder || !bl3) {
                WtblBorders.putOneBorderSpecifics(parent, "right", borderProperty);
            }
        } else if ("bottom".equals(direction)) {
            if (istcBorder || !bl4) {
                WtblBorders.putOneBorderSpecifics(parent, "bottom", borderProperty);
            }
        } else if ("left".equals(direction) && (istcBorder || !bl)) {
            WtblBorders.putOneBorderSpecifics(parent, "left", borderProperty);
        }
    }
}

