/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Border;
import com.aspose.pdf.BorderStyleConverter;
import com.aspose.pdf.CaretAnnotation;
import com.aspose.pdf.CaretSymbolConverter;
import com.aspose.pdf.CircleAnnotation;
import com.aspose.pdf.Color;
import com.aspose.pdf.CommonFigureAnnotation;
import com.aspose.pdf.Dash;
import com.aspose.pdf.Document;
import com.aspose.pdf.FileAttachmentAnnotation;
import com.aspose.pdf.FileIconConverter;
import com.aspose.pdf.FileSpecification;
import com.aspose.pdf.FitExplicitDestination;
import com.aspose.pdf.FitHExplicitDestination;
import com.aspose.pdf.FreeTextAnnotation;
import com.aspose.pdf.GoToAction;
import com.aspose.pdf.GoToRemoteAction;
import com.aspose.pdf.GoToURIAction;
import com.aspose.pdf.HighlightAnnotation;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.InkAnnotation;
import com.aspose.pdf.JavascriptAction;
import com.aspose.pdf.LaunchAction;
import com.aspose.pdf.LineAnnotation;
import com.aspose.pdf.LineEndingConverter;
import com.aspose.pdf.LinkAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.MovieAnnotation;
import com.aspose.pdf.NamedAction;
import com.aspose.pdf.Operator;
import com.aspose.pdf.OperatorCollection;
import com.aspose.pdf.OutlineItemCollection;
import com.aspose.pdf.Page;
import com.aspose.pdf.PdfAction;
import com.aspose.pdf.Point;
import com.aspose.pdf.PolygonAnnotation;
import com.aspose.pdf.PolylineAnnotation;
import com.aspose.pdf.PopupAnnotation;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Resources;
import com.aspose.pdf.SoundAnnotation;
import com.aspose.pdf.SoundIconConverter;
import com.aspose.pdf.SquareAnnotation;
import com.aspose.pdf.SquigglyAnnotation;
import com.aspose.pdf.StampAnnotation;
import com.aspose.pdf.StampIconConverter;
import com.aspose.pdf.StrikeOutAnnotation;
import com.aspose.pdf.TextAnnotation;
import com.aspose.pdf.TextEditOptions;
import com.aspose.pdf.TextFragment;
import com.aspose.pdf.TextFragmentAbsorber;
import com.aspose.pdf.TextIconConverter;
import com.aspose.pdf.TextReplaceOptions;
import com.aspose.pdf.TextSearchOptions;
import com.aspose.pdf.TextState;
import com.aspose.pdf.UnderlineAnnotation;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XImage;
import com.aspose.pdf.facades.LineInfo;
import com.aspose.pdf.facades.PdfExtractor;
import com.aspose.pdf.facades.ReplaceTextStrategy;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.facades.StampInfo;
import com.aspose.pdf.internal.l5n.l0h;
import com.aspose.pdf.internal.l5n.l0if;
import com.aspose.pdf.internal.l5n.l1l;
import com.aspose.pdf.internal.l5n.l1v;
import com.aspose.pdf.internal.l68j.ld;
import com.aspose.pdf.internal.l68j.lf;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l2l;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lf;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l4k;
import com.aspose.pdf.internal.ms.System.l4n;
import com.aspose.pdf.internal.ms.System.l6u;
import com.aspose.pdf.internal.ms.System.lh;
import com.aspose.pdf.internal.ms.System.ly;
import com.aspose.pdf.operators.BDC;
import com.aspose.pdf.operators.ConcatenateMatrix;
import com.aspose.pdf.operators.Do;
import com.aspose.pdf.operators.EMC;
import com.aspose.pdf.operators.GRestore;
import com.aspose.pdf.operators.GS;
import com.aspose.pdf.operators.GSave;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfContentEditor
extends SaveableFacade {
    private static final Logger lI = Logger.getLogger(PdfContentEditor.class.getName());
    private TextSearchOptions lf = new TextSearchOptions(false);
    private TextEditOptions lj = new TextEditOptions(1);
    private TextReplaceOptions lt = new TextReplaceOptions(0);
    private com.aspose.pdf.internal.l1t.lI<Integer, lI[]> lb = new com.aspose.pdf.internal.l1t.lI();
    private ReplaceTextStrategy ld = new ReplaceTextStrategy();
    private static final String lu = "HiddenStamp";
    private l4k le = new l4k(){

        public void lI(Object object, l4n l4n2) {
            PdfContentEditor.this.lI(object, l4n2);
        }
    };
    public static final String DOCUMENT_OPEN = "DO";
    public static final String DOCUMENT_CLOSE = "WC";
    public static final String DOCUMENT_WILL_SAVE = "WS";
    public static final String DOCUMENT_SAVED = "DS";
    public static final String DOCUMENT_WILL_PRINT = "WP";
    public static final String DOCUMENT_PRINTED = "DP";
    private static final com.aspose.pdf.internal.l90y.lh lh;

    private void lI(PdfAction pdfAction, int[] nArray, boolean bl) {
        if (nArray != null && nArray.length > (bl ? 1 : 0)) {
            int n;
            pdfAction.getNext().add(new NamedAction(nArray[bl ? 1 : 0]));
            int n2 = n = bl ? 2 : 1;
            while (n < nArray.length) {
                pdfAction.getNext().add(new NamedAction(nArray[n]));
                ++n;
            }
        }
    }

    private void lI(PdfAction pdfAction, int[] nArray) {
        this.lI(pdfAction, nArray, false);
    }

    private void lI(Object object, l4n l4n2) {
        this.lI();
    }

    private void lI() {
        if (this.lf == null) {
            this.lf = new TextSearchOptions(this.ld.isRegularExpressionUsed());
        }
        this.lf.setRegularExpressionUsed(this.ld.isRegularExpressionUsed());
        switch (this.ld.getNoCharacterBehavior()) {
            case 2: {
                this.lj.setNoCharacterBehavior(2);
                break;
            }
            case 0: {
                this.lj.setNoCharacterBehavior(0);
                break;
            }
            case 1: {
                this.lj.setNoCharacterBehavior(1);
            }
        }
        switch (this.ld.getReplaceScope()) {
            case 0: {
                this.lt.setReplaceScope(0);
                break;
            }
            case 1: {
                this.lt.setReplaceScope(1);
            }
        }
    }

    public TextSearchOptions getTextSearchOptions() {
        return this.lf;
    }

    public void setTextSearchOptions(TextSearchOptions value) {
        if (value != null) {
            this.lf = value;
            this.ld.setRegularExpressionUsed(this.lf.isRegularExpressionUsed());
        }
    }

    public TextEditOptions getTextEditOptions() {
        return this.lj;
    }

    public void setTextEditOptions(TextEditOptions value) {
        if (value != null) {
            this.lj = value;
            switch (this.lj.getNoCharacterBehavior()) {
                case 2: {
                    this.ld.setNoCharacterBehavior(2);
                    break;
                }
                case 0: {
                    this.ld.setNoCharacterBehavior(0);
                    break;
                }
                case 1: {
                    this.ld.setNoCharacterBehavior(1);
                    break;
                }
            }
        }
    }

    public TextReplaceOptions getTextReplaceOptions() {
        return this.lt;
    }

    public void setTextReplaceOptions(TextReplaceOptions value) {
        if (value != null) {
            this.lt = value;
            switch (this.lt.getReplaceScope()) {
                case 0: {
                    this.ld.setReplaceScope(0);
                    break;
                }
                case 1: {
                    this.ld.setReplaceScope(1);
                    break;
                }
            }
        }
    }

    public ReplaceTextStrategy getReplaceTextStrategy() {
        return this.ld;
    }

    public void setReplaceTextStrategy(ReplaceTextStrategy value) {
        if (value != null) {
            if (this.ld != null) {
                this.ld.lI.lI(this.le);
            }
            this.ld = value;
            this.ld.lI.lf(this.le);
            this.lI();
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        super.bindPdf(inputFile);
        this.lf();
    }

    void lf(Stream stream) {
        super.lu(stream);
        this.lf();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        super.ld(Stream.fromJava(inputStream));
        this.lf();
    }

    public List<Annotation> extractLink() {
        this.lt();
        AnnotationSelector annotationSelector = new AnnotationSelector(new LinkAnnotation(this.getDocument().getPages().get_Item(1), Rectangle.getTrivial()));
        this.getDocument().getPages().accept(annotationSelector);
        return annotationSelector.getSelected();
    }

    public void createWebLink(java.awt.Rectangle rect, String url, int originalPage, java.awt.Color clr, int[] actionName) {
        this.lt();
        GoToURIAction goToURIAction = new GoToURIAction(url);
        this.lI(goToURIAction, actionName);
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        linkAnnotation.setColor(Color.fromRgb(clr));
        linkAnnotation.setAction(goToURIAction);
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createWebLink(java.awt.Rectangle rect, String url, int originalPage, java.awt.Color clr) {
        this.createWebLink(rect, url, originalPage, clr, null);
    }

    public void createWebLink(java.awt.Rectangle rect, String url, int originalPage) {
        this.createWebLink(rect, url, originalPage, java.awt.Color.BLACK, null);
    }

    public void createLocalLink(java.awt.Rectangle rect, int desPage, int originalPage, java.awt.Color clr, int[] actionName) {
        this.lt();
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        if (!com.aspose.pdf.internal.l68j.ld.lI(clr).lc()) {
            linkAnnotation.setColor(Color.fromRgb(clr));
        }
        if (actionName != null && actionName.length > 0) {
            GoToAction goToAction = new GoToAction(desPage);
            this.lI(goToAction, actionName);
            linkAnnotation.setAction(goToAction);
        } else {
            linkAnnotation.setDestination(new FitExplicitDestination(this.getDocument().getPages().get_Item(desPage)));
        }
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createLocalLink(java.awt.Rectangle rect, int desPage, int originalPage, java.awt.Color clr) {
        this.createLocalLink(rect, desPage, originalPage, clr, null);
    }

    public void createPdfDocumentLink(java.awt.Rectangle rect, String remotePdf, int originalPage, int destinationPage, java.awt.Color clr, int[] actionName) {
        this.lt();
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        GoToRemoteAction goToRemoteAction = new GoToRemoteAction(remotePdf, destinationPage);
        this.lI(goToRemoteAction, actionName);
        linkAnnotation.setAction(goToRemoteAction);
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createPdfDocumentLink(java.awt.Rectangle rect, String remotePdf, int originalPage, int destinationPage, java.awt.Color clr) {
        this.createPdfDocumentLink(rect, remotePdf, originalPage, destinationPage, clr, null);
    }

    public void createPdfDocumentLink(java.awt.Rectangle rect, String remotePdf, int originalPage, int destinationPage) {
        this.lt();
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        linkAnnotation.setAction(new GoToRemoteAction(remotePdf, destinationPage));
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createCustomActionLink(java.awt.Rectangle rect, int originalPage, java.awt.Color color, int[] actionName) {
        this.lt();
        if (actionName == null || actionName.length == 0) {
            return;
        }
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        linkAnnotation.setColor(Color.fromRgb(color));
        NamedAction namedAction = new NamedAction(actionName[0]);
        this.lI(namedAction, actionName, true);
        linkAnnotation.setAction(namedAction);
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createApplicationLink(java.awt.Rectangle rect, String application, int page, java.awt.Color clr, int[] actionName) {
        this.lt();
        LaunchAction launchAction = new LaunchAction(application);
        this.lI(launchAction, actionName);
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect));
        linkAnnotation.setColor(Color.fromRgb(clr));
        linkAnnotation.setAction(launchAction);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(linkAnnotation);
    }

    public void createApplicationLink(java.awt.Rectangle rect, String application, int page, java.awt.Color clr) {
        this.createApplicationLink(rect, application, page, clr, null);
    }

    public void createApplicationLink(java.awt.Rectangle rect, String application, int page) {
        this.createApplicationLink(rect, application, page, java.awt.Color.WHITE, null);
    }

    public void createJavaScriptLink(String code, java.awt.Rectangle rect, int originalPage, java.awt.Color color) {
        this.lt();
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        linkAnnotation.setColor(Color.fromRgb(color));
        linkAnnotation.setAction(new JavascriptAction(code));
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createText(java.awt.Rectangle rect, String title, String contents, boolean open, String icon, int page) {
        this.lt();
        Page page2 = this.getDocument().getPages().get_Item(page);
        TextAnnotation textAnnotation = new TextAnnotation(page2, Rectangle.fromRect(rect));
        textAnnotation.setTitle(title);
        textAnnotation.setContents(contents);
        textAnnotation.setOpen(open);
        textAnnotation.setIcon(TextIconConverter.toEnum(icon));
        page2.getAnnotations().add(textAnnotation);
    }

    public void createFreeText(java.awt.Rectangle rect, String contents, int page) {
        this.lt();
        FreeTextAnnotation freeTextAnnotation = new FreeTextAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), null);
        freeTextAnnotation.setContents(contents);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(freeTextAnnotation);
    }

    public void createMarkup(java.awt.Rectangle rect, String contents, int type, int page, java.awt.Color clr) {
        Annotation annotation = null;
        Page page2 = this.getDocument().getPages().get_Item(page);
        Rectangle rectangle = Rectangle.fromRect(rect);
        switch (type) {
            case 0: {
                annotation = new HighlightAnnotation(page2, rectangle);
                break;
            }
            case 1: {
                annotation = new UnderlineAnnotation(page2, rectangle);
                break;
            }
            case 2: {
                annotation = new StrikeOutAnnotation(page2, rectangle);
                break;
            }
            case 3: {
                annotation = new SquigglyAnnotation(page2, rectangle);
                break;
            }
        }
        annotation.setContents(contents);
        annotation.setColor(Color.fromRgb(clr));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(annotation);
    }

    public void createPopup(java.awt.Rectangle rect, String contents, boolean open, int page) {
        this.lt();
        PopupAnnotation popupAnnotation = new PopupAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect));
        popupAnnotation.setContents(contents);
        popupAnnotation.setOpen(open);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(popupAnnotation);
    }

    public void createFileAttachment(java.awt.Rectangle rect, String contents, String filePath, int page, String name) {
        this.lt();
        FileAttachmentAnnotation fileAttachmentAnnotation = new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), new FileSpecification(filePath));
        fileAttachmentAnnotation.setContents(contents);
        fileAttachmentAnnotation.setIcon(FileIconConverter.toEnum(name));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(fileAttachmentAnnotation);
    }

    void lI(java.awt.Rectangle rectangle, String string, String string2, int n, String string3, double d) {
        this.lt();
        FileAttachmentAnnotation fileAttachmentAnnotation = new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(n), Rectangle.fromRect(rectangle), new FileSpecification(string2));
        fileAttachmentAnnotation.setContents(string);
        fileAttachmentAnnotation.setOpacity(d);
        fileAttachmentAnnotation.setIcon(FileIconConverter.toEnum(string3));
        this.getDocument().getPages().get_Item(n).getAnnotations().add(fileAttachmentAnnotation);
    }

    public void createFileAttachment(java.awt.Rectangle rect, String contents, InputStream attachmentStream, String attachmentName, int page, String name) {
        this.lI(rect, contents, Stream.fromJava(attachmentStream), attachmentName, page, name);
    }

    private void lI(java.awt.Rectangle rectangle, String string, Stream stream, String string2, int n, String string3) {
        this.lt();
        FileAttachmentAnnotation fileAttachmentAnnotation = new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(n), Rectangle.fromRect(rectangle), new FileSpecification(stream, string2));
        fileAttachmentAnnotation.setContents(string);
        fileAttachmentAnnotation.setIcon(FileIconConverter.toEnum(string3));
        this.getDocument().getPages().get_Item(n).getAnnotations().add(fileAttachmentAnnotation);
    }

    void lI(java.awt.Rectangle rectangle, String string, Stream stream, String string2, int n, String string3, double d) {
        this.lt();
        FileAttachmentAnnotation fileAttachmentAnnotation = new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(n), Rectangle.fromRect(rectangle), new FileSpecification(stream, string2));
        fileAttachmentAnnotation.setContents(string);
        fileAttachmentAnnotation.setOpacity(d);
        fileAttachmentAnnotation.setIcon(FileIconConverter.toEnum(string3));
        this.getDocument().getPages().get_Item(n).getAnnotations().add(fileAttachmentAnnotation);
    }

    public void addDocumentAttachment(String fileAttachmentPath, String description) {
        this.lt();
        FileSpecification fileSpecification = new FileSpecification(fileAttachmentPath, description);
        this.getDocument().getEmbeddedFiles().add(fileSpecification);
    }

    public void addDocumentAttachment(InputStream fileAttachmentStream, String fileAttachmentName, String description) {
        Stream stream = Stream.fromJava(fileAttachmentStream);
        stream.setPosition(0L);
        this.lI(stream, fileAttachmentName, description);
    }

    void lI(Stream stream, String string, String string2) {
        this.lt();
        FileSpecification fileSpecification = new FileSpecification(stream, string, string2);
        this.getDocument().getEmbeddedFiles().add(fileSpecification);
    }

    public void deleteAttachments() {
        this.lt();
        this.getDocument().getEmbeddedFiles().delete();
        AnnotationSelector annotationSelector = new AnnotationSelector(new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(1), Rectangle.getTrivial(), new FileSpecification()));
        for (Page page : this.getDocument().getPages()) {
            page.accept(annotationSelector);
            for (int i = annotationSelector.getSelected().size() - 1; i >= 0; --i) {
                page.getAnnotations().delete((Annotation)((Object)com.aspose.pdf.internal.l90y.lb.lI(annotationSelector.getSelected().get(i), Annotation.class)));
            }
            annotationSelector.getSelected().clear();
        }
    }

    public void createLine(java.awt.Rectangle rect, String contents, float x1, float y1, float x2, float y2, int page, int border, java.awt.Color clr, String borderStyle, int[] dashArray, String[] LEArray) {
        this.lt();
        LineAnnotation lineAnnotation = new LineAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), new Point(x1, y1), new Point(x2, y2));
        lineAnnotation.setContents(contents);
        Border border2 = new Border(lineAnnotation);
        border2.setWidth(border);
        lineAnnotation.setColor(Color.fromRgb(clr));
        border2.setStyle(BorderStyleConverter.toEnum(borderStyle));
        if (dashArray != null && dashArray.length > 0) {
            border2.setDash(new Dash(dashArray[0], dashArray.length > 1 ? dashArray[1] : dashArray[0]));
        }
        if (LEArray != null && LEArray.length > 0) {
            lineAnnotation.setStartingStyle(LineEndingConverter.toEnum(LEArray[0]));
            if (LEArray.length > 1) {
                lineAnnotation.setEndingStyle(LineEndingConverter.toEnum(LEArray[1]));
            }
        }
        lineAnnotation.setBorder(border2);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(lineAnnotation);
    }

    public void createSquareCircle(java.awt.Rectangle rect, String contents, java.awt.Color clr, boolean square, int page, int borderWidth) {
        this.lt();
        CommonFigureAnnotation commonFigureAnnotation = square ? new SquareAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect)) : new CircleAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect));
        commonFigureAnnotation.setContents(contents);
        commonFigureAnnotation.setColor(Color.fromRgb(clr));
        commonFigureAnnotation.setBorder(new Border(commonFigureAnnotation));
        commonFigureAnnotation.getBorder().setWidth(borderWidth);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(commonFigureAnnotation);
    }

    public void drawCurve(LineInfo lineInfo, int page, java.awt.Rectangle annotRect, String annotContents) {
        this.lt();
        ArrayList<Point[]> arrayList = new ArrayList<Point[]>();
        int n = lineInfo.getVerticeCoordinate().length / 2;
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(lineInfo.getVerticeCoordinate()[2 * i], lineInfo.getVerticeCoordinate()[2 * i + 1]);
        }
        arrayList.add(pointArray);
        InkAnnotation inkAnnotation = new InkAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect), arrayList);
        inkAnnotation.setBorder(new Border(inkAnnotation));
        if (lineInfo.getVisibility()) {
            inkAnnotation.getBorder().setWidth(lineInfo.getLineWidth());
            inkAnnotation.getBorder().setStyle(lineInfo.getBorderStyle());
            if (lineInfo.getLineDashPattern() != null && lineInfo.getLineDashPattern().length != 0) {
                inkAnnotation.getBorder().setDash(new Dash(lineInfo.getLineDashPattern()[0], lineInfo.getLineDashPattern().length > 1 ? lineInfo.getLineDashPattern()[1] : lineInfo.getLineDashPattern()[0]));
            }
            inkAnnotation.setColor(Color.fromRgb(lineInfo.getLineColor()));
        } else {
            inkAnnotation.getBorder().setWidth(0);
        }
        inkAnnotation.setContents(annotContents);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(inkAnnotation);
    }

    public void createPolygon(LineInfo lineInfo, int page, java.awt.Rectangle annotRect, String annotContents) {
        this.lt();
        int n = lineInfo.getVerticeCoordinate().length / 2;
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(lineInfo.getVerticeCoordinate()[2 * i], lineInfo.getVerticeCoordinate()[2 * i + 1]);
        }
        PolygonAnnotation polygonAnnotation = new PolygonAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect), pointArray);
        if (lineInfo.getVisibility()) {
            Border border = new Border(polygonAnnotation);
            border.setWidth(lineInfo.getLineWidth());
            border.setStyle(lineInfo.getBorderStyle());
            if (lineInfo.getLineDashPattern() != null && lineInfo.getLineDashPattern().length != 0) {
                border.setDash(new Dash(lineInfo.getLineDashPattern()[0], lineInfo.getLineDashPattern().length > 1 ? lineInfo.getLineDashPattern()[1] : lineInfo.getLineDashPattern()[0]));
            }
            polygonAnnotation.setBorder(border);
            polygonAnnotation.setColor(Color.fromRgb(lineInfo.getLineColor()));
        }
        polygonAnnotation.setContents(annotContents);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(polygonAnnotation);
    }

    public void createPolyLine(LineInfo lineInfo, int page, java.awt.Rectangle annotRect, String annotContents) {
        this.lt();
        int n = lineInfo.getVerticeCoordinate().length / 2;
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(lineInfo.getVerticeCoordinate()[2 * i], lineInfo.getVerticeCoordinate()[2 * i + 1]);
        }
        PolylineAnnotation polylineAnnotation = new PolylineAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect), pointArray);
        if (lineInfo.getVisibility()) {
            Border border = new Border(polylineAnnotation);
            border.setWidth(lineInfo.getLineWidth());
            border.setStyle(lineInfo.getBorderStyle());
            if (lineInfo.getLineDashPattern() != null && lineInfo.getLineDashPattern().length != 0) {
                border.setDash(new Dash(lineInfo.getLineDashPattern()[0], lineInfo.getLineDashPattern().length > 1 ? lineInfo.getLineDashPattern()[1] : lineInfo.getLineDashPattern()[0]));
            }
            polylineAnnotation.setBorder(border);
            polylineAnnotation.setColor(Color.fromRgb(lineInfo.getLineColor()));
        }
        polylineAnnotation.setContents(annotContents);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(polylineAnnotation);
    }

    public void createCaret(int page, java.awt.Rectangle annotRect, java.awt.Rectangle caretRect, String symbol, String annotContents, java.awt.Color color) {
        this.lt();
        CaretAnnotation caretAnnotation = new CaretAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(caretRect));
        caretAnnotation.setSymbol(CaretSymbolConverter.toEnum(symbol));
        caretAnnotation.setRect(Rectangle.fromRect(annotRect));
        caretAnnotation.setContents(annotContents);
        caretAnnotation.setColor(Color.fromRgb(color));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(caretAnnotation);
    }

    public void createRubberStamp(int page, java.awt.Rectangle annotRect, String icon, String annotContents, java.awt.Color color) {
        this.lt();
        StampAnnotation stampAnnotation = new StampAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect));
        stampAnnotation.setIcon(StampIconConverter.toEnum(icon));
        stampAnnotation.setContents(annotContents);
        stampAnnotation.setColor(Color.fromRgb(color));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(stampAnnotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRubberStamp(int page, java.awt.Rectangle annotRect, String annotContents, java.awt.Color color, String appearanceFile) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(appearanceFile);
            try {
                this.createRubberStamp(page, annotRect, annotContents, color, fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        catch (Exception exception) {
            lI.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public void createRubberStamp(int page, java.awt.Rectangle annotRect, String annotContents, java.awt.Color color, InputStream appearanceStream) {
        this.lt();
        StampAnnotation stampAnnotation = new StampAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect));
        stampAnnotation.setImage(appearanceStream);
        stampAnnotation.setContents(annotContents);
        stampAnnotation.setColor(Color.fromRgb(color));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(stampAnnotation);
    }

    public void createBookmarksAction(String title, java.awt.Color color, boolean boldFlag, boolean italicFlag, String file, String actionType, String destination) {
        this.lt();
        OutlineItemCollection outlineItemCollection = new OutlineItemCollection(this.getDocument().getOutlines());
        outlineItemCollection.setTitle(title);
        outlineItemCollection.setColor(color);
        outlineItemCollection.setBold(boldFlag);
        outlineItemCollection.setItalic(italicFlag);
        PdfAction pdfAction = null;
        switch (lh.lI(actionType)) {
            case 0: {
                try {
                    int n = l6u.lI(destination);
                    pdfAction = new GoToRemoteAction(file, n);
                }
                catch (RuntimeException runtimeException) {
                    lI.log(Level.INFO, "Exception occur", runtimeException);
                    pdfAction = new GoToRemoteAction(file, 1);
                }
                break;
            }
            case 1: {
                pdfAction = new LaunchAction(file);
                break;
            }
            case 2: {
                try {
                    int n = l6u.lI(destination);
                    Page page = this.getDocument().getPages().get_Item(n);
                    pdfAction = new GoToAction(page);
                    ((GoToAction)pdfAction).setDestination(new FitHExplicitDestination(page, page.getRect().getHeight()));
                }
                catch (RuntimeException runtimeException) {
                    lI.log(Level.INFO, "Exception occur", runtimeException);
                    pdfAction = new GoToAction(this.getDocument().getPages().get_Item(1));
                }
                break;
            }
            case 3: {
                pdfAction = new GoToURIAction(destination);
                break;
            }
        }
        outlineItemCollection.setAction(pdfAction);
        this.getDocument().getOutlines().add(outlineItemCollection);
    }

    public void addDocumentAdditionalAction(String eventType, String code) {
        this.lt();
        JavascriptAction javascriptAction = new JavascriptAction(code);
        switch (lh.lI(eventType)) {
            case 4: {
                this.getDocument().setOpenAction(javascriptAction);
                break;
            }
            case 5: {
                this.getDocument().getActions().setBeforeClosing(javascriptAction);
                break;
            }
            case 6: {
                this.getDocument().getActions().setBeforeSaving(javascriptAction);
                break;
            }
            case 7: {
                this.getDocument().getActions().setAfterSaving(javascriptAction);
                break;
            }
            case 8: {
                this.getDocument().getActions().setBeforePrinting(javascriptAction);
                break;
            }
            case 9: {
                this.getDocument().getActions().setAfterPrinting(javascriptAction);
                break;
            }
        }
    }

    public void removeDocumentOpenAction() {
        this.lt();
        this.getDocument().setOpenAction(null);
    }

    public void changeViewerPreference(int viewerAttribution) {
        this.lt();
        switch (viewerAttribution) {
            case 0x100000: {
                this.getDocument().setPageMode(4);
                break;
            }
            case 262144: {
                this.getDocument().setDisplayDocTitle(true);
                break;
            }
            case 524288: {
                this.getDocument().setPageMode(3);
                this.getDocument().setNonFullScreenPageMode(4);
                break;
            }
            case 1: {
                this.getDocument().setPageLayout(0);
                break;
            }
            case 2: {
                this.getDocument().setPageLayout(1);
                break;
            }
            case 4: {
                this.getDocument().setPageLayout(2);
                break;
            }
            case 8: {
                this.getDocument().setPageLayout(3);
                break;
            }
            case 16: {
                this.getDocument().setPageMode(0);
                break;
            }
            case 32: {
                this.getDocument().setPageMode(1);
                break;
            }
            case 64: {
                this.getDocument().setPageMode(2);
                break;
            }
            case 128: {
                this.getDocument().setPageMode(3);
                break;
            }
            case 0x200000: {
                this.getDocument().setPageMode(5);
                break;
            }
            case 256: {
                this.getDocument().setHideToolBar(true);
                break;
            }
            case 512: {
                this.getDocument().setHideMenubar(true);
                break;
            }
            case 1024: {
                this.getDocument().setHideWindowUI(true);
                break;
            }
            case 2048: {
                this.getDocument().setFitWindow(true);
                break;
            }
            case 4096: {
                this.getDocument().setCenterWindow(true);
                break;
            }
            case 8192: {
                this.getDocument().setNonFullScreenPageMode(0);
                break;
            }
            case 16384: {
                this.getDocument().setNonFullScreenPageMode(1);
                break;
            }
            case 32768: {
                this.getDocument().setNonFullScreenPageMode(2);
                break;
            }
            case 65536: {
                this.getDocument().setDirection(0);
                break;
            }
            case 131072: {
                this.getDocument().setDirection(1);
                break;
            }
            case 0x400000: {
                this.getDocument().setDuplex(0);
                break;
            }
            case 0x800000: {
                this.getDocument().setDuplex(1);
                break;
            }
            case 0x1000000: {
                this.getDocument().setDuplex(2);
                break;
            }
        }
    }

    public int getViewerPreference() {
        this.lt();
        int n = 0;
        if (this.getDocument().isHideToolBar()) {
            n |= 0x100;
        }
        if (this.getDocument().isHideMenubar()) {
            n |= 0x200;
        }
        if (this.getDocument().isHideWindowUI()) {
            n |= 0x400;
        }
        if (this.getDocument().isFitWindow()) {
            n |= 0x800;
        }
        if (this.getDocument().isCenterWindow()) {
            n |= 0x1000;
        }
        if (this.getDocument().isDisplayDocTitle()) {
            n |= 0x40000;
        }
        switch (this.getDocument().getDirection()) {
            case 0: {
                n |= 0x10000;
                break;
            }
            case 1: {
                n |= 0x20000;
                break;
            }
        }
        switch (this.getDocument().getPageMode()) {
            case 3: {
                n |= 0x80;
                break;
            }
            case 5: {
                n |= 0x200000;
                break;
            }
            case 0: {
                n |= 0x10;
                break;
            }
            case 4: {
                n |= 0x100000;
                break;
            }
            case 1: {
                n |= 0x20;
                break;
            }
            case 2: {
                n |= 0x40;
                break;
            }
        }
        switch (this.getDocument().getNonFullScreenPageMode()) {
            case 0: {
                n |= 0x2000;
                break;
            }
            case 4: {
                n |= 0x80000;
                break;
            }
            case 1: {
                n |= 0x4000;
                break;
            }
            case 2: {
                n |= 0x8000;
                break;
            }
        }
        switch (this.getDocument().getPageLayout()) {
            case 1: {
                n |= 2;
                break;
            }
            case 0: {
                n |= 1;
                break;
            }
            case 2: {
                n |= 4;
                break;
            }
            case 3: {
                n |= 8;
                break;
            }
        }
        switch (this.getDocument().getDuplex()) {
            case 0: {
                n |= 0x400000;
                break;
            }
            case 1: {
                n |= 0x800000;
                break;
            }
            case 2: {
                n |= 0x1000000;
                break;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceImage(int pageNumber, int index, String imageFile) {
        this.lt();
        l0t<XImage> l0t2 = new l0t<XImage>();
        PdfExtractor pdfExtractor = new PdfExtractor();
        pdfExtractor.lj(l0t2, this.getDocument(), pageNumber, pageNumber);
        if (index > 0 && index <= l0t2.size()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(imageFile);
                try {
                    ((XImage)((Object)com.aspose.pdf.internal.l90y.lb.lI(l0t2.get_Item(index - 1), XImage.class))).replace(fileInputStream);
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        lI.log(Level.INFO, "Exception occur", iOException);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                lI.log(Level.INFO, "Exception occur", fileNotFoundException);
                throw new RuntimeException(fileNotFoundException);
            }
        }
    }

    public void deleteImage(int pageNumber, int[] index) {
        this.lt();
        if (index == null || index.length == 0) {
            throw new lh("Invalid index contents");
        }
        ly.lb(ly.lj((Object)index));
        l0t<XImage> l0t2 = new l0t<XImage>();
        PdfExtractor pdfExtractor = new PdfExtractor();
        pdfExtractor.lj(l0t2, this.getDocument(), pageNumber, pageNumber);
        for (int i = index.length - 1; i >= 0; --i) {
            if (index[i] - 1 < 0 || index[i] > l0t2.size()) continue;
            ((XImage)((Object)com.aspose.pdf.internal.l90y.lb.lI(l0t2.get_Item(index[i] - 1), XImage.class))).delete();
        }
    }

    public void deleteImage() {
        this.lt();
        for (Page page : this.getDocument().getPages()) {
            page.getResources().getImages().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceText(String srcString, int thePage, String destString, TextState textState) {
        block22: {
            block23: {
                block21: {
                    this.lt();
                    TextFragmentAbsorber textFragmentAbsorber = new TextFragmentAbsorber(srcString, this.lf, this.lj);
                    if (this.lt != null) {
                        textFragmentAbsorber.setTextReplaceOptions(this.lt);
                    }
                    if (thePage == 0) {
                        textFragmentAbsorber.visit(this.getDocument());
                    } else if (thePage <= this.getDocument().getPages().size()) {
                        textFragmentAbsorber.visit(this.getDocument().getPages().get_Item(thePage));
                    }
                    if (textFragmentAbsorber.getTextFragments() == null || textFragmentAbsorber.getTextFragments().size() <= 0) break block22;
                    if (thePage == 0) {
                        for (Object object : this.getDocument().getPages()) {
                            ((Page)object).getContents().suppressUpdate();
                        }
                    } else {
                        this.getDocument().getPages().get_Item(thePage).getContents().suppressUpdate();
                    }
                    try {
                        if (this.lt != null) {
                            switch (this.lt.getReplaceScope()) {
                                case 0: {
                                    textFragmentAbsorber.getTextFragments().get_Item(1).setText(destString);
                                    if (textState == null) break;
                                    textFragmentAbsorber.getTextFragments().get_Item(1).getTextState().applyChangesFrom(textState);
                                    break;
                                }
                                case 1: {
                                    for (Object object : textFragmentAbsorber.getTextFragments()) {
                                        ((TextFragment)object).setText(destString);
                                        if (textState == null) continue;
                                        ((TextFragment)object).getTextState().applyChangesFrom(textState);
                                    }
                                    break;
                                }
                            }
                        } else {
                            textFragmentAbsorber.getTextFragments().get_Item(1).setText(destString);
                            if (textState != null) {
                                textFragmentAbsorber.getTextFragments().get_Item(1).getTextState().applyChangesFrom(textState);
                            }
                        }
                        if (thePage != 0) break block21;
                    }
                    catch (Throwable throwable) {
                        if (thePage == 0) {
                            for (Page page : this.getDocument().getPages()) {
                                page.getContents().resumeUpdate();
                            }
                        } else {
                            this.getDocument().getPages().get_Item(thePage).getContents().resumeUpdate();
                        }
                        throw throwable;
                    }
                    for (Object object : this.getDocument().getPages()) {
                        ((Page)object).getContents().resumeUpdate();
                    }
                    break block23;
                }
                this.getDocument().getPages().get_Item(thePage).getContents().resumeUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean replaceText(String srcString, String destString) {
        return this.replaceText(srcString, 0, destString);
    }

    public boolean replaceText(String srcString, int thePage, String destString) {
        return this.replaceText(srcString, thePage, destString, new TextState());
    }

    public boolean replaceText(String srcString, String destString, TextState textState) {
        return this.replaceText(srcString, 0, destString, textState);
    }

    public void createMovie(java.awt.Rectangle rect, String filePath, int page) {
        this.lt();
        MovieAnnotation movieAnnotation = new MovieAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), filePath);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(movieAnnotation);
    }

    public void createSound(java.awt.Rectangle rect, String filePath, String name, int page, String rate) {
        this.lt();
        SoundAnnotation soundAnnotation = new SoundAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), filePath);
        soundAnnotation.setIcon(SoundIconConverter.toEnum(name));
        soundAnnotation.getSoundData().setRate(l6u.lI(rate));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(soundAnnotation);
    }

    public void deleteStamp(int pageNumber, int[] index) {
        this.lI(pageNumber, index);
    }

    public void deleteStampByIds(int[] stampIds) {
        this.lt();
        for (int n : stampIds) {
            for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
                this.deleteStampById(i, n);
            }
        }
    }

    public void deleteStampByIds(int pageNumber, int[] stampIds) {
        this.lt();
        for (int n : stampIds) {
            this.deleteStampById(pageNumber, n);
        }
    }

    public void deleteStampById(int pageNumber, int stampId) {
        if (stampId == 0) {
            return;
        }
        lI[] lIArray = this.lI(pageNumber);
        if (lIArray != null) {
            for (lI lI2 : lIArray) {
                if (lI2.le() != stampId) continue;
                lI2.lh();
                break;
            }
        }
    }

    public void hideStampById(int pageNumber, int stampId) {
        if (stampId == 0) {
            return;
        }
        lI[] lIArray = this.lI(pageNumber);
        if (lIArray != null) {
            for (lI lI2 : lIArray) {
                if (lI2.le() != stampId) continue;
                lI2.lk();
                break;
            }
        }
    }

    public void showStampById(int pageNumber, int stampId) {
        if (stampId == 0) {
            return;
        }
        lI[] lIArray = this.lI(pageNumber);
        if (lIArray != null) {
            for (lI lI2 : lIArray) {
                if (lI2.le() != stampId) continue;
                lI2.lv();
                break;
            }
        }
    }

    public void moveStampById(int pageNumber, int stampId, double x, double y) {
        if (stampId == 0) {
            return;
        }
        lI[] lIArray = this.lI(pageNumber);
        if (lIArray != null) {
            for (lI lI2 : lIArray) {
                if (lI2.le() != stampId) continue;
                lI2.lI(x, y);
                break;
            }
        }
    }

    public void moveStamp(int pageNumber, int stampIndex, double x, double y) {
        lI[] lIArray = this.lI(pageNumber);
        if (stampIndex > lIArray.length || stampIndex < 0) {
            throw new lh(l10l.lI(new Object[]{"Invalid stamp index. Stamp index must be in range (0, ", lIArray.length, ")"}));
        }
        lI lI2 = lIArray[stampIndex];
        lI2.lI(x, y);
    }

    public void deleteStampById(int stampId) {
        this.lt();
        for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
            this.deleteStampById(i, stampId);
        }
    }

    public PdfContentEditor() {
        this(null);
    }

    public PdfContentEditor(IDocument document) {
        super(document);
        this.ld.lI.lf(this.le);
    }

    public void createLocalLink(java.awt.Rectangle rect, int desPage, int originalPage) {
        this.createLocalLink(rect, desPage, originalPage, com.aspose.pdf.internal.l68j.ld.lt.lI());
    }

    private boolean lI(OperatorCollection operatorCollection, Operator operator) {
        if (operator.getIndex() < 4) {
            return false;
        }
        if (operator.getIndex() >= operatorCollection.size()) {
            return false;
        }
        return operatorCollection.get_Item(operator.getIndex() - 3) instanceof GSave && operatorCollection.get_Item(operator.getIndex() - 2) instanceof GS && operatorCollection.get_Item(operator.getIndex() - 1) instanceof ConcatenateMatrix && operator instanceof Do && operatorCollection.get_Item(operator.getIndex() + 1) instanceof GRestore || operator instanceof BDC && operatorCollection.get_Item(operator.getIndex() + 1) instanceof EMC && operatorCollection.get_Item(operator.getIndex() + 2) instanceof GRestore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lI(OperatorCollection operatorCollection, List<Object> list) {
        Document.startOperation();
        try {
            for (Object object : list) {
                if (!this.lI(operatorCollection, (Operator)object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Document.endOperation();
        }
    }

    public boolean replaceText(String srcString, String destString, int fontSize) {
        return this.replaceText(srcString, destString, new TextState(fontSize));
    }

    private void lI(OperatorCollection operatorCollection, Resources resources, l0t<lI> l0t2, Object object) {
        this.lI(null, operatorCollection, resources, l0t2, object);
    }

    private void lI(Matrix matrix, OperatorCollection operatorCollection, Resources resources, l0t<lI> l0t2, Object object) {
        l2l<Matrix> l2l2 = new l2l<Matrix>();
        if (matrix == null) {
            matrix = new Matrix();
        }
        Matrix matrix2 = new Matrix();
        for (Operator operator : operatorCollection) {
            com.aspose.pdf.internal.l5n.lh lh2;
            if (operator instanceof GSave) {
                l2l2.lf(new Matrix(matrix));
            }
            if (operator instanceof GRestore) {
                matrix = (Matrix)l2l2.lb();
            }
            if (operator instanceof ConcatenateMatrix) {
                matrix2 = matrix;
                matrix = ((ConcatenateMatrix)((Object)com.aspose.pdf.internal.l90y.lb.lI(operator, ConcatenateMatrix.class))).getMatrix().multiply(matrix);
            }
            if (!(operator instanceof Do) && (!(operator instanceof BDC) || !lu.equals(((BDC)((Object)com.aspose.pdf.internal.l90y.lb.lI(operator, BDC.class))).getTag()))) continue;
            XForm xForm = null;
            XImage xImage = null;
            String string = null;
            boolean bl = true;
            if (operator instanceof Do) {
                string = ((Do)((Object)com.aspose.pdf.internal.l90y.lb.lI(operator, Do.class))).getName();
            }
            if (operator instanceof BDC) {
                lh2 = ((BDC)((Object)com.aspose.pdf.internal.l90y.lb.lI(operator, BDC.class))).getPropertiesDictionary();
                if (lh2.lt("Name") && lh2.lf("Name").l5if() != null) {
                    string = lh2.lf("Name").l5if().toString();
                }
                bl = false;
            }
            if (!resources.getEngineDict().lf("XObject").l5l().lt(string)) continue;
            lh2 = resources.getEngineDict().lf("XObject").l5l().lf(string).l5l();
            String string2 = null;
            if (lh2.lf("Subtype").l5if() != null) {
                string2 = lh2.lf("Subtype").l5if().toString();
            } else if (lh2.lf("Subtype").l4f() != null) {
                string2 = lh2.lf("Subtype").l4f().lu();
            }
            if ("Form".equals(string2)) {
                xForm = resources.getForms().get_Item(string);
            } else if ("Image".equals(string2)) {
                xImage = resources.getImages().get_Item(string);
            }
            if (this.lI(operatorCollection, operator) || lh2.lt("StampId")) {
                if (xForm != null) {
                    Rectangle rectangle = xForm.getRectangle();
                    rectangle = matrix.transform(rectangle);
                    l0t2.addItem(new lI(this, xForm, object, string, rectangle, matrix2, bl));
                    continue;
                }
                if (xImage == null) continue;
                l0t2.addItem(new lI(this, xImage, object, string, matrix.transform(new Rectangle(0.0, 0.0, 1.0, 1.0)), matrix2, bl));
                continue;
            }
            if (xForm == null) continue;
            this.lI(matrix, xForm.getContents(), xForm.getResources(), l0t2, xForm);
        }
    }

    private void lf(OperatorCollection operatorCollection, Resources resources, l0t<lI> l0t2, Object object) {
        if (resources.getEngineDict().lt("XObject")) {
            lf.lf.lI<String, com.aspose.pdf.internal.l5n.l0t> lI2 = resources.getEngineDict().lf("XObject").l5l().l1j().lI();
            while (lI2.hasNext()) {
                String string = (String)lI2.next();
                com.aspose.pdf.internal.l5n.lh lh2 = resources.getEngineDict().lf("XObject").l5l().lf(string).l5l();
                List<Object> list = Page.findReferences(operatorCollection, string);
                XForm xForm = null;
                XImage xImage = null;
                if (list.size() <= 0) continue;
                String string2 = null;
                if (lh2.lf("Subtype").l5if() != null) {
                    string2 = lh2.lf("Subtype").l5if().toString();
                } else if (lh2.lf("Subtype").l4f() != null) {
                    string2 = lh2.lf("Subtype").l4f().lu();
                }
                if ("Form".equals(string2)) {
                    xForm = resources.getForms().get_Item(string);
                } else if ("Image".equals(string2)) {
                    xImage = resources.getImages().get_Item(string);
                }
                if (this.lI(operatorCollection, list) || lh2.lt("StampId")) {
                    if (xForm != null) {
                        l0t2.addItem(new lI(this, xForm, object, string, null, new Matrix(), true));
                    } else if (xImage != null) {
                        l0t2.addItem(new lI(this, xImage, object, string, null, new Matrix(), true));
                    }
                }
                if (xForm == null) continue;
                this.lI(xForm.getContents(), xForm.getResources(), l0t2, xForm);
            }
        }
    }

    private lI[] lI(int n) {
        Page page;
        lI[] lIArray;
        if (n > this.getDocument().getPages().size()) {
            n = this.getDocument().getPages().size();
        }
        if ((lIArray = com.aspose.pdf.internal.l90y.lb.lj((Object)this.lb.lI(n), lI[].class)) == null && (page = this.getDocument().getPages().get_Item(n)) != null) {
            l0t<lI> l0t2 = new l0t<lI>();
            this.lI(page.getContents(), page.getResources(), l0t2, page);
            lIArray = l0t2.toArray((lI[])new lI[0]);
        }
        this.lb.lI(n, lIArray);
        return lIArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StampInfo[] getStamps(int pageNumber) {
        Document.startOperation();
        try {
            this.lt();
            StampInfo[] stampInfoArray = null;
            lI[] lIArray = this.lI(pageNumber);
            if (lIArray != null) {
                stampInfoArray = new StampInfo[lIArray.length];
                for (int i = 0; i < lIArray.length; ++i) {
                    if (lIArray[i].lu() != null) {
                        stampInfoArray[i] = new StampInfo(lIArray[i].le(), lIArray[i].lb(), i, lIArray[i].lf(), lIArray[i].lu(), lIArray[i].lj());
                        continue;
                    }
                    lf lf2 = null;
                    if (lIArray[i].ld() != null) {
                        lf2 = lIArray[i].ld().getImage();
                    }
                    stampInfoArray[i] = new StampInfo(lIArray[i].le(), lIArray[i].lb(), i, lIArray[i].lf(), lf2, lIArray[i].lj());
                }
            }
            if (stampInfoArray == null) {
                stampInfoArray = new StampInfo[]{};
            }
            StampInfo[] stampInfoArray2 = stampInfoArray;
            return stampInfoArray2;
        }
        finally {
            Document.endOperation();
        }
    }

    private boolean lI(int n, int[] nArray) {
        this.lt();
        boolean bl = false;
        lI[] lIArray = this.lI(n);
        if (lIArray != null) {
            for (int n2 : nArray) {
                if (n2 < 0 || n2 >= lIArray.length) continue;
                lI lI2 = lIArray[n2];
                lI2.lh();
            }
            this.lb = new com.aspose.pdf.internal.l1t.lI();
            bl = true;
        }
        return bl;
    }

    private void lf() {
        this.lb = new com.aspose.pdf.internal.l1t.lI();
    }

    @Override
    public void close() {
        super.close();
    }

    boolean lI(l0if l0if2) {
        for (Page page : this.getDocument().getPages()) {
            if (!page.getResources().getEngineDict().lt("XObject")) continue;
            com.aspose.pdf.internal.l5n.lh lh2 = page.getResources().getEngineDict().lf("XObject").l5l();
            lf.lf.lI<String, com.aspose.pdf.internal.l5n.l0t> lI2 = lh2.l1j().lI();
            while (lI2.hasNext()) {
                String string = (String)lI2.next();
                l0if l0if3 = lh2.lf(string).l5u();
                if (l0if3.l3j() != l0if2.l3j()) continue;
                return true;
            }
        }
        return false;
    }

    static {
        lI.setUseParentHandlers(false);
        lh = new com.aspose.pdf.internal.l90y.lh("GoToR", "Launch", "GoTo", "URI", DOCUMENT_OPEN, DOCUMENT_CLOSE, DOCUMENT_WILL_SAVE, DOCUMENT_SAVED, DOCUMENT_WILL_PRINT, DOCUMENT_PRINTED);
    }

    private static class lI {
        private Page lI;
        private XForm lf;
        private String lj;
        private Matrix lt;
        private PdfContentEditor lb;
        private Rectangle ld;
        private boolean lu;
        private Object le;

        public String lI() {
            return this.lj;
        }

        public Rectangle lf() {
            if (this.ld == null) {
                this.ld = this.l0if();
            }
            return this.ld;
        }

        public boolean lj() {
            return this.lu;
        }

        public com.aspose.pdf.internal.l5n.lh lt() {
            if (this.ld() != null) {
                return this.ld().getEngineImg().l5l();
            }
            if (this.lu() != null) {
                return this.lu().getEngineObj().l5l();
            }
            return null;
        }

        public int lb() {
            if (this.ld() != null) {
                return 1;
            }
            if (this.lu() != null) {
                return 0;
            }
            return 0;
        }

        public XImage ld() {
            if (this.le instanceof XImage) {
                return (XImage)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.le, XImage.class));
            }
            return null;
        }

        public XForm lu() {
            if (this.le instanceof XForm) {
                return (XForm)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.le, XForm.class));
            }
            return null;
        }

        public lI(PdfContentEditor pdfContentEditor, XImage xImage, Object object, String string, Rectangle rectangle, Matrix matrix, boolean bl) {
            this.le = xImage;
            if (object instanceof Page) {
                this.lI = (Page)((Object)com.aspose.pdf.internal.l90y.lb.lI(object, Page.class));
            } else if (object instanceof XForm) {
                this.lf = (XForm)((Object)com.aspose.pdf.internal.l90y.lb.lI(object, XForm.class));
            }
            this.lj = string;
            this.lb = pdfContentEditor;
            this.ld = rectangle;
            this.lt = matrix;
            this.lu = bl;
        }

        public lI(PdfContentEditor pdfContentEditor, XForm xForm, Object object, String string, Rectangle rectangle, Matrix matrix, boolean bl) {
            this.le = xForm;
            if (object instanceof Page) {
                this.lI = (Page)((Object)com.aspose.pdf.internal.l90y.lb.lI(object, Page.class));
            } else if (object instanceof XForm) {
                this.lf = (XForm)((Object)com.aspose.pdf.internal.l90y.lb.lI(object, XForm.class));
            }
            this.lj = string;
            this.lb = pdfContentEditor;
            this.ld = rectangle;
            this.lt = matrix;
            this.lu = bl;
        }

        public int le() {
            int n = 0;
            if (this.lt() != null && this.lt().lt("StampId")) {
                n = this.lt().lf("StampId").l4n() ? this.lt().lf("StampId").l5h().lf() : 0;
            }
            return n;
        }

        private Rectangle lI(Matrix matrix) {
            Rectangle rectangle = null;
            if (this.le instanceof XForm) {
                rectangle = matrix.transform(((XForm)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.le, XForm.class))).getRectangle());
            } else if (this.le instanceof XImage) {
                rectangle = new Rectangle(0.0, 0.0, 1.0, 1.0);
                rectangle = matrix.transform(rectangle);
            }
            return rectangle;
        }

        private OperatorCollection lc() {
            if (this.lI != null) {
                return this.lI.getContents();
            }
            if (this.lf != null) {
                return this.lf.getContents();
            }
            return null;
        }

        private Resources ly() {
            if (this.lI != null) {
                return this.lI.getResources();
            }
            if (this.lf != null) {
                return this.lf.getResources();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle l0if() {
            Document.startOperation();
            try {
                Rectangle rectangle = null;
                l2l<Matrix> l2l2 = new l2l<Matrix>();
                Matrix matrix = new Matrix();
                for (Operator operator : this.lc()) {
                    if (operator instanceof GSave) {
                        l2l2.lf(new Matrix(matrix));
                    }
                    if (operator instanceof GRestore) {
                        matrix = (Matrix)l2l2.lb();
                    }
                    if (operator instanceof ConcatenateMatrix) {
                        matrix = ((ConcatenateMatrix)((Object)com.aspose.pdf.internal.l90y.lb.lI(operator, ConcatenateMatrix.class))).getMatrix().multiply(matrix);
                    }
                    if (!(operator instanceof Do) || !l10l.lb(((Do)((Object)com.aspose.pdf.internal.l90y.lb.lI(operator, Do.class))).getName(), this.lI())) continue;
                    rectangle = this.lI(matrix);
                    break;
                }
                Iterator iterator = rectangle;
                return iterator;
            }
            finally {
                Document.endOperation();
            }
        }

        public boolean lI(double d, double d2) {
            ConcatenateMatrix concatenateMatrix;
            Object object;
            boolean bl = false;
            int n = -1;
            OperatorCollection operatorCollection = this.lc();
            for (int i = 1; i <= operatorCollection.size(); ++i) {
                object = operatorCollection.get_Item(i);
                if (!(object instanceof Do) || !l10l.lb(((Do)((Object)com.aspose.pdf.internal.l90y.lb.lI(object, Do.class))).getName(), this.lI())) continue;
                n = i;
                break;
            }
            if (n != -1 && (concatenateMatrix = (ConcatenateMatrix)((Object)com.aspose.pdf.internal.l90y.lb.lI(operatorCollection.get_Item(n - 1), ConcatenateMatrix.class))) != null) {
                object = new Matrix(this.lt.getA(), this.lt.getB(), this.lt.getC(), this.lt.getD(), 0.0, 0.0);
                object = ((Matrix)object).reverse();
                Point point = new Point(d - this.lf().getLLX(), d2 - this.lf().getLLY());
                point = ((Matrix)object).transform(point);
                ConcatenateMatrix concatenateMatrix2 = new ConcatenateMatrix(concatenateMatrix.getMatrix().getA(), concatenateMatrix.getMatrix().getB(), concatenateMatrix.getMatrix().getC(), concatenateMatrix.getMatrix().getD(), concatenateMatrix.getMatrix().getE() + point.getX(), concatenateMatrix.getMatrix().getF() + point.getY());
                operatorCollection.set_Item(n - 1, concatenateMatrix2);
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean lI(boolean bl) {
            boolean bl2 = false;
            Document.startOperation();
            try {
                Resources resources = this.ly();
                if (this.lI() != null) {
                    Page.removeObjectReferences(this.lc(), this.lI());
                }
                if (resources.isCommonResource() || !bl) {
                    bl2 = true;
                } else if (this.lI() != null) {
                    if (this.lu() != null) {
                        resources.getForms().delete(this.lI());
                        bl2 = true;
                    } else if (this.ld() != null) {
                        com.aspose.pdf.internal.l5n.lh lh2 = resources.getEngineDict().lf("XObject").l5l();
                        l0if l0if2 = null;
                        if (lh2 != null) {
                            l0if2 = lh2.lf(this.lI()).l5u();
                        }
                        resources.getImages().delete(this.lI());
                        if (l0if2 != null && !this.lb.lI(l0if2)) {
                            lh2.l5k().lj(l0if2);
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    this.lb.lf();
                }
            }
            finally {
                Document.endOperation();
            }
            return bl2;
        }

        public boolean lh() {
            return this.lI(true);
        }

        public boolean lk() {
            Object object;
            OperatorCollection operatorCollection = this.lc();
            int n = -1;
            for (int i = 1; i <= operatorCollection.size(); ++i) {
                object = operatorCollection.get_Item(i);
                if (!(object instanceof Do) || !l10l.lb(((Do)((Object)com.aspose.pdf.internal.l90y.lb.lI(object, Do.class))).getName(), this.lI())) continue;
                n = i;
                break;
            }
            if (n != -1) {
                operatorCollection.delete(n);
                l0t<Operator> l0t2 = new l0t<Operator>();
                object = new l1l((l0h)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.lI.EnginePage, l0h.class)));
                object.lf("Name", (com.aspose.pdf.internal.l5n.l0t)new l1v(this.lI()));
                l0t2.addItem(new BDC(PdfContentEditor.lu, (com.aspose.pdf.internal.l5n.lh)object));
                l0t2.addItem(new EMC());
                operatorCollection.insert(n, l0t2);
            }
            return n != -1;
        }

        public boolean lv() {
            OperatorCollection operatorCollection = this.lc();
            int n = -1;
            for (int i = 1; i <= operatorCollection.size(); ++i) {
                com.aspose.pdf.internal.l5n.lh lh2;
                Operator operator = operatorCollection.get_Item(i);
                if (!(operator instanceof BDC) || !l10l.lb(((BDC)((Object)com.aspose.pdf.internal.l90y.lb.lI(operator, BDC.class))).getTag(), PdfContentEditor.lu) || (lh2 = ((BDC)((Object)com.aspose.pdf.internal.l90y.lb.lI(operator, BDC.class))).getPropertiesDictionary()) == null || !lh2.lt("Name") || lh2.lf("Name").l5if() == null || !l10l.lb(lh2.lf("Name").l5if().toString(), this.lI())) continue;
                n = i;
                break;
            }
            if (n != -1) {
                operatorCollection.delete(n);
                if (n <= operatorCollection.size() && operatorCollection.get_Item(n) instanceof EMC) {
                    operatorCollection.delete(n);
                }
                operatorCollection.insert(n, new Do(this.lI()));
            }
            return n != -1;
        }
    }
}

