/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Border;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.l1t.lI;
import com.aspose.pdf.internal.l5n.l0if;
import com.aspose.pdf.internal.l5n.l0n;
import com.aspose.pdf.internal.l5n.l1u;
import com.aspose.pdf.internal.l5n.l1v;
import com.aspose.pdf.internal.l5n.lb;
import com.aspose.pdf.internal.l5n.ly;
import com.aspose.pdf.internal.l71j.l33if;
import com.aspose.pdf.internal.l71j.l45f;
import com.aspose.pdf.internal.l71j.l48y;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.IO.l2k;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.l4l;
import com.aspose.pdf.internal.ms.System.l6l;
import com.aspose.pdf.operators.GRestore;
import com.aspose.pdf.operators.GS;
import com.aspose.pdf.operators.GSave;
import com.aspose.pdf.operators.LineTo;
import com.aspose.pdf.operators.MoveTo;
import com.aspose.pdf.operators.SetLineCap;
import com.aspose.pdf.operators.SetLineJoin;
import com.aspose.pdf.operators.SetLineWidth;
import com.aspose.pdf.operators.SetRGBColorStroke;
import com.aspose.pdf.operators.Stroke;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class InkAnnotation
extends MarkupAnnotation {
    private static final String ld = "Aspose_CapStyle";
    private int lu = 1;

    @Override
    void lI(l48y l48y2) {
        l48y2.l0t("ink");
        this.lf(l48y2);
        if (this.getEngineDict().lt("BS")) {
            this.getBorder().lI(l48y2);
        }
        if (this.getEngineDict().lt("InkList")) {
            l48y2.l0t("inklist");
            for (Point[] pointArray : this.getInkList()) {
                l48y2.l0t("gesture");
                StringBuilder stringBuilder = new StringBuilder();
                for (Point point : pointArray) {
                    stringBuilder.append(l10l.lI(this.lf, "{0},{1};", point.getX(), point.getY()));
                }
                stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                l48y2.lb(stringBuilder.toString());
                l48y2.lk();
            }
        } else {
            throw new IllegalStateException("Required entry is absent in annotation dictionary");
        }
        l48y2.lk();
        this.lj(l48y2);
        l48y2.lk();
    }

    public int getCapStyle() {
        ly ly2;
        if (this.getEngineDict() == null) {
            return this.lu;
        }
        if (this.getEngineDict().lt(ld) && (ly2 = this.getEngineDict().lf(ld).l5h()) != null) {
            this.lu = ly2.lf();
        }
        return this.lu;
    }

    public void setCapStyle(int value) {
        this.lu = value;
        if (this.getEngineDict() != null) {
            this.getEngineDict().lI(ld, (com.aspose.pdf.internal.l5n.l0t)new l1u(this.lu));
            this.updateAppearances();
        }
    }

    @Override
    void lI(l33if l33if2) {
        l0t<Point[]> l0t2;
        this.lf(l33if2);
        this.setBorder(new Border(this));
        this.getBorder().lI(l33if2);
        lI<String, String> lI2 = XfdfReader.lI(l33if2);
        if (lI2.containsKey("inklist")) {
            l45f l45f2 = new l45f(new l2k((String)lI2.get_Item("inklist")));
            l45f2.ld(true);
            l45f2.le();
            l0t2 = new l0t<Point[]>();
            while (l45f2.le()) {
                if (l45f2.l1if() != 1 || !"gesture".equals(l45f2.l0n())) continue;
                String[] stringArray = l10l.ld(l45f2.ct_(), ';');
                Point[] pointArray = new Point[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = l10l.ld(stringArray[i], ',');
                    pointArray[i] = new Point(l4l.lI(stringArray2[0], (l6l)this.lf), l4l.lI(stringArray2[1], (l6l)this.lf));
                }
                l0t2.addItem(pointArray);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setInkList(l0t2);
        this.lI(lI2);
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    InkAnnotation(l0if engineAnnot, IDocument document) {
        super(engineAnnot, document);
    }

    public InkAnnotation(IDocument document, List<Point[]> inkList) {
        super(document);
        this.getEngineDict().lf("Subtype", (com.aspose.pdf.internal.l5n.l0t)new l1v("Ink"));
        ArrayList<Point[]> arrayList = new ArrayList<Point[]>();
        for (Point[] pointArray : inkList) {
            arrayList.add(pointArray);
        }
        this.setInkList(arrayList);
        Rectangle rectangle = this.l0j();
        this.setWidth(rectangle.getWidth());
        this.setHeight(rectangle.getHeight());
    }

    private Rectangle l0j() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        for (Point[] pointArray : this.getInkList()) {
            for (Point point : pointArray) {
                if (bl) {
                    d3 = d = point.getX();
                    d4 = d2 = point.getY();
                } else {
                    d = l13p.lt(d, point.getX());
                    d2 = l13p.lt(d2, point.getY());
                    d3 = l13p.lj(d3, point.getX());
                    d4 = l13p.lj(d4, point.getY());
                }
                bl = false;
            }
        }
        return new Rectangle(d, d2, d3, d4);
    }

    @Override
    void lf(Page page, Rectangle rectangle) {
        this.setRect(new Rectangle(page.getRect().getLLX(), page.getRect().getLLY(), page.getRect().getURX(), page.getRect().getURY()));
        Rectangle rectangle2 = this.l0j();
        double d = rectangle.getLLX() - rectangle2.getLLX();
        double d2 = rectangle.getLLY() - rectangle2.getLLY();
        l0t<Point[]> l0t2 = new l0t<Point[]>();
        for (Point[] pointArray : this.getInkList()) {
            Point[] pointArray2 = new Point[pointArray.length];
            int n = 0;
            for (Point point : pointArray) {
                pointArray2[n++] = new Point(point.getX() + d, point.getY() + d2);
            }
            l0t2.add(pointArray2);
        }
        this.setInkList(l0t2);
        this.updateAppearances();
    }

    public InkAnnotation(Page page, Rectangle rect, List<Point[]> inkList) {
        super(page, rect);
        this.getEngineDict().lf("Subtype", (com.aspose.pdf.internal.l5n.l0t)new l1v("Ink"));
        this.setInkList(inkList);
    }

    public List<Point[]> getInkList() {
        if (!this.getEngineDict().lt("InkList")) {
            return null;
        }
        ArrayList<Point[]> arrayList = new ArrayList<Point[]>();
        lb lb2 = this.getEngineDict().lj("InkList").l5t();
        for (com.aspose.pdf.internal.l5n.l0t l0t2 : lb2) {
            lb lb3 = l0t2.l5t();
            int n = lb3.lv() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(lb3.lI(2 * i).l5h().lu(), lb3.lI(2 * i + 1).l5h().lu());
            }
            arrayList.add(pointArray);
        }
        return arrayList;
    }

    public void setInkList(List<Point[]> value) {
        if (value != null) {
            l0n l0n2 = new l0n(this.getEngineDict());
            for (Point[] pointArray : value) {
                l0n l0n3 = new l0n(this.getEngineDict());
                for (Point point : pointArray) {
                    l0n3.lI((com.aspose.pdf.internal.l5n.l0t)new l1u(point.getX()));
                    l0n3.lI((com.aspose.pdf.internal.l5n.l0t)new l1u(point.getY()));
                }
                l0n2.lI((com.aspose.pdf.internal.l5n.l0t)l0n3);
            }
            this.getEngineDict().lI("InkList", (com.aspose.pdf.internal.l5n.l0t)l0n2);
        }
    }

    @Override
    boolean le() {
        return true;
    }

    @Override
    List<Operator> lf(Annotation.lI lI2, Annotation annotation) {
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        arrayList.add(new GSave());
        arrayList.add(new SetRGBColorStroke(this.getColor().toRgb()));
        if (this.getEngineDict().lt("BS") && this.getEngineDict().lf("BS").l5l() != null && this.getEngineDict().lf("BS").l5l().lt("W") && this.getEngineDict().lf("BS").l5l().lf("W").l5h() != null) {
            arrayList.add(new SetLineWidth(this.getEngineDict().lf("BS").l5l().lf("W").l5h().lu()));
        }
        if (this.getOpacity() < 1.0) {
            arrayList.add(new GS("opacity"));
        }
        switch (this.getCapStyle()) {
            case 2: {
                arrayList.add(new SetLineCap(1));
                arrayList.add(new SetLineJoin(1));
                break;
            }
        }
        if (this.getInkList() != null) {
            Iterator<Point[]> iterator = this.getInkList().iterator();
            while (iterator.hasNext()) {
                Point[] pointArray;
                Point[] pointArray2 = pointArray = iterator.next();
                boolean bl = true;
                for (Point point : pointArray2) {
                    if (bl) {
                        arrayList.add(new MoveTo(point.getX(), point.getY()));
                    } else {
                        arrayList.add(new LineTo(point.getX(), point.getY()));
                    }
                    bl = false;
                }
            }
        }
        arrayList.add(new Stroke());
        arrayList.add(new GRestore());
        return arrayList;
    }

    @Override
    public int getAnnotationType() {
        return 12;
    }

    @Override
    XForm lI(String string, Annotation annotation) {
        XForm xForm = super.lI(string, annotation);
        Rectangle rectangle = null;
        if (this.getInkList() != null) {
            for (Point[] pointArray : this.getInkList()) {
                for (Point point : pointArray) {
                    if (rectangle == null) {
                        rectangle = new Rectangle(point.getX(), point.getY(), point.getX(), point.getY());
                        continue;
                    }
                    double d = l13p.lt(rectangle.getLLX(), point.getX());
                    double d2 = l13p.lt(rectangle.getLLY(), point.getY());
                    double d3 = l13p.lj(rectangle.getURX(), point.getX());
                    double d4 = l13p.lj(rectangle.getURY(), point.getY());
                    rectangle.setLLX(d);
                    rectangle.setLLY(d2);
                    rectangle.setURX(d3);
                    rectangle.setURY(d4);
                }
            }
            if (this.getBorder() != null) {
                rectangle = new Rectangle(rectangle.getLLX() - (double)this.getBorder().getWidth(), rectangle.getLLY() - (double)this.getBorder().getWidth(), rectangle.getURX() + (double)this.getBorder().getWidth(), rectangle.getURY() + (double)this.getBorder().getWidth());
            }
            rectangle = new Rectangle(l13p.lt(rectangle.getLLX(), this.getRect().getLLX()), l13p.lt(rectangle.getLLY(), this.getRect().getLLY()), l13p.lj(rectangle.getURX(), this.getRect().getURX()), l13p.lj(rectangle.getURY(), this.getRect().getURY()));
            xForm.setBBox(rectangle);
            this.setRect(rectangle);
            xForm.setMatrix(new Matrix(1.0, 0.0, 0.0, 1.0, -rectangle.getLLX(), -rectangle.getLLY()));
        }
        return xForm;
    }
}

