/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.ms.System.Security.Cryptography;

import com.aspose.pdf.internal.l1824.I37;
import com.aspose.pdf.internal.l1824.I3I;
import com.aspose.pdf.internal.ms.System.I01;
import com.aspose.pdf.internal.ms.System.I04;
import com.aspose.pdf.internal.ms.System.I114;
import com.aspose.pdf.internal.ms.System.I14I;
import com.aspose.pdf.internal.ms.System.I17;
import com.aspose.pdf.internal.ms.System.I1I;
import com.aspose.pdf.internal.ms.System.I20l;
import com.aspose.pdf.internal.ms.System.I217;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I33I;
import com.aspose.pdf.internal.ms.System.I57;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I151;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I1l;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I3l;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I84;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.SymmetricAlgorithm;

abstract class SymmetricTransform
implements I84 {
    protected SymmetricAlgorithm l0I;
    protected boolean l01;
    private int lif;
    private byte[] ll;
    private byte[] lI;
    private byte[] l1;
    private byte[] lIF;
    private int llf;
    private int liF;
    private boolean lIf = false;
    private boolean lf;
    private I151 l0if;

    public SymmetricTransform(SymmetricAlgorithm symmAlgo, boolean encryption, byte[] rgbIV) {
        this.l0I = symmAlgo;
        this.l01 = encryption;
        this.lif = this.l0I.getBlockSize() >> 3;
        rgbIV = rgbIV == null ? I37.ll(this.lif) : (byte[])rgbIV.clone();
        if (rgbIV.length < this.lif) {
            String string = I3I.lif("IV is too small ({0} bytes), it should be {1} bytes long.", rgbIV.length, this.lif);
            throw new I3l(string);
        }
        this.ll = new byte[this.lif];
        I57.lif(I1I.lI((Object)rgbIV), 0, I1I.lI((Object)this.ll), 0, Math.min(this.lif, rgbIV.length));
        this.lI = new byte[this.lif];
        this.llf = this.l0I.getFeedbackSize() >> 3;
        if (this.llf != 0) {
            this.liF = this.lif / this.llf;
        }
        this.l1 = new byte[this.lif];
        this.lIF = new byte[this.lif];
    }

    @Override
    public void dispose() {
        this.lif(true);
        I14I.lif(this);
    }

    protected void lif(boolean bl) {
        if (!this.lIf) {
            if (bl) {
                I33I.ll(this.ll, 0, this.lif);
                this.ll = null;
                I33I.ll(this.lI, 0, this.lif);
                this.lI = null;
            }
            this.lIf = true;
        }
    }

    @Override
    public boolean canTransformMultipleBlocks() {
        return true;
    }

    @Override
    public boolean canReuseTransform() {
        return false;
    }

    @Override
    public int getInputBlockSize() {
        return this.lif;
    }

    @Override
    public int getOutputBlockSize() {
        return this.lif;
    }

    protected void lI(byte[] byArray, byte[] byArray2) {
        switch (this.l0I.getMode()) {
            case 2: {
                this.ll(byArray, byArray2);
                break;
            }
            case 1: {
                this.l1(byArray, byArray2);
                break;
            }
            case 4: {
                this.lIF(byArray, byArray2);
                break;
            }
            case 3: {
                this.llf(byArray, byArray2);
                break;
            }
            case 5: {
                this.liF(byArray, byArray2);
                break;
            }
            default: {
                throw new I20l("Unkown CipherMode" + I114.getName(I1l.class, this.l0I.getMode()));
            }
        }
    }

    protected abstract void ll(byte[] var1, byte[] var2);

    protected void l1(byte[] byArray, byte[] byArray2) {
        if (this.l01) {
            for (int i = 0; i < this.lif; ++i) {
                int n = i;
                this.ll[n] = (byte)(this.ll[n] ^ byArray[i]);
            }
            this.ll(this.ll, byArray2);
            I57.lif(I1I.lI((Object)byArray2), 0, I1I.lI((Object)this.ll), 0, this.lif);
        } else {
            I57.lif(I1I.lI((Object)byArray), 0, I1I.lI((Object)this.lI), 0, this.lif);
            this.ll(byArray, byArray2);
            for (int i = 0; i < this.lif; ++i) {
                int n = i;
                byArray2[n] = (byte)(byArray2[n] ^ this.ll[i]);
            }
            I57.lif(I1I.lI((Object)this.lI), 0, I1I.lI((Object)this.ll), 0, this.lif);
        }
    }

    protected void lIF(byte[] byArray, byte[] byArray2) {
        if (this.l01) {
            for (int i = 0; i < this.liF; ++i) {
                this.ll(this.ll, this.lI);
                for (int j = 0; j < this.llf; ++j) {
                    byArray2[j + i] = (byte)(this.lI[j] & 0xFF ^ byArray[j + i] & 0xFF);
                }
                I57.lif(I1I.lI((Object)this.ll), this.llf, I1I.lI((Object)this.ll), 0, this.lif - this.llf);
                I57.lif(I1I.lI((Object)byArray2), i, I1I.lI((Object)this.ll), this.lif - this.llf, this.llf);
            }
        } else {
            for (int i = 0; i < this.liF; ++i) {
                this.l01 = true;
                this.ll(this.ll, this.lI);
                this.l01 = false;
                I57.lif(I1I.lI((Object)this.ll), this.llf, I1I.lI((Object)this.ll), 0, this.lif - this.llf);
                I57.lif(I1I.lI((Object)byArray), i, I1I.lI((Object)this.ll), this.lif - this.llf, this.llf);
                for (int j = 0; j < this.llf; ++j) {
                    byArray2[j + i] = (byte)(this.lI[j] & 0xFF ^ byArray[j + i] & 0xFF);
                }
            }
        }
    }

    protected void llf(byte[] byArray, byte[] byArray2) {
        throw new I3l("OFB isn't supported by the framework");
    }

    protected void liF(byte[] byArray, byte[] byArray2) {
        throw new I3l("CTS isn't supported by the framework");
    }

    private void lif(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new I04("inputBuffer");
        }
        if (n < 0) {
            throw new I17("inputOffset", "< 0");
        }
        if (n2 < 0) {
            throw new I17("inputCount", "< 0");
        }
        if (n > byArray.length - n2) {
            throw new I01("inputBuffer\r\nParameter name: " + I3I.lif("Overflow"));
        }
    }

    @Override
    public int transformBlock(byte[] inputBuffer, int inputOffset, int inputCount, byte[] outputBuffer, int outputOffset) {
        if (this.lIf) {
            throw new I217("Object is disposed");
        }
        this.lif(inputBuffer, inputOffset, inputCount);
        if (outputBuffer == null) {
            throw new I04("outputBuffer");
        }
        if (outputOffset < 0) {
            throw new I17("outputOffset", "< 0");
        }
        int n = outputBuffer.length - inputCount - outputOffset;
        if (!(this.l01 || 0 <= n || this.l0I.getPadding() != 1 && this.l0I.getPadding() != 3)) {
            throw new I3l("outputBuffer", I3I.lif("Overflow"));
        }
        if (this.lif()) {
            if (0 > n + this.lif) {
                throw new I3l("outputBuffer", I3I.lif("Overflow"));
            }
        } else if (0 > n) {
            if (inputBuffer.length - inputOffset - outputBuffer.length == this.lif) {
                inputCount = outputBuffer.length - outputOffset;
            } else {
                throw new I3l("outputBuffer", I3I.lif("Overflow"));
            }
        }
        return this.lif(inputBuffer, inputOffset, inputCount, outputBuffer, outputOffset);
    }

    private boolean lif() {
        return !this.l01 && this.l0I.getPadding() != 1 && this.l0I.getPadding() != 3;
    }

    private int lif(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = n;
        if (n2 != this.lif) {
            if (n2 % this.lif != 0) {
                throw new I3l("Invalid input block size.");
            }
            n4 = n2 / this.lif;
        } else {
            n4 = 1;
        }
        if (this.lif()) {
            --n4;
        }
        int n6 = 0;
        if (this.lf) {
            this.lI(this.l1, this.lIF);
            I57.lif(I1I.lI((Object)this.lIF), 0, I1I.lI((Object)byArray2), n3, this.lif);
            n3 += this.lif;
            n6 += this.lif;
            this.lf = false;
        }
        for (int i = 0; i < n4; ++i) {
            I57.lif(I1I.lI((Object)byArray), n5, I1I.lI((Object)this.l1), 0, this.lif);
            this.lI(this.l1, this.lIF);
            I57.lif(I1I.lI((Object)this.lIF), 0, I1I.lI((Object)byArray2), n3, this.lif);
            n5 += this.lif;
            n3 += this.lif;
            n6 += this.lif;
        }
        if (this.lif()) {
            I57.lif(I1I.lI((Object)byArray), n5, I1I.lI((Object)this.l1), 0, this.lif);
            this.lf = true;
        }
        return n6;
    }

    private void ll(byte[] byArray, int n, int n2) {
        if (this.l0if == null) {
            this.l0if = I151.lif();
        }
        byte[] byArray2 = new byte[n2];
        this.l0if.lif(byArray2);
        I57.lif(I1I.lI((Object)byArray2), 0, I1I.lI((Object)byArray), n, n2);
    }

    private void lif(int n, int n2, int n3) {
        String string = I254.lif(I3I.lif("Bad {0} padding."), new Object[]{n});
        if (n2 >= 0) {
            string = I254.lif(string, I254.lif(I3I.lif(" Invalid length {0}."), new Object[]{n2}));
        }
        if (n3 >= 0) {
            string = I254.lif(string, I254.lif(I3I.lif(" Error found at position {0}."), new Object[]{n3}));
        }
        throw new I3l(string);
    }

    private byte[] lI(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        int n3 = n2 / this.lif * this.lif;
        int n4 = n2 - n3;
        int n5 = n3;
        switch (this.l0I.getPadding()) {
            case 2: 
            case 4: 
            case 5: {
                n5 += this.lif;
                break;
            }
            default: {
                if (n2 == 0) {
                    return new byte[0];
                }
                if (n4 == 0) break;
                if (this.l0I.getPadding() == 1) {
                    throw new I3l("invalid block length");
                }
                byArray2 = new byte[n3 + this.lif];
                I57.lif(I1I.lI((Object)byArray), n, I1I.lI((Object)byArray2), 0, n2);
                byArray = byArray2;
                n = 0;
                n5 = n2 = byArray2.length;
            }
        }
        byArray2 = new byte[n5];
        int n6 = 0;
        while (n5 > this.lif) {
            this.lif(byArray, n, this.lif, byArray2, n6);
            n += this.lif;
            n6 += this.lif;
            n5 -= this.lif;
        }
        byte by = (byte)(this.lif - n4);
        switch (this.l0I.getPadding()) {
            case 4: {
                byArray2[byArray2.length - 1] = by;
                I57.lif(I1I.lI((Object)byArray), n, I1I.lI((Object)byArray2), n3, n4);
                this.lif(byArray2, n3, this.lif, byArray2, n3);
                break;
            }
            case 5: {
                this.ll(byArray2, byArray2.length - (by & 0xFF), (by & 0xFF) - 1);
                byArray2[byArray2.length - 1] = by;
                I57.lif(I1I.lI((Object)byArray), n, I1I.lI((Object)byArray2), n3, n4);
                this.lif(byArray2, n3, this.lif, byArray2, n3);
                break;
            }
            case 2: {
                int n7 = byArray2.length;
                while (--n7 >= byArray2.length - (by & 0xFF)) {
                    byArray2[n7] = by;
                }
                I57.lif(I1I.lI((Object)byArray), n, I1I.lI((Object)byArray2), n3, n4);
                this.lif(byArray2, n3, this.lif, byArray2, n3);
                break;
            }
            default: {
                this.lif(byArray, n, this.lif, byArray2, n6);
            }
        }
        return byArray2;
    }

    private byte[] l1(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 % this.lif > 0) {
            throw new I3l("Invalid input block size.");
        }
        int n4 = n2;
        if (this.lf) {
            n4 += this.lif;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        while (n2 > 0) {
            n3 = this.lif(byArray, n, this.lif, byArray2, n5);
            n += this.lif;
            n5 += n3;
            n2 -= this.lif;
        }
        if (this.lf) {
            this.lI(this.l1, this.lIF);
            I57.lif(I1I.lI((Object)this.lIF), 0, I1I.lI((Object)byArray2), n5, this.lif);
            n5 += this.lif;
            this.lf = false;
        }
        n3 = n4 > 0 ? byArray2[n4 - 1] & 0xFF : 0;
        switch (this.l0I.getPadding()) {
            case 4: {
                int n6;
                if (n3 == 0 || (n3 & 0xFF) > this.lif) {
                    this.lif(this.l0I.getPadding(), n3 & 0xFF, -1);
                }
                for (n6 = (n3 & 0xFF) - 1; n6 > 0; --n6) {
                    if (byArray2[n4 - 1 - n6] == 0) continue;
                    this.lif(this.l0I.getPadding(), -1, n6);
                }
                n4 -= n3 & 0xFF;
                break;
            }
            case 5: {
                if (n3 == 0 || (n3 & 0xFF) > this.lif) {
                    this.lif(this.l0I.getPadding(), n3 & 0xFF, -1);
                }
                n4 -= n3 & 0xFF;
                break;
            }
            case 2: {
                int n6;
                if (n3 == 0 || (n3 & 0xFF) > this.lif) {
                    this.lif(this.l0I.getPadding(), n3 & 0xFF, -1);
                }
                for (n6 = (n3 & 0xFF) - 1; n6 > 0; --n6) {
                    if (byArray2[n4 - 1 - n6] == n3) continue;
                    this.lif(this.l0I.getPadding(), -1, n6);
                }
                n4 -= n3 & 0xFF;
                break;
            }
        }
        if (n4 > 0) {
            byte[] byArray3 = new byte[n4];
            I57.lif(I1I.lI((Object)byArray2), 0, I1I.lI((Object)byArray3), 0, n4);
            I33I.ll(byArray2, 0, byArray2.length);
            return byArray3;
        }
        return new byte[0];
    }

    @Override
    public byte[] transformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount) {
        if (this.lIf) {
            throw new I217("Object is disposed");
        }
        this.lif(inputBuffer, inputOffset, inputCount);
        if (this.l01) {
            return this.lI(inputBuffer, inputOffset, inputCount);
        }
        return this.l1(inputBuffer, inputOffset, inputCount);
    }
}

