/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.ms.System.Security.Cryptography;

import com.aspose.pdf.internal.l1824.I3I;
import com.aspose.pdf.internal.ms.System.I04;
import com.aspose.pdf.internal.ms.System.I114;
import com.aspose.pdf.internal.ms.System.I14I;
import com.aspose.pdf.internal.ms.System.I154;
import com.aspose.pdf.internal.ms.System.I21l;
import com.aspose.pdf.internal.ms.System.I33I;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I111;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I14;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I1l;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I3l;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I84;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I91;

public abstract class SymmetricAlgorithm
implements I154 {
    protected int lI;
    protected byte[] l1;
    protected int lIF;
    protected byte[] llf;
    protected I91[] liF;
    protected I91[] lIf;
    protected int lf;
    protected int l0if = 1;
    protected int l0l = 2;
    private boolean lif = false;

    protected SymmetricAlgorithm() {
    }

    @Override
    public void dispose() {
        this.ll(true);
        I14I.lif(this);
    }

    public void clear() {
        this.ll(true);
    }

    protected void ll(boolean bl) {
        if (!this.lif) {
            if (this.llf != null) {
                I33I.ll(this.llf, 0, this.llf.length);
                this.llf = null;
            }
            if (bl) {
                // empty if block
            }
            this.lif = true;
        }
    }

    public int getBlockSize() {
        return this.lI;
    }

    public void setBlockSize(int value) {
        if (!I91.lif(this.liF, value)) {
            throw new I3l(I3I.lif("block size not supported by algorithm"));
        }
        if (this.lI != value) {
            this.lI = value;
            this.l1 = null;
        }
    }

    public int getFeedbackSize() {
        return this.lf;
    }

    public void setFeedbackSize(int value) {
        if (value <= 0 || value > this.lI) {
            throw new I3l(I3I.lif("feedback size larger than block size"));
        }
        this.lf = value;
    }

    public byte[] getIV() {
        if (this.l1 == null) {
            this.generateIV();
        }
        return (byte[])this.l1.clone();
    }

    public void setIV(byte[] value) {
        if (value == null) {
            throw new I04("value");
        }
        if (value.length << 3 != this.lI) {
            throw new I3l(I3I.lif("IV length is different than block size"));
        }
        this.l1 = (byte[])value.clone();
    }

    public byte[] getKey() {
        if (this.llf == null) {
            this.generateKey();
        }
        return (byte[])this.llf.clone();
    }

    public void setKey(byte[] value) {
        if (value == null) {
            throw new I04("value");
        }
        int n = value.length << 3;
        if (!I91.lif(this.lIf, n)) {
            throw new I3l(I3I.lif("Key size not supported by algorithm"));
        }
        this.lIF = n;
        this.llf = (byte[])value.clone();
    }

    public int getKeySize() {
        return this.lIF;
    }

    public void setKeySize(int value) {
        if (!I91.lif(this.lIf, value)) {
            throw new I3l(I3I.lif("Key size not supported by algorithm"));
        }
        this.lIF = value;
        this.llf = null;
    }

    public I91[] getLegalBlockSizes() {
        return this.liF;
    }

    public I91[] getLegalKeySizes() {
        return this.lIf;
    }

    public int getMode() {
        return this.l0if;
    }

    public void setMode(int value) {
        if (!I114.isDefined(I1l.class, (long)value)) {
            throw new I3l(I3I.lif("Cipher mode not available"));
        }
        this.l0if = value;
    }

    public int getPadding() {
        return this.l0l;
    }

    public void setPadding(int value) {
        if (!I114.isDefined(I111.class, (long)value)) {
            throw new I3l(I3I.lif("Padding mode not available"));
        }
        this.l0l = value;
    }

    public I84 createDecryptor() {
        return this.createDecryptor(this.getKey(), this.getIV());
    }

    public abstract I84 createDecryptor(byte[] var1, byte[] var2);

    public I84 createEncryptor() {
        return this.createEncryptor(this.getKey(), this.getIV());
    }

    public abstract I84 createEncryptor(byte[] var1, byte[] var2);

    public abstract void generateIV();

    public abstract void generateKey();

    public boolean validKeySize(int bitLength) {
        return I91.lif(this.lIf, bitLength);
    }

    public static SymmetricAlgorithm create() {
        return SymmetricAlgorithm.create("System.Security.Cryptography.SymmetricAlgorithm");
    }

    public static SymmetricAlgorithm create(String algName) {
        return (SymmetricAlgorithm)I14.lif(algName);
    }

    public String toString() {
        String string = I21l.lif(this).l1I().substring(I21l.lif(this).l1I().lastIndexOf(46) + 1);
        return "System.Security.Cryptography." + string;
    }
}

