/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l190I;

import com.aspose.pdf.internal.l1601.I21;
import com.aspose.pdf.internal.l1881.I1;
import com.aspose.pdf.internal.l188I.I0l;
import com.aspose.pdf.internal.l188I.I37;
import com.aspose.pdf.internal.l190I.I0I;
import com.aspose.pdf.internal.l190I.I27;
import com.aspose.pdf.internal.l190I.I7;
import com.aspose.pdf.internal.l190I.II;
import com.aspose.pdf.internal.l190I.Il;
import com.aspose.pdf.internal.l1961.I4;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I9l;
import com.aspose.pdf.internal.ms.System.IO.I44;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I3l;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

public class I24
extends I27
implements II {
    private final AttributeCertificate lif;
    private final I9l ll = new I9l();
    private final I9l lI = new I9l();

    private static AttributeCertificate lif(Stream stream) {
        try {
            return AttributeCertificate.getInstance((Object)new ASN1InputStream(stream.toInputStream()).readObject());
        }
        catch (Exception exception) {
            throw new I3l("exception decoding certificate structure", exception);
        }
    }

    public I24(Stream stream) {
        this(I24.lif(stream));
    }

    public I24(byte[] byArray) {
        this(new I5l(byArray, false));
    }

    public I24(AttributeCertificate attributeCertificate) {
        this.lif = attributeCertificate;
        try {
            I9l.lif(attributeCertificate.getAcinfo().getAttrCertValidityPeriod().getNotAfterTime().getDate()).llf(this.lI);
            I9l.lif(attributeCertificate.getAcinfo().getAttrCertValidityPeriod().getNotBeforeTime().getDate()).llf(this.ll);
        }
        catch (Exception exception) {
            throw new I44("invalid data structure in certificate!", exception);
        }
    }

    @Override
    public int lif() {
        return this.lif.getAcinfo().getVersion().getValue().intValue() + 1;
    }

    @Override
    public BigInteger ll() {
        return this.lif.getAcinfo().getSerialNumber().getValue();
    }

    @Override
    public I7 lIF() {
        return new I7((ASN1Sequence)this.lif.getAcinfo().getHolder().toASN1Primitive());
    }

    @Override
    public Il llf() {
        return new Il(this.lif.getAcinfo().getIssuer());
    }

    @Override
    public I9l lI() {
        return this.ll;
    }

    @Override
    public I9l l1() {
        return this.lI;
    }

    @Override
    public boolean[] lIf() {
        DERBitString dERBitString = this.lif.getAcinfo().getIssuerUniqueID();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (I4.lIF((Object)byArray[i / 8], 6) & 128 >> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean lf() {
        return this.lif(I9l.l0IF().l2iF());
    }

    @Override
    public boolean lif(I9l i9l) {
        return i9l.lif(this.lI().l2iF()) >= 0 && i9l.lif(this.l1().l2iF()) <= 0;
    }

    @Override
    public void l0if() {
        this.ll(I9l.l0IF().l2iF());
    }

    @Override
    public void ll(I9l i9l) {
        if (i9l.lif(this.l1().l2iF()) > 0) {
            throw new com.aspose.pdf.internal.l1881.II(I254.lif(new Object[]{"certificate expired on ", I4.lif(this.l1())}));
        }
        if (i9l.lif(this.lI().l2iF()) < 0) {
            throw new I1(I254.lif(new Object[]{"certificate not valid until ", I4.lif(this.lI())}));
        }
    }

    @Override
    public byte[] l0l() {
        return this.lif.getSignatureValue().getBytes();
    }

    @Override
    public void lif(AsymmetricKeyParameter asymmetricKeyParameter) {
        if (!this.lif.getSignatureAlgorithm().equals((Object)this.lif.getAcinfo().getSignature())) {
            throw new com.aspose.pdf.internal.l1881.Il("Signature algorithm in certificate info not same as outer certificate");
        }
        Signer signer = I37.lI(this.lif.getSignatureAlgorithm().getObjectId().getId());
        signer.init(false, (CipherParameters)asymmetricKeyParameter);
        try {
            byte[] byArray = this.lif.getAcinfo().getEncoded();
            signer.update(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new I0l("Exception encoding certificate info object", exception);
        }
        if (!signer.verifySignature(this.l0l())) {
            throw new com.aspose.pdf.internal.l188I.Il("Public key presented not for certificate signature");
        }
    }

    @Override
    public byte[] l0I() {
        try {
            return this.lif.getEncoded();
        }
        catch (IOException iOException) {
            throw new I3l(iOException.getMessage());
        }
    }

    @Override
    protected X509Extensions l1lf() {
        return X509Extensions.getInstance((Object)this.lif.getAcinfo().getExtensions());
    }

    @Override
    public I0I[] liF() {
        ASN1Sequence aSN1Sequence = this.lif.getAcinfo().getAttributes();
        I0I[] i0IArray = new I0I[aSN1Sequence.size()];
        for (int i = 0; i != aSN1Sequence.size(); ++i) {
            i0IArray[i] = new I0I(aSN1Sequence.getObjectAt(i));
        }
        return i0IArray;
    }

    @Override
    public I0I[] lif(String string) {
        ASN1Sequence aSN1Sequence = this.lif.getAcinfo().getAttributes();
        I21 i21 = com.aspose.pdf.internal.l1884.II.lif();
        for (int i = 0; i != aSN1Sequence.size(); ++i) {
            I0I i0I = new I0I(aSN1Sequence.getObjectAt(i));
            if (!I254.lIF(i0I.lif(), string)) continue;
            i21.lif(i0I);
        }
        if (i21.size() < 1) {
            return null;
        }
        I0I[] i0IArray = new I0I[i21.size()];
        for (int i = 0; i < i21.size(); ++i) {
            i0IArray[i] = (I0I)i21.ll(i);
        }
        return i0IArray;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        I24 i24 = (I24)((Object)I4.lif(obj, I24.class));
        if (i24 == null) {
            return false;
        }
        return this.lif.equals((Object)i24.lif);
    }

    public int hashCode() {
        return this.lif.hashCode();
    }
}

